/*
 * Decompiled with CFR 0.152.
 */
package tinker_io.gui;

import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;
import tinker_io.registry.BlockRegistry;
import tinker_io.tileentity.TileEntityFuelInputMachine;

public class GuiFuelInputMachine
extends GuiContainer {
    private InventoryPlayer playerInv;
    private static final ResourceLocation BG_TEXTURE = new ResourceLocation("tinker_io", "textures/gui/fuel_input_machine.png");
    public static final int WIDTH = 176;
    public static final int HEIGHT = 166;
    private TileEntityFuelInputMachine tile;

    public GuiFuelInputMachine(Container container, TileEntityFuelInputMachine tile, InventoryPlayer playerInv) {
        super(container);
        this.playerInv = playerInv;
        this.field_146999_f = 176;
        this.field_147000_g = 166;
        this.tile = tile;
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        this.func_191948_b(mouseX, mouseY);
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(BG_TEXTURE);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.func_73729_b(this.field_147003_i - 110, this.field_147009_r + 10, 146, 170, 110, 60);
        int progress = this.tile.getScaledBurningCount(13);
        if (this.tile.getCurrentSolidFuelTemp() == 0) {
            progress = 13;
        }
        this.func_73729_b(this.field_147003_i + 103, this.field_147009_r + 36 + progress, 176, 33 + progress, 13, 13 - progress);
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String name = I18n.func_135052_a((String)(BlockRegistry.fuelInputMachine.func_149739_a() + ".name"), (Object[])new Object[0]);
        this.field_146289_q.func_78276_b(name, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(name) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b(this.playerInv.func_145748_c_().func_150260_c(), 8, this.field_147000_g - 94, 0x404040);
        String temperatureInfo = I18n.func_135052_a((String)"tio.gui.fim.temperature", (Object[])new Object[0]) + " :";
        this.field_146289_q.func_78276_b(temperatureInfo, -55 - this.field_146289_q.func_78256_a(temperatureInfo) / 2, 14, 0x404040);
        String currentTempture = String.valueOf(this.tile.getTargetTemp());
        this.field_146289_q.func_78276_b(currentTempture, -55 - this.field_146289_q.func_78256_a(currentTempture) / 2, 26, 0x404040);
        double ratio = this.tile.getRatio();
        String msgRatio = TextFormatting.DARK_GREEN + "Ratio : " + ratio;
        this.field_146289_q.func_78276_b(msgRatio, -55 - this.field_146289_q.func_78256_a(msgRatio) / 2, 37, 0x404040);
        if (this.tile.getCurrentSolidFuelTemp() == 0) {
            String warn = TextFormatting.RED + I18n.func_135052_a((String)"tio.gui.fim.error_message", (Object[])new Object[0]);
            this.field_146289_q.func_78276_b(warn, -55 - this.field_146289_q.func_78256_a(warn) / 2, 49, 0x404040);
        }
    }
}

