/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.funkylocomotion;

import com.google.common.collect.Lists;
import com.rwtema.funkylocomotion.CreativeTabFrames;
import com.rwtema.funkylocomotion.EntityMovingEventHandler;
import com.rwtema.funkylocomotion.LogHelper;
import com.rwtema.funkylocomotion.Proxy;
import com.rwtema.funkylocomotion.Recipes;
import com.rwtema.funkylocomotion.api.FunkyRegistry;
import com.rwtema.funkylocomotion.api.IMoveCheck;
import com.rwtema.funkylocomotion.blocks.TilePusher;
import com.rwtema.funkylocomotion.compat.CompatHandler;
import com.rwtema.funkylocomotion.compat.FunkyRegistryImpl;
import com.rwtema.funkylocomotion.movers.MoverEventHandler;
import com.rwtema.funkylocomotion.network.FLNetwork;
import com.rwtema.funkylocomotion.proxydelegates.ProxyRegistry;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.SidedProxy;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLInterModComms;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;

@Mod(modid="funkylocomotion", version="1.0", acceptedMinecraftVersions="[1.12.2]")
public class FunkyLocomotion {
    public static final String MODID = "funkylocomotion";
    public static final String VERSION = "1.0";
    public static final CreativeTabFrames creativeTabFrames = new CreativeTabFrames();
    @SidedProxy(serverSide="com.rwtema.funkylocomotion.Proxy", clientSide="com.rwtema.funkylocomotion.ProxyClient")
    public static Proxy proxy;
    public static boolean redrawChunksInstantly;
    public static List<Runnable> toRunAfterBlocksExists;
    final IMoveCheck BLACKLIST = (worldObj, pos, profile) -> EnumActionResult.FAIL;

    @Mod.EventHandler
    public void preinit(FMLPreInitializationEvent event) {
        LogHelper.info("Let's Move!", new Object[0]);
        FLNetwork.init();
        Configuration config = new Configuration(event.getSuggestedConfigurationFile());
        config.load();
        TilePusher.maxTiles = config.get("general", "maximumBlocksPushed", 1024).getInt(1024);
        TilePusher.powerPerTile = config.get("general", "energyPerBlock", 250).getInt(250);
        Recipes.shouldAddRecipes = config.get("general", "addRecipes", true).getBoolean(true);
        Recipes.shouldAddFrameCopyResetRecipes = config.get("general", "addFrameCopyResetRecipes", true).getBoolean(true);
        redrawChunksInstantly = config.get("client", "redrawChunksInstantly", true).getBoolean(true);
        if (config.hasChanged()) {
            config.save();
        }
        EntityMovingEventHandler.init();
        MoverEventHandler.init();
        CompatHandler.initCompat(event.getAsmData());
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        toRunAfterBlocksExists.forEach(Runnable::run);
        toRunAfterBlocksExists.clear();
        try {
            Class.forName("cofh.api.block.IBlockAppearance");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    @Mod.EventHandler
    public void handleIMC(FMLInterModComms.IMCEvent event) {
        for (FMLInterModComms.IMCMessage msg : event.getMessages()) {
            if (!"blacklist".equals(msg.key) || !msg.isStringMessage()) continue;
            String s = msg.getStringValue();
            ResourceLocation location = new ResourceLocation(s);
            Block object = (Block)Block.field_149771_c.func_82594_a((Object)location);
            if (object != Blocks.field_150350_a) {
                ProxyRegistry.register(object, IMoveCheck.class, this.BLACKLIST);
                continue;
            }
            try {
                Class<?> aClass = Class.forName(s);
                ProxyRegistry.register(aClass, IMoveCheck.class, this.BLACKLIST);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
    }

    static {
        toRunAfterBlocksExists = Lists.newLinkedList();
        FunkyRegistry.INSTANCE = new FunkyRegistryImpl();
    }
}

