/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.plugins.guideapi.book;

import amerifrance.guideapi.api.impl.Book;
import amerifrance.guideapi.api.impl.Entry;
import amerifrance.guideapi.api.impl.abstraction.CategoryAbstract;
import amerifrance.guideapi.api.impl.abstraction.EntryAbstract;
import amerifrance.guideapi.api.util.PageHelper;
import amerifrance.guideapi.category.CategoryItemStack;
import ipsis.Woot;
import ipsis.woot.configuration.ChangeLog;
import ipsis.woot.plugins.guideapi.book.CategoryUtils;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;

public class CategoryChangelog {
    public static void buildCategory(Book book) {
        String keyBase = "guide.woot.entry.changelog.";
        String title = "guide.woot.category.changelog";
        CategoryItemStack category = new CategoryItemStack("guide.woot.category.changelog", new ItemStack(Items.field_151164_bB));
        category.withKeyBase("guide.woot.entry.changelog.");
        for (ChangeLog.Changes changes : Woot.changeLog.getLibrary()) {
            String desc;
            category.addEntry(changes.version, (EntryAbstract)new Entry(changes.version, true));
            StringBuilder sb = new StringBuilder();
            if (!changes.featureMap.keySet().isEmpty()) {
                sb.append("Features\n========\n\n");
                for (Integer id : changes.featureMap.keySet()) {
                    desc = changes.featureMap.get(id);
                    if (id < 0) {
                        sb.append("[####]\n");
                    } else {
                        sb.append(String.format("[%04d]\n", id));
                    }
                    sb.append(desc).append("\n");
                }
                sb.append("\n");
            }
            if (!changes.fixMap.keySet().isEmpty()) {
                sb.append("Fixes\n=====\n\n");
                for (Integer id : changes.fixMap.keySet()) {
                    desc = changes.fixMap.get(id);
                    if (id < 0) {
                        sb.append("[####]\n");
                    } else {
                        sb.append(String.format("[%04d]\n", id));
                    }
                    sb.append(desc).append("\n");
                }
                sb.append("\n");
            }
            category.getEntry(changes.version).addPageList(PageHelper.pagesForLongText((String)sb.toString(), (int)240));
        }
        CategoryUtils.toUnicodeAndBeyond(category.entries);
        book.addCategory((CategoryAbstract)category);
    }
}

