/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.item;

import com.mojang.realmsclient.gui.ChatFormatting;
import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.init.ModItems;
import ipsis.woot.item.ItemWoot;
import ipsis.woot.util.StringHelper;
import ipsis.woot.util.WootMob;
import ipsis.woot.util.WootMobBuilder;
import ipsis.woot.util.WootMobName;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.ItemMeshDefinition;
import net.minecraft.client.renderer.block.model.ModelBakery;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class ItemEnderShard
extends ItemWoot {
    public static final String BASENAME = "endershard";

    public ItemEnderShard() {
        super(BASENAME);
        this.func_77625_d(1);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        final ModelResourceLocation emptyModel = new ModelResourceLocation(this.getRegistryName() + "_empty", "inventory");
        final ModelResourceLocation fullModel = new ModelResourceLocation(this.getRegistryName(), "inventory");
        ModelBakery.registerItemVariants((Item)this, (ResourceLocation[])new ResourceLocation[]{emptyModel, fullModel});
        ModelLoader.setCustomMeshDefinition((Item)this, (ItemMeshDefinition)new ItemMeshDefinition(){

            public ModelResourceLocation func_178113_a(ItemStack stack) {
                if (ItemEnderShard.isProgrammed(stack)) {
                    return fullModel;
                }
                return emptyModel;
            }
        });
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        if (attacker.func_130014_f_().field_72995_K || !(attacker instanceof EntityPlayer)) {
            return false;
        }
        if (ItemEnderShard.isProgrammed(stack)) {
            return false;
        }
        WootMob wootMob = WootMobBuilder.create((EntityLiving)target);
        if (!wootMob.isValid()) {
            return false;
        }
        if (!Woot.policyRepository.canCapture(wootMob.getWootMobName())) {
            ((EntityPlayer)attacker).func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.endershard.failure")), false);
            return false;
        }
        NBTTagCompound nbtTagCompound = stack.func_77978_p();
        if (nbtTagCompound == null) {
            nbtTagCompound = new NBTTagCompound();
        }
        WootMobBuilder.writeToNBT(wootMob, nbtTagCompound);
        stack.func_77982_d(nbtTagCompound);
        ((EntityPlayer)attacker).func_146105_b((ITextComponent)new TextComponentString(StringHelper.localize("chat.woot.endershard.success")), false);
        return true;
    }

    public static boolean isEnderShard(ItemStack itemStack) {
        return itemStack.func_77973_b() == ModItems.itemEnderShard;
    }

    public static boolean isProgrammed(ItemStack itemStack) {
        if (!ItemEnderShard.isEnderShard(itemStack)) {
            return false;
        }
        WootMob wootMob = WootMobBuilder.create(itemStack.func_77978_p());
        return wootMob.isValid();
    }

    public static boolean isFull(ItemStack itemStack) {
        if (!ItemEnderShard.isProgrammed(itemStack)) {
            return false;
        }
        WootMob wootMob = WootMobBuilder.create(itemStack.func_77978_p());
        if (!wootMob.isValid()) {
            return false;
        }
        return wootMob.getDeaths() >= Woot.wootConfiguration.getInteger(wootMob.getWootMobName(), EnumConfigKey.KILL_COUNT);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        if (!ItemEnderShard.isEnderShard(stack)) {
            return;
        }
        if (ItemEnderShard.isJEIEnderShard(stack)) {
            tooltip.add(ChatFormatting.BLUE + StringHelper.localize("info.woot.endershard.a.1"));
            return;
        }
        tooltip.add(StringHelper.getInfoText("info.woot.endershard.0"));
        tooltip.add(StringHelper.getInfoText("info.woot.endershard.1"));
        tooltip.add(StringHelper.getInfoText("info.woot.endershard.2"));
        tooltip.add(StringHelper.getInfoText("info.woot.endershard.3"));
        if (!ItemEnderShard.isProgrammed(stack)) {
            String out = StringHelper.getInfoText("info.woot.endershard.a.0");
            tooltip.add(ChatFormatting.RED + out);
        } else {
            WootMob wootMob = WootMobBuilder.create(stack.func_77978_p());
            if (wootMob.isValid()) {
                String name = wootMob.getDisplayName();
                if (ItemEnderShard.isFull(stack)) {
                    String out = StringHelper.localizeFormat("info.woot.endershard.b.1", name);
                    tooltip.add(ChatFormatting.BLUE + out);
                } else {
                    int deaths = wootMob.getDeaths();
                    deaths = MathHelper.func_76125_a((int)deaths, (int)0, (int)Woot.wootConfiguration.getInteger(wootMob.getWootMobName(), EnumConfigKey.KILL_COUNT));
                    String out = StringHelper.localizeFormat("info.woot.endershard.b.0", name, deaths, Woot.wootConfiguration.getInteger(wootMob.getWootMobName(), EnumConfigKey.KILL_COUNT));
                    tooltip.add(ChatFormatting.RED + out);
                }
                if (flagIn.func_194127_a()) {
                    tooltip.add(wootMob.getWootMobName().getName());
                }
            }
        }
    }

    public static void incrementDeaths(ItemStack itemStack, int count) {
        if (!ItemEnderShard.isEnderShard(itemStack)) {
            return;
        }
        if (!ItemEnderShard.isProgrammed(itemStack)) {
            return;
        }
        WootMob wootMob = WootMobBuilder.create(itemStack.func_77978_p());
        if (!wootMob.isValid()) {
            return;
        }
        wootMob.incrementDeathCount(count);
        WootMobBuilder.writeToNBT(wootMob, itemStack.func_77978_p());
    }

    public static boolean isMob(ItemStack itemStack, WootMobName wootMobName) {
        if (!ItemEnderShard.isEnderShard(itemStack)) {
            return false;
        }
        if (!ItemEnderShard.isProgrammed(itemStack)) {
            return false;
        }
        WootMob wootMob = WootMobBuilder.create(itemStack.func_77978_p());
        if (!wootMob.isValid()) {
            return false;
        }
        return wootMob.getWootMobName().equals(wootMobName);
    }

    public static boolean isJEIEnderShard(ItemStack itemStack) {
        return itemStack.func_77942_o() && itemStack.func_77978_p().func_74764_b("nbt_jei_shard");
    }

    public static void setJEIEnderShared(ItemStack itemStack) {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74768_a("nbt_jei_shard", 1);
        itemStack.func_77982_d(tagCompound);
    }

    public boolean func_77636_d(ItemStack stack) {
        return ItemEnderShard.isJEIEnderShard(stack) || ItemEnderShard.isProgrammed(stack) && ItemEnderShard.isFull(stack);
    }
}

