/*
 * Decompiled with CFR 0.152.
 */
package ipsis.woot.enchantment;

import ipsis.Woot;
import ipsis.woot.configuration.EnumConfigKey;
import ipsis.woot.util.DebugSetup;
import ipsis.woot.util.SkullHelper;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityWitherSkeleton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.event.entity.living.LivingDropsEvent;

public class EnchantmentHeadhunter
extends Enchantment {
    private static final String NAME = "headhunter";

    public EnchantmentHeadhunter() {
        super(Enchantment.Rarity.RARE, EnumEnchantmentType.WEAPON, new EntityEquipmentSlot[]{EntityEquipmentSlot.MAINHAND});
        this.func_77322_b(NAME);
        this.setRegistryName(NAME);
    }

    public String func_77320_a() {
        return "enchant.woot.headhunter";
    }

    public int func_77325_b() {
        return 3;
    }

    public int func_77321_a(int enchantmentLevel) {
        return 16;
    }

    public int func_77317_b(int enchantmentLevel) {
        return 60;
    }

    private static EntityItem createEntityItem(World world, ItemStack itemStack, double x, double y, double z) {
        if (world == null || itemStack.func_190926_b()) {
            return null;
        }
        EntityItem entityItem = new EntityItem(world, x, y, z, itemStack);
        entityItem.func_174869_p();
        return entityItem;
    }

    private static boolean containsSkull(List<EntityItem> drops) {
        boolean found = false;
        for (EntityItem i : drops) {
            if (i == null || i.func_92059_d().func_77973_b() != Items.field_151144_bL) continue;
            found = true;
            break;
        }
        return found;
    }

    private static boolean hasDecapitated(int level) {
        float chance;
        if (level < 1) {
            return false;
        }
        if (level == 1) {
            chance = Woot.wootConfiguration.getInteger(EnumConfigKey.HEADHUNTER_1_CHANCE);
        } else if (level == 2) {
            chance = Woot.wootConfiguration.getInteger(EnumConfigKey.HEADHUNTER_2_CHANCE);
        } else if (level == 3) {
            chance = Woot.wootConfiguration.getInteger(EnumConfigKey.HEADHUNTER_3_CHANCE);
        } else {
            return false;
        }
        float rolled = Woot.RANDOM.nextFloat();
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.DECAP, "EnchantmentHeadhunter:hasDecapitated", "rolled:" + rolled + " chance:" + chance / 100.0f);
        return rolled <= chance / 100.0f;
    }

    private static Map<Enchantment, Integer> getEnchantMap(EntityPlayer entityPlayer) {
        if (entityPlayer == null) {
            return Collections.emptyMap();
        }
        ItemStack itemStack = entityPlayer.func_184614_ca();
        if (itemStack.func_190926_b()) {
            return Collections.emptyMap();
        }
        return EnchantmentHelper.func_82781_a((ItemStack)itemStack);
    }

    private static int getHeadhunterLevel(Map<Enchantment, Integer> enchantmentIntegerMap) {
        for (Enchantment e : enchantmentIntegerMap.keySet()) {
            if (!(e instanceof EnchantmentHeadhunter)) continue;
            return enchantmentIntegerMap.get(e);
        }
        return 0;
    }

    public static void handleLivingDrops(LivingDropsEvent e) {
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.DECAP, "EnchantmentHeadhunter:handleLivingDrops", e);
        if (!(e.getSource().func_76346_g() instanceof EntityPlayer)) {
            return;
        }
        if (!(e.getEntityLiving() instanceof EntityLiving)) {
            return;
        }
        EntityPlayer entityPlayer = (EntityPlayer)e.getSource().func_76346_g();
        EntityLiving entityLiving = (EntityLiving)e.getEntityLiving();
        if (entityPlayer instanceof FakePlayer) {
            return;
        }
        if (entityLiving instanceof EntityWitherSkeleton) {
            return;
        }
        int level = EnchantmentHeadhunter.getHeadhunterLevel(EnchantmentHeadhunter.getEnchantMap(entityPlayer));
        Woot.debugSetup.trace(DebugSetup.EnumDebugType.DECAP, "EnchantmentHeadhunter:handleLivingDrops", "headhunterLevel:" + level);
        if (EnchantmentHeadhunter.hasDecapitated(level) && !EnchantmentHeadhunter.containsSkull(e.getDrops())) {
            EntityItem entityItem;
            ItemStack itemStack = SkullHelper.getSkull(entityLiving);
            Woot.debugSetup.trace(DebugSetup.EnumDebugType.DECAP, "EnchantmentHeadhunter:handleLivingDrops", "skull:" + itemStack);
            if (!itemStack.func_190926_b() && (entityItem = EnchantmentHeadhunter.createEntityItem(e.getSource().func_76346_g().func_130014_f_(), itemStack.func_77946_l(), e.getEntityLiving().func_180425_c().func_177958_n(), e.getEntityLiving().func_180425_c().func_177956_o(), e.getEntityLiving().func_180425_c().func_177952_p())) != null) {
                e.getDrops().add(entityItem);
            }
        }
    }
}

