/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.items;

import com.bafomdad.realfilingcabinet.RealFilingCabinet;
import com.bafomdad.realfilingcabinet.TabRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.TextHelper;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.inventory.InventorySuitcase;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.NBTUtils;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemHandlerHelper;
import org.lwjgl.input.Keyboard;
import vazkii.botania.api.item.IBlockProvider;

@Optional.Interface(iface="vazkii.botania.api.item.IBlockProvider", modid="botania")
public class ItemSuitcase
extends Item
implements IBlockProvider {
    private final String TAG_INDEX = "RFC:placeIndex";
    private static final String TAG_FOLDERS = "InvFolders";

    public ItemSuitcase() {
        this.setRegistryName("suitcase");
        this.func_77655_b("realfilingcabinet.suitcase");
        this.func_77625_d(1);
        this.func_77637_a(TabRFC.instance);
    }

    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        if (!stack.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null)) {
            return super.getNBTShareTag(stack);
        }
        NBTTagCompound tag = stack.func_77942_o() ? stack.func_77978_p().func_74737_b() : new NBTTagCompound();
        IItemHandlerModifiable inv = ItemSuitcase.getInventory(stack);
        tag.func_74782_a(TAG_FOLDERS, CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)inv, null));
        return tag;
    }

    public void func_77624_a(ItemStack stack, World player, List<String> list, ITooltipFlag whatisthis) {
        list.add(TextFormatting.GOLD + "Current place index: " + TextFormatting.RESET + this.getIndex(stack));
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getInventory(stack);
        if (suitcaseInv != null) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.listItems(suitcaseInv, list);
            } else if (list.size() > 2) {
                list.remove(2);
            }
        }
    }

    private void listItems(IItemHandlerModifiable inv, List<String> list) {
        for (int i = 0; i < inv.getSlots(); ++i) {
            ItemStack folder = inv.getStackInSlot(i);
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.folder && folder.func_77973_b() != RFCItems.dyedFolder) continue;
            String name = TextHelper.folderStr(folder);
            long count = ItemFolder.getFileSize(folder);
            list.add(TextHelper.format(count) + " " + name);
        }
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, @Nonnull EnumHand hand) {
        if (hand == EnumHand.MAIN_HAND) {
            player.openGui((Object)RealFilingCabinet.instance, 1, world, 0, 0, 0);
            return ActionResult.newResult((EnumActionResult)EnumActionResult.SUCCESS, (Object)player.func_184586_b(hand));
        }
        return ActionResult.newResult((EnumActionResult)EnumActionResult.PASS, (Object)player.func_184586_b(hand));
    }

    @Nonnull
    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing side, float x, float y, float z) {
        ItemStack heldStack = player.func_184586_b(hand);
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getInventory(heldStack);
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityRFC) {
            if (!world.field_72995_K) {
                boolean flag;
                TileEntityRFC tileRFC = (TileEntityRFC)tile;
                if (!tileRFC.isOpen) {
                    return EnumActionResult.FAIL;
                }
                boolean bl = flag = ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)suitcaseInv) > 0;
                if (flag) {
                    if (ItemHandlerHelper.calcRedstoneFromInventory((IItemHandler)tileRFC.getInventory()) > 0) {
                        return EnumActionResult.FAIL;
                    }
                    for (int i = 0; i < suitcaseInv.getSlots(); ++i) {
                        ItemStack stack = suitcaseInv.getStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        tileRFC.getInventory().setStackInSlot(i, stack);
                        suitcaseInv.extractItem(i, 1, false);
                    }
                } else {
                    for (int i = 0; i < tileRFC.getInventory().getSlots(); ++i) {
                        ItemStack stack = tileRFC.getInventory().getTrueStackInSlot(i);
                        if (stack.func_190926_b()) continue;
                        suitcaseInv.insertItem(i, stack, false);
                        tileRFC.getInventory().setStackInSlot(i, ItemStack.field_190927_a);
                    }
                }
                tileRFC.markBlockForUpdate();
            }
            return EnumActionResult.SUCCESS;
        }
        ItemStack stackToPlace = this.getStoredItem(heldStack, suitcaseInv, false).func_77946_l();
        if (!stackToPlace.func_190926_b()) {
            ItemStack savedSuitcase = player.func_184586_b(hand);
            player.func_184611_a(hand, stackToPlace);
            EnumActionResult ear = stackToPlace.func_179546_a(player, world, pos, hand, side, x, y, z);
            player.func_184611_a(hand, savedSuitcase);
            if (ear == EnumActionResult.SUCCESS) {
                if (!world.field_72995_K && !player.field_71075_bZ.field_75098_d) {
                    this.getStoredItem(savedSuitcase, suitcaseInv, true);
                }
                return EnumActionResult.SUCCESS;
            }
        }
        return EnumActionResult.PASS;
    }

    @Nonnull
    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound tag) {
        return new InventorySuitcase.InvProvider();
    }

    public static IItemHandlerModifiable getInventory(ItemStack stack) {
        return (IItemHandlerModifiable)stack.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public static ItemStack getFolder(ItemStack suitcase, ItemStack toPickup) {
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getInventory(suitcase);
        for (int i = 0; i < suitcaseInv.getSlots(); ++i) {
            Object obj;
            ItemStack folder = suitcaseInv.getStackInSlot(i);
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.folder && folder.func_77973_b() != RFCItems.dyedFolder || !((obj = ItemFolder.getObject(folder)) instanceof ItemStack) || !ItemStack.func_179545_c((ItemStack)((ItemStack)obj), (ItemStack)toPickup)) continue;
            return folder;
        }
        return ItemStack.field_190927_a;
    }

    private ItemStack getStoredItem(ItemStack suitcase, IItemHandlerModifiable inv, boolean subtract) {
        Object obj;
        ItemStack folder = inv.getStackInSlot(this.getIndex(suitcase));
        if (!folder.func_190926_b() && (obj = ItemFolder.getObject(folder)) instanceof ItemStack && !((ItemStack)obj).func_190926_b() && ((ItemStack)obj).func_77973_b() instanceof ItemBlock) {
            if (ItemFolder.getFileSize(folder) <= 0L) {
                return ItemStack.field_190927_a;
            }
            if (subtract) {
                ItemFolder.remove(folder, 1L);
            }
            return (ItemStack)obj;
        }
        return ItemStack.field_190927_a;
    }

    private int getStoredBlock(ItemStack stack, Block block, int meta) {
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getInventory(stack);
        for (int i = 0; i < suitcaseInv.getSlots(); ++i) {
            Object obj;
            ItemStack folder = suitcaseInv.getStackInSlot(i);
            if (folder.func_190926_b() || folder.func_77973_b() != RFCItems.folder && folder.func_77973_b() != RFCItems.folder || !((obj = ItemFolder.getObject(folder)) instanceof ItemStack) || !(((ItemStack)obj).func_77973_b() instanceof ItemBlock) || Block.func_149634_a((Item)((ItemStack)obj).func_77973_b()) != block || meta != ItemFolder.getFileMeta(folder)) continue;
            return i;
        }
        return -1;
    }

    private int getStoredCount(ItemStack stack, int slot) {
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getInventory(stack);
        return (int)Math.min(Integer.MAX_VALUE, ItemFolder.getFileSize(suitcaseInv.getStackInSlot(slot)));
    }

    private void setStoredCount(ItemStack stack, int slot) {
        IItemHandlerModifiable suitcaseInv = ItemSuitcase.getInventory(stack);
        ItemFolder.remove(suitcaseInv.getStackInSlot(slot), 1L);
    }

    public int getIndex(ItemStack stack) {
        return NBTUtils.getInt(stack, "RFC:placeIndex", 0);
    }

    public void cycleIndex(ItemStack stack, boolean add) {
        int i = this.getIndex(stack);
        if (add && i + 1 < 8) {
            NBTUtils.setInt(stack, "RFC:placeIndex", i + 1);
        } else if (add && i + 1 >= 8) {
            NBTUtils.setInt(stack, "RFC:placeIndex", 0);
        }
        if (!add && i > 0) {
            NBTUtils.setInt(stack, "RFC:placeIndex", i - 1);
        } else if (!add && i - 1 <= 0) {
            NBTUtils.setInt(stack, "RFC:placeIndex", 7);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity entity, int slot, boolean selected) {
        if (stack.func_77978_p() != null && stack.func_77978_p().func_74764_b(TAG_FOLDERS)) {
            NBTTagList tagList = stack.func_77978_p().func_150295_c(TAG_FOLDERS, 10);
            IItemHandlerModifiable inv = ItemSuitcase.getInventory(stack);
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)inv, null, (NBTBase)tagList);
            stack.func_77978_p().func_82580_o(TAG_FOLDERS);
            if (stack.func_77978_p().func_186856_d() == 0) {
                stack.func_77982_d(null);
            }
        }
    }

    public boolean provideBlock(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta, boolean doit) {
        int count;
        if (player.field_70170_p.field_72995_K) {
            return false;
        }
        int slot = this.getStoredBlock(stack, block, meta);
        if (slot >= 0 && (count = this.getStoredCount(stack, slot)) > 0) {
            if (doit) {
                this.setStoredCount(stack, slot);
            }
            return true;
        }
        return false;
    }

    public int getBlockCount(EntityPlayer player, ItemStack requestor, ItemStack stack, Block block, int meta) {
        int slot = this.getStoredBlock(stack, block, meta);
        if (slot >= 0) {
            return this.getStoredCount(stack, slot);
        }
        return 0;
    }
}

