/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.inventory;

import com.bafomdad.realfilingcabinet.api.IFolder;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilitySerializable;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;

public class InventorySuitcase
implements IItemHandlerModifiable {
    private final IItemHandlerModifiable suitcaseInv;
    final ItemStack suitcase;

    public InventorySuitcase(ItemStack suitcase) {
        this.suitcase = suitcase;
        this.suitcaseInv = (IItemHandlerModifiable)suitcase.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, null);
    }

    public ItemStack getCase() {
        return this.suitcase;
    }

    public void setStackInSlot(int slot, ItemStack stack) {
        this.suitcaseInv.setStackInSlot(slot, stack);
    }

    public int getSlots() {
        return this.suitcaseInv.getSlots();
    }

    public ItemStack getStackInSlot(int slot) {
        return this.suitcaseInv.getStackInSlot(slot);
    }

    public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
        return this.suitcaseInv.insertItem(slot, stack, simulate);
    }

    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        return this.suitcaseInv.extractItem(slot, amount, simulate);
    }

    public int getSlotLimit(int slot) {
        return this.suitcaseInv.getSlotLimit(slot);
    }

    public static class InvProvider
    implements ICapabilitySerializable<NBTBase> {
        private final IItemHandler inv = new ItemStackHandler(8){

            @Nonnull
            public ItemStack insertItem(int slot, @Nonnull ItemStack toInsert, boolean simulate) {
                if (!toInsert.func_190926_b() && toInsert.func_77973_b() instanceof IFolder) {
                    if (toInsert.func_77973_b() == RFCItems.folder && toInsert.func_77952_i() == ItemFolder.FolderType.ENDER.ordinal()) {
                        return toInsert;
                    }
                    return super.insertItem(slot, toInsert, simulate);
                }
                return toInsert;
            }
        };

        public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
            return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY;
        }

        public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
            if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
                return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.inv);
            }
            return null;
        }

        public NBTBase serializeNBT() {
            return CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.writeNBT((Object)this.inv, null);
        }

        public void deserializeNBT(NBTBase nbt) {
            CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.readNBT((Object)this.inv, null, nbt);
        }
    }
}

