/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.inventory;

import com.bafomdad.realfilingcabinet.NewConfigRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.FluidUtils;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.capability.FluidTankProperties;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import net.minecraftforge.fluids.capability.templates.EmptyFluidHandler;

public class FluidRFC
implements IFluidHandler {
    TileEntityRFC tile;
    FluidStack snapshot = null;

    public FluidRFC(TileEntityRFC tile) {
        this.tile = tile;
    }

    public IFluidTankProperties[] getTankProperties() {
        FluidTankProperties[] props = new FluidTankProperties[8];
        for (int i = 0; i < this.tile.getInventory().getSlots(); ++i) {
            ItemStack folder = this.tile.getInventory().getTrueStackInSlot(i);
            props[i] = !folder.func_190926_b() && folder.func_77952_i() == 4 && ItemFolder.getObject(folder) instanceof FluidStack ? new FluidTankProperties((FluidStack)ItemFolder.getObject(folder), Math.max(0x7FFFFFFE, (int)ItemFolder.getFileSize(folder))) : (FluidTankProperties)EmptyFluidHandler.EMPTY_TANK_PROPERTIES;
        }
        return props;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (resource != null && !this.tile.isCabinetLocked()) {
            for (int i = 0; i < this.tile.getInventory().getSlots(); ++i) {
                FluidStack loopfluid = FluidUtils.getFluidFromFolder(this.tile, i);
                if (loopfluid == null || !loopfluid.getLocalizedName().equals(resource.getLocalizedName())) continue;
                if (doFill) {
                    ItemFolder.add(this.tile.getInventory().getTrueStackInSlot(i), resource.amount);
                }
                return resource.amount;
            }
        }
        return 0;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        if (resource == null || this.tile.isCabinetLocked()) {
            return null;
        }
        return this.drain(resource.amount, doDrain);
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        ItemStack stack = this.tile.getFilter();
        if (this.tile.hasItemFrame() && stack.func_190926_b()) {
            return null;
        }
        if (this.tile.hasItemFrame() && !stack.func_190926_b()) {
            FluidStack fluid = FluidUtil.getFluidContained((ItemStack)stack);
            if (fluid == null) {
                return null;
            }
            for (int i = 0; i < this.tile.getInventory().getSlots(); ++i) {
                FluidStack loopfluid = FluidUtils.getFluidFromFolder(this.tile, i);
                if (loopfluid == null || !loopfluid.isFluidEqual(fluid)) continue;
                this.takeFluidSnapshot(loopfluid);
                FluidTank tank = new FluidTank(loopfluid, maxDrain);
                FluidStack f = tank.drain(maxDrain, doDrain);
                if (f != null && f.amount > 0 && doDrain && this.snapshot != null && this.snapshot.isFluidEqual(f) && doDrain && !UpgradeHelper.isCreative(this.tile)) {
                    if (this.snapshot.getFluid() == FluidRegistry.WATER && this.snapshot.amount >= 3000 && NewConfigRFC.ConfigRFC.infiniteWaterSource) {
                        return f;
                    }
                    ItemFolder.remove(this.tile.getInventory().getTrueStackInSlot(i), this.snapshot.amount - loopfluid.amount);
                }
                return f;
            }
        }
        return null;
    }

    private void takeFluidSnapshot(FluidStack fluid) {
        this.snapshot = fluid.copy();
    }
}

