/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.integration;

import com.bafomdad.realfilingcabinet.blocks.BlockManaCabinet;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileManaCabinet;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.helpers.UpgradeHelper;
import com.bafomdad.realfilingcabinet.inventory.InventoryRFC;
import com.bafomdad.realfilingcabinet.items.ItemFolder;
import com.bafomdad.realfilingcabinet.utils.SmeltingUtils;
import java.text.NumberFormat;
import java.util.List;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import mcp.mobius.waila.api.IWailaDataProvider;
import mcp.mobius.waila.api.IWailaRegistrar;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class WailaRFC {
    public static void register() {
        FMLInterModComms.sendMessage((String)"waila", (String)"register", (String)"com.bafomdad.realfilingcabinet.integration.WailaRFC.load");
    }

    public static void load(IWailaRegistrar registrar) {
        registrar.registerBodyProvider((IWailaDataProvider)new WailaProvider(), BlockRFC.class);
        registrar.registerBodyProvider((IWailaDataProvider)new WailaManaProvider(), BlockManaCabinet.class);
    }

    public static class WailaManaProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor arg0, IWailaConfigHandler arg1) {
            return null;
        }

        public List<String> getWailaHead(ItemStack arg0, List<String> currenttip, IWailaDataAccessor arg2, IWailaConfigHandler arg3) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            double count = ((TileManaCabinet)accessor.getTileEntity()).getTotalInternalManaPool();
            double calc = 0.0;
            if (count > 0.0) {
                calc = count / 1000000.0;
            }
            NumberFormat percentFormatter = NumberFormat.getPercentInstance();
            String percentOut = percentFormatter.format(calc);
            currenttip.add(percentOut + " of a full mana pool");
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP arg0, TileEntity arg1, NBTTagCompound arg2, World arg3, BlockPos arg4) {
            return null;
        }
    }

    public static class WailaProvider
    implements IWailaDataProvider {
        public ItemStack getWailaStack(IWailaDataAccessor arg0, IWailaConfigHandler arg1) {
            return null;
        }

        public List<String> getWailaHead(ItemStack arg0, List<String> currenttip, IWailaDataAccessor arg2, IWailaConfigHandler arg3) {
            return currenttip;
        }

        public List<String> getWailaBody(ItemStack stack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
            TileEntityRFC tileRFC = (TileEntityRFC)accessor.getTileEntity();
            InventoryRFC inv = tileRFC.getInventory();
            for (int i = 0; i < inv.getSlots(); ++i) {
                long storedSize;
                String name = "";
                ItemStack folder = inv.getTrueStackInSlot(i);
                if (folder.func_190926_b() || ItemFolder.getObject(folder) == null) continue;
                if (ItemFolder.getObject(folder) instanceof ItemStack) {
                    String stackName = ((ItemStack)ItemFolder.getObject(folder)).func_82833_r();
                    storedSize = ItemFolder.getFileSize(folder);
                    name = stackName + " - " + storedSize;
                } else if (ItemFolder.getObject(folder) instanceof FluidStack) {
                    String fluidName = ((FluidStack)ItemFolder.getObject(folder)).getLocalizedName();
                    storedSize = ItemFolder.getFileSize(folder);
                    name = fluidName + " - " + storedSize + " mB";
                } else if (ItemFolder.getObject(folder) instanceof String && folder.func_77952_i() == 3) {
                    String entityName = ItemFolder.getFolderDisplayName(folder);
                    storedSize = ItemFolder.getFileSize(folder);
                    name = entityName + " - " + storedSize;
                }
                if (name.isEmpty()) continue;
                currenttip.add(name);
            }
            String owner = "";
            if (tileRFC.getCabinetOwner() != null) {
                EntityPlayer onlinePlayer = accessor.getPlayer().field_70170_p.func_152378_a(tileRFC.getCabinetOwner());
                owner = onlinePlayer != null ? "Locked, owned by: " + onlinePlayer.func_70005_c_() : "Locked";
            }
            if (!owner.isEmpty()) {
                currenttip.add(owner);
            }
            return currenttip;
        }

        public List<String> getWailaTail(ItemStack arg0, List<String> currenttip, IWailaDataAccessor arg2, IWailaConfigHandler arg3) {
            return currenttip;
        }

        public NBTTagCompound getNBTData(EntityPlayerMP player, TileEntity tile, NBTTagCompound tag, World world, BlockPos pos) {
            if (tile instanceof TileEntityRFC && UpgradeHelper.getUpgrade((TileEntityRFC)tile, StringLibs.TAG_SMELT) != null) {
                TileEntityRFC te = (TileEntityRFC)tile;
                SmeltingUtils.writeSmeltNBT(te, tag);
            }
            return tag;
        }
    }
}

