/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import com.bafomdad.realfilingcabinet.api.IFilingCabinet;
import com.bafomdad.realfilingcabinet.api.IUpgrades;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.items.ItemUpgrades;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class UpgradeHelper {
    private static Map<ItemStack, String> upgrades = new HashMap<ItemStack, String>();

    public static void registerUpgrade(ItemStack stack, String tag) {
        if (stack.func_190926_b() || !(stack.func_77973_b() instanceof IUpgrades) || tag.isEmpty()) {
            throw new IllegalArgumentException("[RealFilingCabinet]: Register upgrades: ItemStack is not an instance of IUpgrades, or the string tag is empty");
        }
        upgrades.put(stack, tag);
    }

    public static boolean hasUpgrade(TileEntityRFC tile) {
        if (!(tile.func_145838_q() instanceof IFilingCabinet)) {
            return false;
        }
        return !tile.upgrades.isEmpty();
    }

    public static boolean isCreative(TileEntityRFC tile) {
        return tile.isCreative;
    }

    public static String getUpgrade(TileEntityRFC tile, String tag) {
        if (!UpgradeHelper.hasUpgrade(tile)) {
            return null;
        }
        String str = tile.upgrades;
        if (str.equals(tag)) {
            return str;
        }
        return null;
    }

    public static void setUpgrade(EntityPlayer player, TileEntityRFC tile, ItemStack upgrade) {
        if (tile.func_145831_w().field_72995_K || !(upgrade.func_77973_b() instanceof IUpgrades)) {
            return;
        }
        if (!((IUpgrades)upgrade.func_77973_b()).canApply(tile, upgrade, player)) {
            return;
        }
        String key = UpgradeHelper.stringTest(upgrade);
        if (key != null && key.equals(StringLibs.TAG_CREATIVE)) {
            tile.isCreative = true;
            if (!player.field_71075_bZ.field_75098_d) {
                upgrade.func_190918_g(1);
            }
            tile.func_70296_d();
            return;
        }
        if (UpgradeHelper.hasUpgrade(tile)) {
            return;
        }
        if (key != null) {
            tile.upgrades = key;
            if (!player.field_71075_bZ.field_75098_d) {
                upgrade.func_190918_g(1);
            }
            if (upgrade.func_77973_b() == RFCItems.upgrades && upgrade.func_77952_i() == ItemUpgrades.UpgradeType.ENDER.ordinal()) {
                tile.setHash(tile);
            }
            tile.func_70296_d();
        }
    }

    public static void removeUpgrade(EntityPlayer player, TileEntityRFC tile) {
        ItemStack newStack;
        if (!UpgradeHelper.hasUpgrade(tile) && !UpgradeHelper.isCreative(tile)) {
            return;
        }
        ItemStack creative = UpgradeHelper.creativeTest(tile);
        if (!creative.func_190926_b()) {
            tile.isCreative = false;
            if (!player.field_71071_by.func_70441_a(creative)) {
                player.func_145779_a(creative.func_77973_b(), 1);
            }
            tile.func_70296_d();
            return;
        }
        ItemStack upgrade = UpgradeHelper.stackTest(tile);
        if (!upgrade.func_190926_b() && !player.field_71071_by.func_70441_a(newStack = new ItemStack(upgrade.func_77973_b(), 1, upgrade.func_77952_i()))) {
            player.func_145779_a(newStack.func_77973_b(), 1);
        }
        tile.upgrades = "";
        tile.func_70296_d();
    }

    private static String stringTest(ItemStack upgrade) {
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>(upgrades.keySet());
        for (ItemStack is : keys) {
            if (!ItemStack.func_179545_c((ItemStack)upgrade, (ItemStack)is)) continue;
            String str = upgrades.get(is);
            return str;
        }
        return null;
    }

    public static ItemStack stackTest(TileEntityRFC tile) {
        String str = tile.upgrades;
        if (str.isEmpty()) {
            return ItemStack.field_190927_a;
        }
        for (Map.Entry<ItemStack, String> entry : upgrades.entrySet()) {
            String value = entry.getValue();
            if (!value.equals(str)) continue;
            return entry.getKey().func_77946_l();
        }
        return ItemStack.field_190927_a;
    }

    private static ItemStack creativeTest(TileEntityRFC tile) {
        boolean bool = tile.isCreative;
        if (bool) {
            return new ItemStack((Item)RFCItems.upgrades, 1, 0);
        }
        return ItemStack.field_190927_a;
    }
}

