/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.helpers;

import com.bafomdad.realfilingcabinet.api.IUpgrades;
import com.bafomdad.realfilingcabinet.entity.EntityCabinet;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemHandlerHelper;

public class MobUpgradeHelper {
    private static Map<ItemStack, String> mobUpgrades = new HashMap<ItemStack, String>();

    public static void registerMobUpgrade(ItemStack stack, String tag) {
        if (!(stack.func_77973_b() instanceof IUpgrades) || tag.isEmpty()) {
            throw new IllegalArgumentException("[RealFilingCabinet]: Register mob upgrades: ItemStack is not an instance of IUpgrades, or the string tag is empty");
        }
        mobUpgrades.put(stack, tag);
    }

    public static boolean hasMobUpgrade(EntityCabinet entity) {
        return !entity.upgrades.isEmpty();
    }

    public static String getMobUpgrade(EntityCabinet entity, String str) {
        if (entity.upgrades.isEmpty()) {
            return null;
        }
        String tag = entity.upgrades;
        if (tag.equals(str)) {
            return tag;
        }
        return null;
    }

    public static void setUpgrade(EntityPlayer player, EntityCabinet cabinet, ItemStack upgrade) {
        if (cabinet.field_70170_p.field_72995_K || !(upgrade.func_77973_b() instanceof IUpgrades)) {
            return;
        }
        if (MobUpgradeHelper.hasMobUpgrade(cabinet)) {
            return;
        }
        String key = MobUpgradeHelper.stringTest(upgrade);
        if (key != null) {
            cabinet.upgrades = key;
            if (!player.field_71075_bZ.field_75098_d) {
                upgrade.func_190918_g(1);
            }
            if (key.equals(StringLibs.TAG_MOB)) {
                cabinet.setTextureState(1);
            } else if (key.equals(StringLibs.TAG_FLUID)) {
                cabinet.setTextureState(2);
            }
        }
    }

    public static void removeUpgrade(EntityPlayer player, EntityCabinet cabinet) {
        if (!MobUpgradeHelper.hasMobUpgrade(cabinet)) {
            return;
        }
        ItemStack upgrade = MobUpgradeHelper.stackTest(cabinet);
        if (upgrade != null) {
            ItemStack newStack = new ItemStack(upgrade.func_77973_b(), 1, upgrade.func_77952_i());
            ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)newStack);
        }
        cabinet.setTextureState(0);
        cabinet.upgrades = "";
    }

    private static String stringTest(ItemStack upgrade) {
        ArrayList<ItemStack> keys = new ArrayList<ItemStack>(mobUpgrades.keySet());
        for (ItemStack is : keys) {
            if (!ItemStack.func_179545_c((ItemStack)upgrade, (ItemStack)is)) continue;
            String str = mobUpgrades.get(is);
            return str;
        }
        return null;
    }

    public static ItemStack stackTest(EntityCabinet cabinet) {
        String str = cabinet.upgrades;
        if (str.isEmpty()) {
            return null;
        }
        for (Map.Entry<ItemStack, String> entry : mobUpgrades.entrySet()) {
            String value = entry.getValue();
            if (!value.equals(str)) continue;
            return entry.getKey();
        }
        return null;
    }
}

