/*
 * Decompiled with CFR 0.152.
 */
package com.bafomdad.realfilingcabinet.entity;

import com.bafomdad.realfilingcabinet.api.IUpgrades;
import com.bafomdad.realfilingcabinet.blocks.BlockRFC;
import com.bafomdad.realfilingcabinet.blocks.tiles.TileEntityRFC;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAIEatItem;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAIHugMob;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAIMoveBackHome;
import com.bafomdad.realfilingcabinet.entity.ai.EntityAISlurp;
import com.bafomdad.realfilingcabinet.helpers.MobUpgradeHelper;
import com.bafomdad.realfilingcabinet.helpers.StringLibs;
import com.bafomdad.realfilingcabinet.init.RFCBlocks;
import com.bafomdad.realfilingcabinet.init.RFCItems;
import com.bafomdad.realfilingcabinet.inventory.InventoryEntity;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowOwner;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityTameable;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.World;
import net.minecraftforge.items.ItemHandlerHelper;

public class EntityCabinet
extends EntityTameable {
    private final InventoryEntity inventory;
    private static final DataParameter<Boolean> YAY = EntityDataManager.func_187226_a(EntityCabinet.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> STATE = EntityDataManager.func_187226_a(EntityCabinet.class, (DataSerializer)DataSerializers.field_187192_b);
    private int variant = 0;
    private boolean isRealEntity = false;
    public String upgrades = "";
    public long homePos;

    public EntityCabinet(World world) {
        super(world);
        this.func_70105_a(0.9f, 1.3f);
        this.inventory = new InventoryEntity(this, 8);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70178_ae = true;
        this.func_70903_f(true);
        this.field_70180_af.func_187214_a(YAY, (Object)false);
        this.field_70180_af.func_187214_a(STATE, (Object)0);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIFollowOwner((EntityTameable)this, (double)0.6f, 10.0f, 2.0f));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIEatItem(this));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIHugMob(this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAISlurp(this));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIMoveBackHome(this));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 8.0f));
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111265_b).func_111128_a(30.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.55);
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
    }

    public void func_70071_h_() {
        super.func_70071_h_();
    }

    public boolean func_180431_b(DamageSource source) {
        EntityPlayer player;
        if (source == DamageSource.field_76380_i) {
            return false;
        }
        return !(source.func_76346_g() instanceof EntityPlayer) || !source.func_76346_g().func_70093_af() || (player = (EntityPlayer)source.func_76346_g()).func_184614_ca().func_190926_b() || player.func_184614_ca().func_77973_b() != RFCItems.magnifyingGlass;
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.isLegit()) {
            this.func_70106_y();
            return false;
        }
        if (!this.upgrades.isEmpty()) {
            if (source.func_76346_g() instanceof EntityPlayer) {
                MobUpgradeHelper.removeUpgrade((EntityPlayer)source.func_76346_g(), this);
            }
            return false;
        }
        if (source.func_76346_g() == null) {
            this.func_70106_y();
            return true;
        }
        if (this.func_180425_c().func_177956_o() < 0) {
            BlockPos toHome = BlockPos.func_177969_a((long)this.homePos);
            if (!this.field_70170_p.field_72995_K) {
                this.func_70107_b(toHome.func_177958_n(), toHome.func_177956_o(), toHome.func_177952_p());
            }
            return false;
        }
        this.setTile(source);
        return true;
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184614_ca();
        if (hand == EnumHand.MAIN_HAND && !this.field_70170_p.field_72995_K && !stack.func_190926_b() && stack.func_77973_b() instanceof IUpgrades) {
            MobUpgradeHelper.setUpgrade(player, this, stack);
            return true;
        }
        return false;
    }

    public void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        NBTTagList nbttaglist = tag.func_150295_c("Inventory", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            ItemStack itemstack = new ItemStack(nbttaglist.func_150305_b(i));
            if (itemstack.func_190926_b()) continue;
            this.inventory.setStackInSlot(i, itemstack.func_77946_l());
        }
        this.isRealEntity = tag.func_74767_n("legitEntity");
        this.upgrades = tag.func_74779_i(StringLibs.RFC_MOBUPGRADE);
        this.homePos = tag.func_74763_f("homePos");
        this.setTextureState(tag.func_74762_e("varTex"));
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        NBTTagList tagList = new NBTTagList();
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            ItemStack itemstack = this.inventory.getStackInSlot(i);
            if (itemstack.func_190926_b()) continue;
            tagList.func_74742_a((NBTBase)itemstack.func_77955_b(new NBTTagCompound()));
        }
        tag.func_74782_a("Inventory", (NBTBase)tagList);
        tag.func_74757_a("legitEntity", this.isRealEntity);
        tag.func_74778_a(StringLibs.RFC_MOBUPGRADE, this.upgrades);
        tag.func_74772_a("homePos", this.homePos);
        tag.func_74768_a("varTex", this.getTextureState());
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        return null;
    }

    public InventoryEntity getInventory() {
        return this.inventory;
    }

    public void setInventory(int slot, ItemStack stack) {
        if (this.inventory == null) {
            return;
        }
        this.inventory.setStackInSlot(slot, stack);
    }

    public void setInventory(TileEntityRFC tile, int slot, ItemStack stack) {
        tile.getInventory().setStackInSlot(slot, stack);
    }

    public void setYay(boolean bool) {
        this.field_70180_af.func_187227_b(YAY, (Object)bool);
    }

    public boolean isYaying() {
        return (Boolean)this.field_70180_af.func_187225_a(YAY);
    }

    public void setTextureState(int val) {
        this.field_70180_af.func_187227_b(STATE, (Object)val);
    }

    public int getTextureState() {
        return (Integer)this.field_70180_af.func_187225_a(STATE);
    }

    public boolean isLegit() {
        return this.isRealEntity;
    }

    public void setLegit() {
        this.isRealEntity = true;
    }

    private void setTile(DamageSource source) {
        if (source.func_76346_g() instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)source.func_76346_g();
            IBlockState state = RFCBlocks.blockRFC.func_176223_P().func_177226_a((IProperty)BlockRFC.FACING, (Comparable)this.func_174811_aO().func_176734_d());
            BlockPos pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70170_p.func_175623_d(pos)) {
                    this.field_70170_p.func_175656_a(pos, state);
                    TileEntityRFC tile = (TileEntityRFC)this.field_70170_p.func_175625_s(pos);
                    if (tile != null) {
                        for (int i = 0; i < this.inventory.getSlots(); ++i) {
                            ItemStack folder = this.inventory.getStackInSlot(i);
                            if (folder.func_190926_b()) continue;
                            this.setInventory(tile, i, folder);
                        }
                        if (this.func_70902_q() != null) {
                            tile.setOwner(this.func_184753_b());
                        }
                    }
                    ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)new ItemStack((Item)RFCItems.upgrades, 1, 6));
                    this.func_70106_y();
                } else {
                    player.func_146105_b((ITextComponent)new TextComponentTranslation("message.realfilingcabinet.notAir", new Object[0]), true);
                }
            }
        }
    }

    public int func_82143_as() {
        return 10;
    }

    public float func_184643_a(PathNodeType nodeType) {
        if (nodeType.func_186289_a() != 0.0f && (nodeType == PathNodeType.LAVA || nodeType == PathNodeType.DANGER_OTHER)) {
            return 0.0f;
        }
        return super.func_184643_a(nodeType);
    }
}

