/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.util;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;
import teamroots.embers.ConfigManager;
import teamroots.embers.RegistryManager;
import teamroots.embers.util.NoiseGenUtil;

public class EmberGenUtil {
    public static int offX = 0;
    public static int offZ = 0;
    public static Map<Item, Double> emberAmounts = new HashMap<Item, Double>();
    public static Map<String, Float> metalCoefficients = new HashMap<String, Float>();
    public static Map<Item, Float> fuelCoefficients = new HashMap<Item, Float>();
    public static Map<Item, Float> catalysisCoefficients = new HashMap<Item, Float>();

    public static float getEmberDensity(long seed, int x, int z) {
        return EmberGenUtil.getEmberStability(seed, x, z) * (float)Math.pow((80.0f * NoiseGenUtil.getOctave(seed, x + offX, z + offZ, 112) + 20.0f * NoiseGenUtil.getOctave(seed, x + offX, z + offZ, 68) + 6.0f * NoiseGenUtil.getOctave(seed, x + offX, z + offZ, 34) + 4.0f * NoiseGenUtil.getOctave(seed, x + offX, z + offZ, 21) + 2.0f * NoiseGenUtil.getOctave(seed, x + offX, z + offZ, 11) + 1.0f * NoiseGenUtil.getOctave(seed, x + offX, z + offZ, 4)) / 93.0f, 1.6f);
    }

    public static float getEmberStability(long seed, int x, int z) {
        return 1.0f - (float)Math.pow((32.0f * NoiseGenUtil.getOctave(seed, x, z, 120) + 16.0f * NoiseGenUtil.getOctave(seed, x, z, 76) + 6.0f * NoiseGenUtil.getOctave(seed, x, z, 45) + 3.0f * NoiseGenUtil.getOctave(seed, x, z, 21) + 1.0f * NoiseGenUtil.getOctave(seed, x, z, 5)) / 58.0f, 3.0);
    }

    public static void registerEmberFuelItem(Item item, double ember) {
        emberAmounts.put(item, ember);
    }

    public static double getEmberForItem(Item item) {
        if (emberAmounts.containsKey(item)) {
            return emberAmounts.get(item);
        }
        return 0.0;
    }

    public static void registerMetalCoefficient(String key, float coeff) {
        metalCoefficients.put(key, Float.valueOf(coeff));
    }

    public static float getMetalCoefficient(IBlockState state) {
        int[] ids;
        Block b = state.func_177230_c();
        ItemStack s = new ItemStack(b);
        if (s.func_190926_b()) {
            return 0.0f;
        }
        for (int i : ids = OreDictionary.getOreIDs((ItemStack)s)) {
            String key = OreDictionary.getOreName((int)i);
            if (!metalCoefficients.containsKey(key)) continue;
            return metalCoefficients.get(key).floatValue();
        }
        return 0.0f;
    }

    public static void registerFuelCoefficient(Item item, float coeff) {
        fuelCoefficients.put(item, Float.valueOf(coeff));
    }

    public static float getFuelCoefficient(Item item) {
        if (fuelCoefficients.containsKey(item)) {
            return fuelCoefficients.get(item).floatValue();
        }
        return 0.0f;
    }

    public static void registerCatalysisCoefficient(Item item, float coeff) {
        catalysisCoefficients.put(item, Float.valueOf(coeff));
    }

    public static float getCatalysisCoefficient(Item item) {
        if (catalysisCoefficients.containsKey(item)) {
            return catalysisCoefficients.get(item).floatValue();
        }
        return 0.0f;
    }

    public static void init() {
        EmberGenUtil.registerEmberFuelItem(RegistryManager.shard_ember, 400.0);
        EmberGenUtil.registerEmberFuelItem(RegistryManager.crystal_ember, 2400.0);
        EmberGenUtil.registerEmberFuelItem(RegistryManager.ember_cluster, 3600.0);
        EmberGenUtil.registerMetalCoefficient("blockGold", 1.0f);
        EmberGenUtil.registerMetalCoefficient("blockSilver", 1.0f);
        EmberGenUtil.registerMetalCoefficient("blockCopper", 1.0f);
        if (ConfigManager.enableElectrum) {
            EmberGenUtil.registerMetalCoefficient("blockElectrum", 1.0f);
        }
        if (ConfigManager.enableAluminum) {
            EmberGenUtil.registerMetalCoefficient("blockAluminum", 0.9f);
        }
        if (ConfigManager.enableNickel) {
            EmberGenUtil.registerMetalCoefficient("blockNickel", 0.9f);
        }
        if (ConfigManager.enableTin) {
            EmberGenUtil.registerMetalCoefficient("blockTin", 0.9f);
        }
        EmberGenUtil.registerMetalCoefficient("blockIron", 0.75f);
        EmberGenUtil.registerMetalCoefficient("blockLead", 0.75f);
        if (ConfigManager.enableBronze) {
            EmberGenUtil.registerMetalCoefficient("blockBronze", 0.75f);
        }
        EmberGenUtil.registerFuelCoefficient(Items.field_151044_h, 2.0f);
        EmberGenUtil.registerFuelCoefficient(Items.field_151130_bT, 3.0f);
        EmberGenUtil.registerFuelCoefficient(Items.field_151065_br, 4.0f);
        EmberGenUtil.registerCatalysisCoefficient(Items.field_151137_ax, 2.0f);
        EmberGenUtil.registerCatalysisCoefficient(Items.field_151016_H, 3.0f);
        EmberGenUtil.registerCatalysisCoefficient(Items.field_151114_aO, 4.0f);
    }
}

