/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.List;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import teamroots.embers.EventManager;
import teamroots.embers.particle.ParticleUtil;
import teamroots.embers.power.DefaultEmberCapability;
import teamroots.embers.power.EmberCapabilityProvider;
import teamroots.embers.power.IEmberCapability;
import teamroots.embers.tileentity.IMultiblockMachine;
import teamroots.embers.tileentity.ITileEntityBase;

public class TileEntityHeatCoil
extends TileEntity
implements ITileEntityBase,
ITickable,
IMultiblockMachine {
    public IEmberCapability capability = new DefaultEmberCapability();
    public ItemStackHandler inventory = new ItemStackHandler(1){};
    Random random = new Random();
    int progress = 0;
    int heat = 0;
    int ticksExisted = 0;
    public boolean dirty = false;

    public TileEntityHeatCoil() {
        this.capability.setEmberCapacity(8000.0);
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        tag.func_74768_a("progress", this.progress);
        tag.func_74768_a("heat", this.heat);
        tag.func_74782_a("inventory", (NBTBase)this.inventory.serializeNBT());
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        this.inventory.deserializeNBT(tag.func_74775_l("inventory"));
        if (tag.func_74764_b("progress")) {
            this.progress = tag.func_74762_e("progress");
        }
        if (tag.func_74764_b("heat")) {
            this.heat = tag.func_74762_e("heat");
        }
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        world.func_175698_g(pos.func_177982_a(1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 0));
        world.func_175698_g(pos.func_177982_a(0, 0, -1));
        world.func_175698_g(pos.func_177982_a(1, 0, -1));
        world.func_175698_g(pos.func_177982_a(-1, 0, 1));
        world.func_175698_g(pos.func_177982_a(1, 0, 1));
        world.func_175698_g(pos.func_177982_a(-1, 0, -1));
        world.func_175690_a(pos, null);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return true;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == EmberCapabilityProvider.emberCapability) {
            return (T)this.capability;
        }
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)this.inventory;
        }
        return (T)super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        int i;
        ++this.ticksExisted;
        if (this.capability.getEmber() >= 1.0) {
            this.capability.removeAmount(1.0, true);
            if (this.ticksExisted % 20 == 0) {
                ++this.heat;
                if (this.heat > 280) {
                    this.heat = 280;
                }
            }
        } else if (this.ticksExisted % 20 == 0) {
            --this.heat;
            if (this.heat < 0) {
                this.heat = 0;
            }
        }
        if (this.heat > 0 && this.ticksExisted % (300 - this.heat) == 0 && !this.func_145831_w().field_72995_K) {
            List items = this.func_145831_w().func_72872_a(EntityItem.class, new AxisAlignedBB((double)(this.func_174877_v().func_177958_n() - 1), (double)this.func_174877_v().func_177956_o(), (double)(this.func_174877_v().func_177952_p() - 1), (double)(this.func_174877_v().func_177958_n() + 2), (double)(this.func_174877_v().func_177956_o() + 2), (double)(this.func_174877_v().func_177952_p() + 2)));
            for (i = 0; i < items.size(); ++i) {
                ((EntityItem)items.get(i)).func_70288_d();
                ((EntityItem)items.get((int)i)).lifespan = 10800;
            }
            if (items.size() > 0) {
                i = this.random.nextInt(items.size());
                if (FurnaceRecipes.func_77602_a().func_151395_a(((EntityItem)items.get(i)).func_92059_d()) != ItemStack.field_190927_a) {
                    ItemStack recipeStack = new ItemStack(((EntityItem)items.get(i)).func_92059_d().func_77973_b(), 1, ((EntityItem)items.get(i)).func_92059_d().func_77960_j());
                    if (((EntityItem)items.get(i)).func_92059_d().func_77942_o()) {
                        recipeStack.func_77982_d(((EntityItem)items.get(i)).func_92059_d().func_77978_p());
                    }
                    ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(recipeStack).func_77946_l();
                    ItemStack remainder = this.inventory.insertItem(0, stack, false);
                    ((EntityItem)items.get(i)).func_92059_d().func_190918_g(1);
                    if (((EntityItem)items.get(i)).func_92059_d().func_190916_E() == 0) {
                        ((EntityItem)items.get(i)).func_70106_y();
                        for (int j = 0; j < 3; ++j) {
                            if (this.random.nextBoolean()) {
                                this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_NORMAL, ((EntityItem)items.get((int)i)).field_70165_t, ((EntityItem)items.get((int)i)).field_70163_u, ((EntityItem)items.get((int)i)).field_70161_v, 0.0, 0.0, 0.0, new int[]{0});
                                continue;
                            }
                            this.func_145831_w().func_175688_a(EnumParticleTypes.SMOKE_LARGE, ((EntityItem)items.get((int)i)).field_70165_t, ((EntityItem)items.get((int)i)).field_70163_u, ((EntityItem)items.get((int)i)).field_70161_v, 0.0, 0.0, 0.0, new int[]{0});
                        }
                        this.func_145831_w().func_72900_e((Entity)items.get(i));
                    }
                    this.func_70296_d();
                    IBlockState state = this.func_145831_w().func_180495_p(this.func_174877_v());
                    if (remainder != ItemStack.field_190927_a) {
                        this.func_145831_w().func_72838_d((Entity)new EntityItem(this.func_145831_w(), ((EntityItem)items.get((int)i)).field_70165_t, ((EntityItem)items.get((int)i)).field_70163_u, ((EntityItem)items.get((int)i)).field_70161_v, remainder));
                    }
                }
            }
        }
        if (this.func_145831_w().field_72995_K && this.heat > 0) {
            float particleCount = (float)(1 + this.random.nextInt(2)) * (1.0f + (float)Math.sqrt(this.heat));
            i = 0;
            while ((float)i < particleCount) {
                ParticleUtil.spawnParticleGlow(this.func_145831_w(), (float)this.func_174877_v().func_177958_n() - 0.2f + this.random.nextFloat() * 1.4f, (float)this.func_174877_v().func_177956_o() + 1.275f, (float)this.func_174877_v().func_177952_p() - 0.2f + this.random.nextFloat() * 1.4f, 0.0f, 0.0f, 0.0f, 255.0f, 64.0f, 16.0f, 2.0f, 24);
                ++i;
            }
        }
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }
}

