/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import java.util.ArrayList;
import javax.annotation.Nullable;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.EventManager;
import teamroots.embers.block.BlockAxle;
import teamroots.embers.block.BlockGearbox;
import teamroots.embers.item.ItemGear;
import teamroots.embers.power.DefaultMechCapability;
import teamroots.embers.power.IMechCapability;
import teamroots.embers.power.MechCapabilityProvider;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.tileentity.TileEntityAxle;
import teamroots.embers.util.Misc;

public class TileEntityGearbox
extends TileEntity
implements ITileEntityBase {
    int ticksExisted = 0;
    EnumFacing from = null;
    public int connections = 0;
    public ItemStack[] gears = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
    public DefaultMechCapability capability = new DefaultMechCapability(){

        @Override
        public void onContentsChanged() {
            TileEntityGearbox box = TileEntityGearbox.this;
            box.updateNeighbors();
            box.func_70296_d();
        }

        @Override
        public double getPower(EnumFacing from) {
            if (from != null && TileEntityGearbox.this.gears[from.func_176745_a()].func_190926_b()) {
                return 0.0;
            }
            if (from == TileEntityGearbox.this.from || from == null) {
                return super.getPower(from);
            }
            return super.getPower(from) / (double)Math.max(1, TileEntityGearbox.this.connections);
        }

        @Override
        public void setPower(double value, EnumFacing from) {
            if (from != null && TileEntityGearbox.this.gears[from.func_176745_a()].func_190926_b()) {
                return;
            }
            if (from == TileEntityGearbox.this.from || from == null) {
                super.setPower(value, from);
            }
            if (value != this.getPower(null)) {
                this.onContentsChanged();
            }
        }
    };
    public boolean dirty = false;

    public void updateNeighbors() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        if (state.func_177230_c() instanceof BlockGearbox) {
            this.from = (EnumFacing)state.func_177229_b((IProperty)BlockGearbox.facing);
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(this.from));
            if (t instanceof TileEntityAxle) {
                ((TileEntityAxle)t).updateNeighbors();
            }
        }
        this.connections = 0;
        ArrayList<EnumFacing> toUpdate = new ArrayList<EnumFacing>();
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t;
            if (f == null || f == this.from || (t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f))) == null || !t.hasCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(f))) continue;
            toUpdate.add(f);
        }
        for (EnumFacing f : toUpdate) {
            if (this.getGear(f).func_190926_b()) continue;
            ++this.connections;
        }
        for (EnumFacing f : toUpdate) {
            IBlockState s;
            BlockPos p = this.func_174877_v().func_177972_a(f);
            TileEntity t = this.field_145850_b.func_175625_s(p);
            if (t instanceof TileEntityAxle && ((TileEntityAxle)t).front == null && (s = this.field_145850_b.func_180495_p(p)).func_177230_c() instanceof BlockAxle) {
                ((TileEntityAxle)t).front = Misc.getOppositeFace((EnumFacing)s.func_177229_b((IProperty)BlockAxle.facing));
                t.func_70296_d();
            }
            if (t instanceof TileEntityAxle && (!(t instanceof TileEntityAxle) || ((TileEntityAxle)t).front != f.func_176734_d())) continue;
            ((IMechCapability)t.getCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(f))).setPower(this.capability.getPower(f), Misc.getOppositeFace(f));
            t.func_70296_d();
        }
    }

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        if (this.from != null) {
            tag.func_74768_a("from", this.from.func_176745_a());
        }
        for (int i = 0; i < 6; ++i) {
            tag.func_74782_a("gear" + i, (NBTBase)this.gears[i].func_77955_b(new NBTTagCompound()));
        }
        tag.func_74768_a("connections", this.connections);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
        if (tag.func_74764_b("from")) {
            this.from = EnumFacing.func_82600_a((int)tag.func_74762_e("from"));
        }
        for (int i = 0; i < 6; ++i) {
            this.gears[i] = new ItemStack(tag.func_74775_l("gear" + i));
        }
        this.connections = tag.func_74762_e("connections");
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    public ItemStack getGear(EnumFacing side) {
        return this.gears[side.func_176745_a()];
    }

    public void setGear(EnumFacing side, ItemStack stack) {
        this.gears[side.func_176745_a()] = stack;
        this.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        ItemStack heldItem = player.func_184586_b(hand);
        if (!heldItem.func_190926_b()) {
            if (heldItem.func_77973_b() instanceof ItemGear && this.getGear(side).func_190926_b()) {
                ItemStack gear = heldItem.func_77946_l();
                gear.func_190920_e(1);
                this.setGear(side, gear);
                heldItem.func_190918_g(1);
                if (heldItem.func_190916_E() == 0) {
                    player.func_184611_a(hand, ItemStack.field_190927_a);
                }
                this.capability.onContentsChanged();
                return true;
            }
        } else if (!this.getGear(side).func_190926_b()) {
            ItemStack gear = this.getGear(side);
            if (!world.field_72995_K) {
                world.func_72838_d((Entity)new EntityItem(world, player.field_70165_t, player.field_70163_u + (double)(player.field_70131_O / 2.0f), player.field_70161_v, gear));
            }
            this.setGear(side, ItemStack.field_190927_a);
            this.capability.onContentsChanged();
            return true;
        }
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        this.capability.setPower(0.0, null);
        this.updateNeighbors();
        for (int i = 0; i < 6; ++i) {
            if (world.field_72995_K) continue;
            world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, this.gears[i]));
        }
        world.func_175690_a(pos, null);
    }
}

