/*
 * Decompiled with CFR 0.152.
 */
package teamroots.embers.tileentity;

import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.Capability;
import teamroots.embers.EventManager;
import teamroots.embers.power.DefaultMechCapability;
import teamroots.embers.power.IMechCapability;
import teamroots.embers.power.MechCapabilityProvider;
import teamroots.embers.tileentity.ITileEntityBase;
import teamroots.embers.util.Misc;

public class TileEntityCreativeMechSource
extends TileEntity
implements ITileEntityBase,
ITickable {
    int ticksExisted = 0;
    BlockPos receivedFrom = null;
    public DefaultMechCapability capability = new DefaultMechCapability();
    public boolean dirty = false;

    public NBTTagCompound func_189515_b(NBTTagCompound tag) {
        super.func_189515_b(tag);
        this.capability.writeToNBT(tag);
        return tag;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.capability.readFromNBT(tag);
    }

    public NBTTagCompound func_189517_E_() {
        return this.func_189515_b(new NBTTagCompound());
    }

    @Nullable
    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        this.func_145839_a(pkt.func_148857_g());
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == MechCapabilityProvider.mechCapability) {
            return (T)this.capability;
        }
        return (T)super.getCapability(capability, facing);
    }

    @Override
    public void markForUpdate() {
        EventManager.markTEForUpdate(this.func_174877_v(), this);
    }

    public void func_70296_d() {
        this.markForUpdate();
        super.func_70296_d();
    }

    @Override
    public boolean activate(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        return false;
    }

    @Override
    public void breakBlock(World world, BlockPos pos, IBlockState state, EntityPlayer player) {
        this.func_145843_s();
        this.capability.setPower(0.0, null);
        this.updateNearby();
        world.func_175690_a(pos, null);
    }

    public void updateNearby() {
        for (EnumFacing f : EnumFacing.values()) {
            TileEntity t = this.field_145850_b.func_175625_s(this.func_174877_v().func_177972_a(f));
            if (t == null || !t.hasCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(f))) continue;
            ((IMechCapability)t.getCapability(MechCapabilityProvider.mechCapability, Misc.getOppositeFace(f))).setPower(this.capability.getPower(Misc.getOppositeFace(f)), Misc.getOppositeFace(f));
            t.func_70296_d();
        }
    }

    public void func_73660_a() {
        if (this.capability.getPower(null) < 200.0) {
            this.capability.setPower(200.0, null);
            this.func_70296_d();
        }
        this.updateNearby();
    }
}

