/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.compat.jei.recipes.misc;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import mezz.jei.api.IGuiHelper;
import mezz.jei.api.gui.ICraftingGridHelper;
import mezz.jei.api.gui.IGuiIngredientGroup;
import mezz.jei.api.gui.IGuiItemStackGroup;
import mezz.jei.api.gui.IRecipeLayout;
import mezz.jei.api.ingredients.IIngredients;
import mezz.jei.api.ingredients.VanillaTypes;
import mezz.jei.api.recipe.IFocus;
import mezz.jei.api.recipe.IStackHelper;
import mezz.jei.api.recipe.wrapper.ICraftingRecipeWrapper;
import mezz.jei.api.recipe.wrapper.ICustomCraftingRecipeWrapper;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.api.item.ICorrodible;
import thebetweenlands.common.item.misc.ItemMisc;
import thebetweenlands.common.registries.RecipeRegistry;
import thebetweenlands.compat.jei.BetweenlandsJEIPlugin;

public class CoatingRecipeJEI
implements ICraftingRecipeWrapper,
ICustomCraftingRecipeWrapper {
    protected static List<ItemStack> coatableItems = NonNullList.func_191196_a();
    private final ICraftingGridHelper craftingGridHelper;

    public CoatingRecipeJEI(IGuiHelper guiHelper) {
        this.craftingGridHelper = guiHelper.createCraftingGridHelper(1, 0);
    }

    public static void setCoatableItems() {
        coatableItems.clear();
        for (ItemStack stack : BetweenlandsJEIPlugin.ingredientRegistry.getAllIngredients(ItemStack.class)) {
            if (stack.func_190926_b() || !(stack.func_77973_b() instanceof ICorrodible)) continue;
            coatableItems.add(stack);
        }
    }

    @Nullable
    public ResourceLocation getRegistryName() {
        return RecipeRegistry.COATING;
    }

    public void getIngredients(IIngredients ingredients) {
        ArrayList<List<Object>> inputLists = new ArrayList<List<Object>>();
        ArrayList outputLists = new ArrayList();
        ItemStack scabyst = ItemMisc.EnumItemMisc.SCABYST.create(1);
        ArrayList<ItemStack> inputs = new ArrayList<ItemStack>();
        ArrayList<ItemStack> outputs = new ArrayList<ItemStack>();
        for (ItemStack stack : coatableItems) {
            ItemStack coated = stack.func_77946_l();
            ((ICorrodible)coated.func_77973_b()).setCoating(coated, ((ICorrodible)coated.func_77973_b()).getMaxCoating(coated));
            inputs.add(stack);
            outputs.add(coated);
        }
        inputLists.add(inputs);
        outputLists.add(outputs);
        for (int i = 0; i < 8; ++i) {
            inputLists.add(Collections.singletonList(scabyst));
        }
        ingredients.setInputLists(ItemStack.class, inputLists);
        ingredients.setOutputLists(ItemStack.class, outputLists);
    }

    public void setRecipe(IRecipeLayout recipeLayout, IIngredients ingredients) {
        IStackHelper stackHelper = BetweenlandsJEIPlugin.jeiHelper.getStackHelper();
        recipeLayout.setShapeless();
        IGuiItemStackGroup guiItemStacks = recipeLayout.getItemStacks();
        IFocus focus = recipeLayout.getFocus();
        List inputs = ingredients.getInputs(VanillaTypes.ITEM);
        List outputs = ingredients.getOutputs(VanillaTypes.ITEM);
        if (focus != null && focus.getValue() instanceof ItemStack && ((ItemStack)focus.getValue()).func_77973_b() instanceof ICorrodible) {
            if (focus.getMode() == IFocus.Mode.INPUT) {
                ((List)outputs.get(0)).removeIf(stack -> !stackHelper.isEquivalent((ItemStack)focus.getValue(), stack));
            } else {
                ((List)inputs.get(0)).removeIf(stack -> !stackHelper.isEquivalent((ItemStack)focus.getValue(), stack));
            }
        }
        this.craftingGridHelper.setInputs((IGuiIngredientGroup)guiItemStacks, inputs);
        guiItemStacks.set(0, (List)outputs.get(0));
        BetweenlandsJEIPlugin.addRecipeName(this.getRegistryName(), guiItemStacks, 0);
    }
}

