/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.world.gen.biome.decorator.DecorationHelper;
import thebetweenlands.common.world.gen.biome.decorator.DecoratorPositionProvider;
import thebetweenlands.common.world.gen.biome.decorator.SurfaceType;

public class WorldGenRootPodRoots
extends WorldGenerator {
    public boolean func_180709_b(World world, Random rand, BlockPos position) {
        if (SurfaceType.PLANT_DECORATION_SOIL.matches(world, position.func_177977_b()) && this.generateRootsStack(world, rand, position)) {
            DecoratorPositionProvider provider = new DecoratorPositionProvider();
            provider.init(world, world.func_180494_b(position), null, rand, position.func_177958_n(), position.func_177956_o(), position.func_177952_p());
            provider.setOffsetXZ(-3, 3);
            provider.setOffsetY(-1, 1);
            for (int i = 0; i < 10; ++i) {
                DecorationHelper.generateSwampDoubleTallgrass(provider);
                DecorationHelper.generateTallCattail(provider);
                DecorationHelper.generateSwampTallgrassCluster(provider);
                if (rand.nextInt(5) == 0) {
                    DecorationHelper.generateCattailCluster(provider);
                }
                if (rand.nextInt(3) != 0) continue;
                DecorationHelper.generateShootsCluster(provider);
            }
            world.func_175656_a(position.func_177977_b(), BlockRegistry.GIANT_ROOT.func_176223_P());
            for (EnumFacing facing : EnumFacing.field_176754_o) {
                BlockPos offset = position.func_177972_a(facing).func_177977_b();
                if (!SurfaceType.PLANT_DECORATION_SOIL.apply(world.func_180495_p(offset))) continue;
                world.func_175656_a(offset, BlockRegistry.GIANT_ROOT.func_176223_P());
            }
            for (int i = 0; i < 32; ++i) {
                BlockPos offset;
                int rx = rand.nextInt(7) - 3;
                int rz = rand.nextInt(7) - 3;
                if (rx == 0 && rz == 0 || !SurfaceType.PLANT_DECORATION_SOIL.apply(world.func_180495_p(offset = position.func_177982_a(rx, rand.nextInt(3) - 2, rz)))) continue;
                world.func_175656_a(offset, BlockRegistry.GIANT_ROOT.func_176223_P());
            }
            return true;
        }
        return false;
    }

    private boolean generateRootsStack(World world, Random rand, BlockPos pos) {
        BlockPos offsetPos;
        int yo;
        int height = 6;
        BlockPos.MutableBlockPos checkPos = new BlockPos.MutableBlockPos();
        for (yo = 0; yo < 6; ++yo) {
            checkPos.func_181079_c(pos.func_177958_n(), pos.func_177956_o() + yo, pos.func_177952_p());
            if (world.func_175623_d((BlockPos)checkPos)) continue;
            height = yo;
            break;
        }
        if (height < 2) {
            return false;
        }
        height = rand.nextInt(height) + 1 + rand.nextInt(4);
        for (yo = 0; yo < height && world.func_175623_d(offsetPos = pos.func_177982_a(0, yo, 0)); ++yo) {
            world.func_180501_a(offsetPos, BlockRegistry.ROOT.func_176223_P(), 2);
        }
        return true;
    }
}

