/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.world.gen.feature;

import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenerator;
import thebetweenlands.common.block.container.BlockLootPot;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityLootPot;

public class WorldGenCavePots
extends WorldGenerator {
    public WorldGenCavePots() {
        super(false);
    }

    private IBlockState getRandomPot(Random rand) {
        switch (rand.nextInt(3)) {
            case 0: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1));
            }
            case 1: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_2));
            }
            case 2: {
                return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_3));
            }
        }
        return BlockRegistry.LOOT_POT.func_176223_P().func_177226_a(BlockLootPot.VARIANT, (Comparable)((Object)BlockLootPot.EnumLootPot.POT_1));
    }

    public boolean func_180709_b(World world, Random random, BlockPos pos) {
        if (pos.func_177956_o() > 70) {
            return false;
        }
        int randDirection = random.nextInt(4) + 2;
        for (int xx = -2; xx <= 2; ++xx) {
            for (int zz = -2; zz <= 2; ++zz) {
                for (int yy = -1; yy <= 1; ++yy) {
                    IBlockState surfaceBlock;
                    BlockPos offsetPos;
                    double dst = Math.sqrt(xx * xx + yy * yy + zz * zz);
                    if (random.nextInt(MathHelper.func_76143_f((double)(dst / 1.4)) + 1) != 0 || !world.func_175623_d(offsetPos = pos.func_177982_a(xx, yy, zz)) || (surfaceBlock = world.func_180495_p(offsetPos.func_177977_b())).func_177230_c() != BlockRegistry.BETWEENSTONE && surfaceBlock != BlockRegistry.PITSTONE) continue;
                    this.func_175903_a(world, offsetPos, this.getRandomPot(random));
                    TileEntityLootPot lootPot = BlockLootPot.getTileEntity((IBlockAccess)world, offsetPos);
                    if (lootPot == null) continue;
                    lootPot.setLootTable(LootTableRegistry.COMMON_POT_LOOT, random.nextLong());
                }
            }
        }
        return true;
    }
}

