/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.tile;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTank;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;
import thebetweenlands.api.aspect.Aspect;
import thebetweenlands.api.aspect.IAspectType;
import thebetweenlands.api.aspect.ItemAspectContainer;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.common.entity.mobs.EntityGasCloud;
import thebetweenlands.common.herblore.aspect.AspectManager;
import thebetweenlands.common.herblore.elixir.ElixirRecipe;
import thebetweenlands.common.herblore.elixir.ElixirRecipes;
import thebetweenlands.common.registries.FluidRegistry;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.tile.TileEntityBasicInventory;

public class TileEntityInfuser
extends TileEntityBasicInventory
implements IFluidHandler,
ITickable {
    public static final int MAX_INGREDIENTS = 6;
    public final FluidTank waterTank;
    private final IFluidTankProperties[] properties = new IFluidTankProperties[]{new IFluidTankProperties(){

        public FluidStack getContents() {
            return TileEntityInfuser.this.waterTank.getFluid();
        }

        public int getCapacity() {
            return TileEntityInfuser.this.waterTank.getCapacity();
        }

        public boolean canFill() {
            return TileEntityInfuser.this.waterTank.canFill();
        }

        public boolean canDrain() {
            return TileEntityInfuser.this.waterTank.canDrain();
        }

        public boolean canFillFluidType(FluidStack fluidStack) {
            return TileEntityInfuser.this.waterTank.canFillFluidType(fluidStack);
        }

        public boolean canDrainFluidType(FluidStack fluidStack) {
            return TileEntityInfuser.this.waterTank.canDrainFluidType(fluidStack);
        }
    }};
    private int infusionTime = 0;
    private int stirProgress = 90;
    private int temp = 0;
    private int evaporation = 0;
    private int itemBob = 0;
    private boolean countUp = true;
    private boolean hasInfusion = false;
    private boolean hasCrystal = false;
    private float crystalVelocity = 0.0f;
    private float crystalRotation = 0.0f;
    private ElixirRecipe infusingRecipe = null;
    private boolean updateRecipe = false;
    private int currentInfusionState = 0;
    private int prevInfusionState = 0;
    private int infusionColorGradientTicks = 0;
    public float[] prevInfusionColor = new float[4];
    public float[] currentInfusionColor = new float[4];

    public TileEntityInfuser() {
        super(8, "infuser");
        this.waterTank = new FluidTank((Fluid)FluidRegistry.SWAMP_WATER, 0, 3000);
        this.waterTank.setTileEntity((TileEntity)this);
    }

    public IFluidTankProperties[] getTankProperties() {
        return this.properties;
    }

    public int fill(FluidStack resource, boolean doFill) {
        if (this.hasInfusion) {
            return 0;
        }
        int filled = this.waterTank.fill(resource, false);
        if (filled == resource.amount && doFill) {
            this.waterTank.fill(resource, true);
            if (this.temp >= 3) {
                this.temp -= this.temp / 3;
                this.evaporation = 0;
            }
            if (doFill) {
                this.func_70296_d();
                IBlockState stat = this.field_145850_b.func_180495_p(this.field_174879_c);
                this.field_145850_b.func_184138_a(this.field_174879_c, stat, stat, 3);
            }
        }
        return filled;
    }

    public FluidStack drain(FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(int maxDrain, boolean doDrain) {
        return null;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY) {
            return (T)((Object)this);
        }
        return super.getCapability(capability, facing);
    }

    public void func_73660_a() {
        BlockPos pos = this.func_174877_v();
        if (this.updateRecipe) {
            this.updateInfusingRecipe();
            this.updateRecipe = false;
        }
        boolean updateBlock = false;
        if (this.hasInfusion && this.infusingRecipe != null) {
            if (!this.field_145850_b.field_72995_K) {
                ++this.infusionTime;
            } else if (this.prevInfusionState != this.currentInfusionState) {
                this.prevInfusionColor = this.currentInfusionColor;
                this.currentInfusionColor = ElixirRecipe.getInfusionColor(this.infusingRecipe, this.infusionTime);
            } else {
                this.currentInfusionColor = ElixirRecipe.getInfusionColor(this.infusingRecipe, this.infusionTime);
            }
            if (this.prevInfusionState != this.currentInfusionState && this.currentInfusionState == 2) {
                this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.INFUSER_FINISHED, SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            this.prevInfusionState = this.currentInfusionState;
            if (!this.field_145850_b.field_72995_K) {
                if (this.infusionTime > this.infusingRecipe.idealInfusionTime + this.infusingRecipe.infusionTimeVariation) {
                    if (this.currentInfusionState != 3) {
                        updateBlock = true;
                    }
                    this.currentInfusionState = 3;
                } else if (this.infusionTime > this.infusingRecipe.idealInfusionTime - this.infusingRecipe.infusionTimeVariation && this.infusionTime < this.infusingRecipe.idealInfusionTime + this.infusingRecipe.infusionTimeVariation) {
                    if (this.currentInfusionState != 2) {
                        updateBlock = true;
                    }
                    this.currentInfusionState = 2;
                } else {
                    if (this.currentInfusionState != 1) {
                        updateBlock = true;
                    }
                    this.currentInfusionState = 1;
                }
            }
            if (this.infusionColorGradientTicks > 0) {
                ++this.infusionColorGradientTicks;
            }
            if (!this.field_145850_b.field_72995_K && this.currentInfusionState != this.prevInfusionState) {
                this.infusionColorGradientTicks = 1;
                updateBlock = true;
            }
            if (!this.field_145850_b.field_72995_K && this.infusionColorGradientTicks > 30) {
                this.infusionColorGradientTicks = 0;
                updateBlock = true;
            }
            if (this.field_145850_b.field_72995_K && this.infusionColorGradientTicks > 0 && this.currentInfusionState == 2) {
                for (int i = 0; i < 10; ++i) {
                    double x = (float)pos.func_177958_n() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f;
                    double z = (float)pos.func_177952_p() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f;
                    BLParticles.STEAM_PURIFIER.spawn(this.field_145850_b, x, (double)pos.func_177956_o() + 1.0 - (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f), z);
                }
            }
        } else {
            if (this.currentInfusionState != 0) {
                updateBlock = true;
            }
            this.infusionTime = 0;
            if (this.hasIngredients() && this.temp >= 100) {
                if (this.infusionColorGradientTicks > 0) {
                    ++this.infusionColorGradientTicks;
                }
                if (!this.field_145850_b.field_72995_K && this.infusionColorGradientTicks == 0 && this.currentInfusionState == 0 && this.stirProgress == 89) {
                    this.infusionColorGradientTicks = 1;
                    this.currentInfusionState = 1;
                    this.field_145850_b.func_184148_a(null, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, (SoundEvent)SoundRegistry.INFUSER_FINISHED, SoundCategory.BLOCKS, 1.0f, 1.0f);
                    updateBlock = true;
                }
                if (!this.field_145850_b.field_72995_K && this.infusionColorGradientTicks > 30) {
                    this.infusionColorGradientTicks = 0;
                    this.currentInfusionState = 2;
                    updateBlock = true;
                }
                if (this.field_145850_b.field_72995_K && (this.infusionColorGradientTicks > 0 || this.currentInfusionState == 2)) {
                    this.prevInfusionColor = new float[]{0.2f, 0.6f, 0.4f, 1.0f};
                    this.currentInfusionColor = new float[]{0.8f, 0.0f, 0.8f, 1.0f};
                }
                if (this.field_145850_b.field_72995_K && this.infusionColorGradientTicks > 0) {
                    for (int i = 0; i < 10; ++i) {
                        double x = (float)pos.func_177958_n() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f;
                        double z = (float)pos.func_177952_p() + 0.25f + this.field_145850_b.field_73012_v.nextFloat() * 0.5f;
                        BLParticles.STEAM_PURIFIER.spawn(this.field_145850_b, x, (double)pos.func_177956_o() + 1.0 - (double)(this.field_145850_b.field_73012_v.nextFloat() * 0.2f), z);
                    }
                }
            } else {
                this.currentInfusionState = 0;
                this.currentInfusionColor = new float[]{0.2f, 0.6f, 0.4f, 1.0f};
                this.prevInfusionColor = this.currentInfusionColor;
            }
        }
        if (!this.field_145850_b.field_72995_K && updateBlock) {
            this.markForUpdate();
        }
        if (this.field_145850_b.field_72995_K) {
            if (this.isValidCrystalInstalled()) {
                this.crystalVelocity -= Math.signum(this.crystalVelocity) * 0.05f;
                this.crystalRotation += this.crystalVelocity;
                if (this.crystalRotation >= 360.0f) {
                    this.crystalRotation -= 360.0f;
                } else if (this.crystalRotation <= 360.0f) {
                    this.crystalRotation += 360.0f;
                }
                if (Math.abs(this.crystalVelocity) <= 1.0f && this.func_145831_w().field_73012_v.nextInt(15) == 0) {
                    this.crystalVelocity = this.field_145850_b.field_73012_v.nextFloat() * 18.0f - 9.0f;
                }
            }
            if (this.countUp && this.itemBob <= 20) {
                ++this.itemBob;
                if (this.itemBob == 20) {
                    this.countUp = false;
                }
            }
            if (!this.countUp && this.itemBob >= 0) {
                --this.itemBob;
                if (this.itemBob == 0) {
                    this.countUp = true;
                }
            }
            return;
        }
        if (this.infusionTime > 0 && this.infusionTime % 20 == 0) {
            this.markForUpdate();
        }
        if (this.stirProgress < 90) {
            ++this.stirProgress;
            this.markForUpdate();
        }
        if (this.stirProgress == 89) {
            if (this.temp == 100 && !this.hasInfusion && this.hasIngredients()) {
                this.hasInfusion = true;
                this.markForUpdate();
            }
            this.evaporation = 0;
        }
        if (this.field_145850_b.func_180495_p(pos.func_177977_b()).func_177230_c() == Blocks.field_150480_ab && this.temp < 100 && this.getWaterAmount() > 0 && this.field_145850_b.func_82737_E() % 12L == 0L) {
            ++this.temp;
            this.markForUpdate();
        }
        if (this.field_145850_b.func_180495_p(pos.func_177977_b()).func_177230_c() != Blocks.field_150480_ab && this.temp > 0 && this.field_145850_b.func_82737_E() % 6L == 0L) {
            --this.temp;
            this.markForUpdate();
        }
        if (this.temp == 100) {
            ++this.evaporation;
            if (this.evaporation == 600 && this.getWaterAmount() >= 1000) {
                this.extractFluids(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 1000));
            }
            this.markForUpdate();
        }
        if (this.temp < 100 && this.evaporation > 0) {
            --this.evaporation;
            this.markForUpdate();
        }
        if (this.isValidCrystalInstalled()) {
            if (this.temp >= 100 && this.evaporation >= 400 && this.stirProgress >= 90 && this.hasIngredients()) {
                ((ItemStack)this.inventory.get(7)).func_77964_b(((ItemStack)this.inventory.get(7)).func_77952_i() + 1);
                this.stirProgress = 0;
            }
            if (!this.hasCrystal) {
                this.hasCrystal = true;
                this.markForUpdate();
            }
        } else if (this.hasCrystal) {
            this.hasCrystal = false;
            this.markForUpdate();
        }
    }

    public int getInfusingState() {
        return this.currentInfusionState;
    }

    public int getInfusionColorGradientTicks() {
        return this.infusionColorGradientTicks;
    }

    public void extractFluids(FluidStack fluid) {
        if (fluid.isFluidEqual(this.waterTank.getFluid())) {
            this.waterTank.drain(fluid.amount, true);
        }
        if (this.getWaterAmount() == 0) {
            if (this.hasInfusion) {
                for (int i = 0; i <= 6; ++i) {
                    ItemStack stack = this.func_70301_a(i);
                    if (!stack.func_190926_b() && stack.func_77973_b() == ItemRegistry.ASPECT_VIAL) {
                        ItemStack ret = ItemStack.field_190927_a;
                        switch (stack.func_77952_i()) {
                            default: {
                                ret = new ItemStack((Item)ItemRegistry.DENTROTHYST_VIAL, 1, 0);
                                break;
                            }
                            case 1: {
                                ret = new ItemStack((Item)ItemRegistry.DENTROTHYST_VIAL, 1, 2);
                            }
                        }
                        EntityItem entity = new EntityItem(this.field_145850_b, (double)this.func_174877_v().func_177958_n() + 0.5, (double)this.func_174877_v().func_177956_o() + 1.0, (double)this.func_174877_v().func_177952_p() + 0.5, ret);
                        this.field_145850_b.func_72838_d((Entity)entity);
                    }
                    this.func_70299_a(i, ItemStack.field_190927_a);
                }
                if (this.evaporation == 600) {
                    EntityGasCloud gasCloud = new EntityGasCloud(this.field_145850_b);
                    if (this.infusingRecipe != null) {
                        float[] color = ElixirRecipe.getInfusionColor(this.infusingRecipe, this.infusionTime);
                        gasCloud.setGasColor((int)(color[0] * 255.0f), (int)(color[1] * 255.0f), (int)(color[2] * 255.0f), 170);
                    }
                    gasCloud.func_70012_b((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 1.0, (double)this.field_174879_c.func_177952_p() + 0.5, MathHelper.func_76142_g((float)(this.field_145850_b.field_73012_v.nextFloat() * 360.0f)), 0.0f);
                    this.field_145850_b.func_72838_d((Entity)gasCloud);
                }
                this.infusingRecipe = null;
            }
            this.hasInfusion = false;
            this.temp = 0;
            this.waterTank.setFluid(new FluidStack((Fluid)FluidRegistry.SWAMP_WATER, 0));
        }
        this.evaporation = 0;
        this.markForUpdate();
    }

    public void markForUpdate() {
        IBlockState state = this.field_145850_b.func_180495_p(this.func_174877_v());
        this.field_145850_b.func_184138_a(this.func_174877_v(), state, state, 2);
    }

    public int getWaterAmount() {
        return this.waterTank.getFluidAmount();
    }

    public int getTanksFullValue() {
        return this.waterTank.getCapacity();
    }

    public int getScaledWaterAmount(int scale) {
        return this.waterTank.getFluid() != null ? (int)((float)this.waterTank.getFluid().amount / (float)this.waterTank.getCapacity() * (float)scale) : 0;
    }

    public boolean isValidCrystalInstalled() {
        return !((ItemStack)this.inventory.get(7)).func_190926_b() && ((ItemStack)this.inventory.get(7)).func_77973_b() == ItemRegistry.LIFE_CRYSTAL && ((ItemStack)this.inventory.get(7)).func_77952_i() < ((ItemStack)this.inventory.get(7)).func_77958_k();
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("stirProgress", this.stirProgress);
        nbt.func_74768_a("evaporation", this.evaporation);
        nbt.func_74768_a("temp", this.temp);
        nbt.func_74768_a("infusionTime", this.infusionTime);
        nbt.func_74757_a("hasInfusion", this.hasInfusion);
        nbt.func_74757_a("hasCrystal", this.hasCrystal);
        nbt.func_74768_a("infusionState", this.currentInfusionState);
        nbt.func_74768_a("infusionColorGradientTicks", this.infusionColorGradientTicks);
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        this.stirProgress = nbt.func_74762_e("stirProgress");
        this.evaporation = nbt.func_74762_e("evaporation");
        this.temp = nbt.func_74762_e("temp");
        this.infusionTime = nbt.func_74762_e("infusionTime");
        this.hasInfusion = nbt.func_74767_n("hasInfusion");
        this.hasCrystal = nbt.func_74767_n("hasCrystal");
        this.currentInfusionState = nbt.func_74762_e("infusionState");
        this.infusionColorGradientTicks = nbt.func_74762_e("infusionColorGradientTicks");
        this.updateRecipe = true;
    }

    public SPacketUpdateTileEntity func_189518_D_() {
        return new SPacketUpdateTileEntity(this.func_174877_v(), 1, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SPacketUpdateTileEntity pkt) {
        NBTTagCompound nbt = pkt.func_148857_g();
        this.readInventoryNBT(nbt);
        this.waterTank.readFromNBT(nbt.func_74775_l("waterTank"));
        this.stirProgress = nbt.func_74762_e("stirProgress");
        this.evaporation = nbt.func_74762_e("evaporation");
        this.temp = nbt.func_74762_e("temp");
        this.infusionTime = nbt.func_74762_e("infusionTime");
        this.hasInfusion = nbt.func_74767_n("hasInfusion");
        this.hasCrystal = nbt.func_74767_n("hasCrystal");
        this.currentInfusionState = nbt.func_74762_e("infusionState");
        this.infusionColorGradientTicks = nbt.func_74762_e("infusionColorGradientTicks");
        this.updateInfusingRecipe();
    }

    public NBTTagCompound func_189517_E_() {
        NBTTagCompound nbt = super.func_189517_E_();
        this.writeInventoryNBT(nbt);
        nbt.func_74782_a("waterTank", (NBTBase)this.waterTank.writeToNBT(new NBTTagCompound()));
        nbt.func_74768_a("stirProgress", this.stirProgress);
        nbt.func_74768_a("evaporation", this.evaporation);
        nbt.func_74768_a("temp", this.temp);
        nbt.func_74768_a("infusionTime", this.infusionTime);
        nbt.func_74757_a("hasInfusion", this.hasInfusion);
        nbt.func_74757_a("hasCrystal", this.hasCrystal);
        nbt.func_74768_a("infusionState", this.currentInfusionState);
        nbt.func_74768_a("infusionColorGradientTicks", this.infusionColorGradientTicks);
        return nbt;
    }

    public boolean hasIngredients() {
        for (int i = 0; i <= 6; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return true;
        }
        return false;
    }

    public List<IAspectType> getInfusingAspects() {
        ArrayList<IAspectType> infusingAspects = new ArrayList<IAspectType>();
        for (int i = 0; i <= 6; ++i) {
            if (((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            ItemAspectContainer container = ItemAspectContainer.fromItem((ItemStack)this.inventory.get(i), AspectManager.get(this.field_145850_b));
            for (Aspect aspect : container.getAspects()) {
                infusingAspects.add(aspect.type);
            }
        }
        return infusingAspects;
    }

    public boolean hasFullIngredients() {
        for (int i = 0; i <= 6; ++i) {
            if (!((ItemStack)this.inventory.get(i)).func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean func_94041_b(int slot, ItemStack itemstack) {
        return !this.hasInfusion() && this.func_70301_a(slot).func_190926_b() && (slot <= 6 && ItemAspectContainer.fromItem(itemstack, AspectManager.get(this.field_145850_b)).getAspects().size() > 0 || slot == 7 && itemstack.func_77973_b() == ItemRegistry.LIFE_CRYSTAL);
    }

    @Override
    public int func_70297_j_() {
        return 1;
    }

    public void func_70296_d() {
        super.func_70296_d();
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        this.field_145850_b.func_184138_a(this.field_174879_c, state, state, 2);
    }

    public int getInfusionTime() {
        return this.infusionTime;
    }

    public float getCrystalRotation() {
        return this.crystalRotation;
    }

    public int getEvaporation() {
        return this.evaporation;
    }

    public boolean hasInfusion() {
        return this.hasInfusion;
    }

    public int getItemBob() {
        return this.itemBob;
    }

    public int getStirProgress() {
        return this.stirProgress;
    }

    public int getTemperature() {
        return this.temp;
    }

    public void setStirProgress(int progress) {
        this.stirProgress = progress;
    }

    public ElixirRecipe getInfusingRecipe() {
        return this.infusingRecipe;
    }

    public void updateInfusingRecipe() {
        if (this.field_145850_b != null) {
            this.infusingRecipe = ElixirRecipes.getFromAspects(this.getInfusingAspects());
        }
    }
}

