/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.network.clientbound;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.PositionedSoundRecord;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.SoundCategory;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.network.MessageBase;
import thebetweenlands.common.registries.SoundRegistry;
import thebetweenlands.common.sound.BLSoundEvent;

public class MessageRiftSound
extends MessageBase {
    private RiftSoundType type;

    public MessageRiftSound() {
    }

    public MessageRiftSound(RiftSoundType type) {
        this.type = type;
    }

    @Override
    public void deserialize(PacketBuffer buf) {
        this.type = RiftSoundType.values()[buf.readInt()];
    }

    @Override
    public void serialize(PacketBuffer buf) {
        buf.writeInt(this.type.ordinal());
    }

    @Override
    public IMessage process(MessageContext ctx) {
        if (ctx.side == Side.CLIENT) {
            this.handle();
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void handle() {
        if (Minecraft.func_71410_x().field_71441_e != null) {
            BLSoundEvent sound;
            switch (this.type) {
                default: {
                    sound = SoundRegistry.RIFT_CREAK;
                    break;
                }
                case OPEN: {
                    sound = SoundRegistry.RIFT_OPEN;
                }
            }
            final float pitchRange = this.type == RiftSoundType.CREAK ? Minecraft.func_71410_x().field_71441_e.field_73012_v.nextFloat() * 0.3f + 0.7f : 1.0f;
            Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new PositionedSoundRecord(sound.func_187503_a(), SoundCategory.AMBIENT, 1.0f, 1.0f, false, 0, ISound.AttenuationType.NONE, 0.0f, 0.0f, 0.0f){

                public float func_147655_f() {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null && player.field_70163_u < 110.0) {
                        return (0.5f + (float)player.field_70163_u / 110.0f * 0.5f) * pitchRange;
                    }
                    return 1.0f;
                }

                public float func_147653_e() {
                    EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
                    if (player != null && player.field_70163_u < 110.0) {
                        return 0.15f + (float)player.field_70163_u / 110.0f * 0.85f;
                    }
                    return 1.0f;
                }
            });
        }
    }

    public static enum RiftSoundType {
        CREAK,
        OPEN;

    }
}

