/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.item.tools;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidActionResult;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.UniversalBucket;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import net.minecraftforge.fluids.capability.templates.FluidHandlerItemStackSimple;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.ItemHandlerHelper;
import thebetweenlands.client.handler.ItemTooltipHandler;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.block.container.BlockInfuser;
import thebetweenlands.common.block.misc.BlockRubberTap;
import thebetweenlands.common.block.terrain.BlockRubberLog;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.item.tools.ItemSpecificBucket;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class ItemBLBucket
extends UniversalBucket
implements ItemRegistry.IMultipleItemModelDefinition {
    private final ItemStack emptyWeedwood;
    private final ItemStack emptySyrmorite;

    public ItemBLBucket() {
        this(null);
    }

    public ItemBLBucket(Item bucket) {
        super(1000, ItemStack.field_190927_a, true);
        this.emptyWeedwood = new ItemStack((Item)(bucket != null ? bucket : this), 1, 0);
        this.emptySyrmorite = new ItemStack((Item)(bucket != null ? bucket : this), 1, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74782_a("Fluid", (NBTBase)new NBTTagCompound());
        this.emptyWeedwood.func_77982_d(nbt);
        this.emptySyrmorite.func_77982_d(nbt.func_74737_b());
        this.func_77627_a(true);
        this.func_77625_d(16);
        this.func_77656_e(0);
        this.func_77637_a(BLCreativeTabs.GEARS);
    }

    public void func_77622_d(ItemStack stack, World worldIn, EntityPlayer playerIn) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        nbt.func_74782_a("Fluid", (NBTBase)new NBTTagCompound());
        stack.func_77982_d(nbt);
    }

    @Override
    public Map<Integer, ResourceLocation> getModels() {
        HashMap<Integer, ResourceLocation> models = new HashMap<Integer, ResourceLocation>();
        models.put(0, new ResourceLocation(this.getRegistryName().toString() + "_weedwood"));
        models.put(1, new ResourceLocation(this.getRegistryName().toString() + "_syrmorite"));
        return models;
    }

    public int getItemStackLimit(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack != null) {
            return 1;
        }
        return super.getItemStackLimit(stack);
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, NBTTagCompound nbt) {
        if (!stack.func_77942_o()) {
            stack.func_77982_d(new NBTTagCompound());
        }
        return new FluidBLBucketHandler(stack, this.getCapacity());
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= 2) {
            return this.func_77658_a() + ".unknown";
        }
        return this.func_77658_a() + (stack.func_77960_j() == 0 ? "_weedwood" : "_syrmorite");
    }

    public String func_77653_i(ItemStack stack) {
        FluidStack fluidStack = this.getFluid(stack);
        String unlocName = this.getEmpty(stack).func_77977_a();
        if (fluidStack == null) {
            return I18n.func_74838_a((String)(unlocName + ".name")).trim();
        }
        String fluidUnlocKey = unlocName + "." + fluidStack.getUnlocalizedName() + ".name";
        if (I18n.func_94522_b((String)fluidUnlocKey)) {
            return I18n.func_74838_a((String)fluidUnlocKey).trim();
        }
        return I18n.func_74837_a((String)(this.getEmpty(stack).func_77977_a() + ".filled.name"), (Object[])new Object[]{fluidStack.getFluid().getRarity((FluidStack)fluidStack).field_77937_e + fluidStack.getLocalizedName() + TextFormatting.WHITE});
    }

    public ActionResult<ItemStack> func_77659_a(World world, EntityPlayer player, EnumHand hand) {
        ActionResult<ItemStack> tapResult;
        ItemStack heldItem = player.func_184586_b(hand);
        FluidStack fluidStack = this.getFluid(heldItem);
        if (world.field_72995_K) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        if (fluidStack == null && (tapResult = this.tryPlaceTreeTap(world, player, heldItem)).func_188397_a() == EnumActionResult.SUCCESS) {
            return tapResult;
        }
        RayTraceResult target = this.func_77621_a(world, player, true);
        if (target == null || target.field_72313_a != RayTraceResult.Type.BLOCK) {
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        BlockPos pos = target.func_178782_a();
        if (fluidStack != null) {
            ActionResult result = super.func_77659_a(world, player, hand);
            if (result.func_188397_a() == EnumActionResult.SUCCESS) {
                world.func_184133_a(null, pos, fluidStack.getFluid().getEmptySound(fluidStack), SoundCategory.BLOCKS, 1.0f, 1.0f);
            }
            return result;
        }
        ActionResult ret = ForgeEventFactory.onBucketUse((EntityPlayer)player, (World)world, (ItemStack)heldItem, (RayTraceResult)target);
        if (ret != null) {
            return ret;
        }
        if (world.func_175660_a(player, pos) && player.func_175151_a(pos, target.field_178784_b, heldItem)) {
            ItemStack singleBucket = heldItem.func_77946_l();
            singleBucket.func_190920_e(1);
            FluidActionResult filledResult = FluidUtil.tryPickUpFluid((ItemStack)singleBucket, (EntityPlayer)player, (World)world, (BlockPos)pos, (EnumFacing)target.field_178784_b);
            if (filledResult.isSuccess()) {
                FluidStack fluidStack1 = this.getFluid(filledResult.getResult());
                world.func_184133_a(null, pos, fluidStack1.getFluid().getFillSound(fluidStack1), SoundCategory.BLOCKS, 1.0f, 1.0f);
                ItemStack filledBucket = filledResult.result;
                if (player.field_71075_bZ.field_75098_d) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
                }
                heldItem.func_190918_g(1);
                if (heldItem.func_190926_b()) {
                    return new ActionResult(EnumActionResult.SUCCESS, (Object)filledBucket);
                }
                ItemHandlerHelper.giveItemToPlayer((EntityPlayer)player, (ItemStack)filledBucket);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
            }
            return new ActionResult(EnumActionResult.PASS, (Object)heldItem);
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)heldItem);
    }

    private ActionResult<ItemStack> tryPlaceTreeTap(World world, EntityPlayer player, ItemStack itemStack) {
        BlockPos pos;
        RayTraceResult result = this.func_77621_a(world, player, true);
        if (result != null && result.field_72313_a == RayTraceResult.Type.BLOCK && result.field_178784_b.func_176740_k() != EnumFacing.Axis.Y && player.func_175151_a(pos = result.func_178782_a(), result.field_178784_b, itemStack)) {
            BlockPos offset;
            Block rubberTap;
            IBlockState blockState = world.func_180495_p(pos);
            Block block = rubberTap = itemStack.func_77960_j() == 0 ? BlockRegistry.WEEDWOOD_RUBBER_TAP : BlockRegistry.SYRMORITE_RUBBER_TAP;
            if (blockState.func_177230_c() == BlockRegistry.LOG_RUBBER && ((Boolean)blockState.func_177229_b((IProperty)BlockRubberLog.NATURAL)).booleanValue() && world.func_180495_p(offset = pos.func_177972_a(result.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)world, offset) && rubberTap.func_176196_c(world, offset)) {
                world.func_175656_a(offset, rubberTap.func_176223_P().func_177226_a((IProperty)BlockRubberTap.field_185512_D, (Comparable)result.field_178784_b));
                itemStack.func_190918_g(1);
                world.func_184133_a(null, pos, SoundEvents.field_187891_gV, SoundCategory.PLAYERS, 1.0f, 1.0f);
                return new ActionResult(EnumActionResult.SUCCESS, (Object)itemStack);
            }
        }
        return new ActionResult(EnumActionResult.FAIL, (Object)itemStack);
    }

    public void func_150895_a(@Nullable CreativeTabs tab, NonNullList<ItemStack> subItems) {
        if (!this.func_194125_a(tab)) {
            return;
        }
        subItems.add((Object)this.emptyWeedwood);
        subItems.add((Object)this.emptySyrmorite);
        for (int i = 0; i < 2; ++i) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                if (fluid == FluidRegistry.WATER || fluid == FluidRegistry.LAVA || fluid.getName().equals("milk") || ItemSpecificBucket.hasSpecificBucket(fluid) || !BetweenlandsConfig.COMPATIBILITY.showNonBLFluids && !thebetweenlands.common.registries.FluidRegistry.REGISTERED_FLUIDS.contains(fluid) || i == 0 && fluid.getTemperature() > 430) continue;
                FluidStack fs = new FluidStack(fluid, this.getCapacity());
                ItemStack stack = new ItemStack((Item)this, 1, i);
                IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
                if (fluidHandler == null || fluidHandler.fill(fs, true) != fs.amount) continue;
                ItemStack filled = fluidHandler.getContainer();
                subItems.add((Object)filled);
            }
        }
    }

    public boolean doesSneakBypassUse(ItemStack stack, IBlockAccess world, BlockPos pos, EntityPlayer player) {
        return world.func_180495_p(pos).func_177230_c() instanceof BlockInfuser;
    }

    public boolean hasContainerItem(ItemStack stack) {
        return !this.getEmpty(stack).func_190926_b();
    }

    @Nonnull
    public ItemStack getContainerItem(@Nonnull ItemStack itemStack) {
        if (!this.getEmpty(itemStack).func_190926_b()) {
            return this.getEmpty(itemStack).func_77946_l();
        }
        return super.getContainerItem(itemStack);
    }

    @Nullable
    public FluidStack getFluid(ItemStack container) {
        NBTTagCompound tagCompound = container.func_77978_p();
        if (tagCompound == null || !tagCompound.func_74764_b("Fluid")) {
            return null;
        }
        return FluidStack.loadFluidStackFromNBT((NBTTagCompound)tagCompound.func_74775_l("Fluid"));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        FluidStack fluidStack = this.getFluid(stack);
        if (fluidStack == null) {
            tooltip.addAll(ItemTooltipHandler.splitTooltip(I18n.func_74837_a((String)"tooltip.bl_bucket", (Object[])new Object[0]), 0));
        }
    }

    public ItemStack getEmpty(ItemStack stack) {
        return stack.func_77960_j() == 1 ? this.emptySyrmorite : this.emptyWeedwood;
    }

    public ItemStack withFluid(int meta, Fluid fluid) {
        FluidStack fs = new FluidStack(fluid, this.getCapacity());
        ItemStack stack = new ItemStack((Item)this, 1, meta);
        IFluidHandlerItem fluidHandler = (IFluidHandlerItem)stack.getCapability(CapabilityFluidHandler.FLUID_HANDLER_ITEM_CAPABILITY, null);
        fluidHandler.fill(fs, true);
        return fluidHandler.getContainer();
    }

    private static final class FluidBLBucketHandler
    extends FluidHandlerItemStackSimple {
        public FluidBLBucketHandler(ItemStack container, int capacity) {
            super(container, capacity);
        }

        public boolean canFillFluidType(FluidStack fluid) {
            boolean canHold = this.container.func_77960_j() == 1 || this.container.func_77960_j() == 0 && fluid.getFluid().getTemperature(fluid) <= 430;
            return canHold && (fluid.getFluid() == FluidRegistry.WATER || fluid.getFluid() == FluidRegistry.LAVA || fluid.getFluid().getName().equals("milk") || FluidRegistry.getBucketFluids().contains(fluid.getFluid()));
        }

        @Nullable
        public FluidStack getFluid() {
            return ((ItemBLBucket)this.container.func_77973_b()).getFluid(this.container);
        }

        protected void setContainerToEmpty() {
            this.container = ((ItemBLBucket)this.container.func_77973_b()).getEmpty(this.container).func_77946_l();
        }

        protected void setFluid(FluidStack fluid) {
            ItemSpecificBucket specificBucket;
            if (!this.container.func_190926_b() && this.container.func_185136_b(((ItemBLBucket)this.container.func_77973_b()).getEmpty(this.container)) && (specificBucket = ItemSpecificBucket.getSpecificBucket(fluid.getFluid())) != null) {
                this.container = new ItemStack((Item)specificBucket, 1, this.container.func_77960_j());
            }
            super.setFluid(fluid);
        }
    }
}

