/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;
import net.minecraft.block.Block;
import net.minecraft.block.BlockTorch;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBow;
import net.minecraft.item.ItemFlintAndSteel;
import net.minecraft.item.ItemFood;
import net.minecraft.item.ItemPotion;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemSword;
import net.minecraft.item.ItemTool;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.player.BonemealEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.world.BlockEvent;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.api.event.ArmSwingSpeedEvent;
import thebetweenlands.common.block.misc.BlockDampTorch;
import thebetweenlands.common.config.BetweenlandsConfig;
import thebetweenlands.common.item.tools.ItemBLAxe;
import thebetweenlands.common.item.tools.ItemBLPickaxe;
import thebetweenlands.common.item.tools.ItemBLShovel;
import thebetweenlands.common.item.tools.ItemBLSword;
import thebetweenlands.common.item.tools.bow.ItemBLBow;
import thebetweenlands.common.registries.AdvancementCriterionRegistry;
import thebetweenlands.common.registries.BlockRegistry;
import thebetweenlands.common.registries.GameruleRegistry;
import thebetweenlands.common.registries.ItemRegistry;

public class OverworldItemHandler {
    public static final Map<ResourceLocation, Predicate<ItemStack>> ROTTING_WHITELIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> ROTTING_BLACKLIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> TAINTING_WHITELIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> TAINTING_BLACKLIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> FIRE_TOOL_WHITELIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> FIRE_TOOL_BLACKLIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> FERTILIZER_WHITELIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> FERTILIZER_BLACKLIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> TOOL_WHITELIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> TOOL_BLACKLIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> TORCH_WHITELIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, Predicate<ItemStack>> TORCH_BLACKLIST = new HashMap<ResourceLocation, Predicate<ItemStack>>();
    public static final Map<ResourceLocation, ITorchPlaceHandler> TORCH_PLACE_HANDLERS = new HashMap<ResourceLocation, ITorchPlaceHandler>();

    private OverworldItemHandler() {
    }

    @SubscribeEvent
    public static void onPlayerTorchPlacement(BlockEvent.PlaceEvent event) {
        ItemStack held;
        if (event.getPlayer().field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && !(held = event.getPlayer().func_184586_b(event.getHand())).func_190926_b()) {
            for (ITorchPlaceHandler handler : TORCH_PLACE_HANDLERS.values()) {
                if (!handler.isTorchItem(held)) continue;
                if (handler.onTorchItemPlaced(event.getWorld(), event.getPos(), held, event.getPlayer())) break;
                handler.onTorchBlockPlaced(event.getWorld(), event.getPos(), event.getState(), held, event.getPlayer());
                break;
            }
        }
    }

    @SubscribeEvent
    public static void onUseItem(PlayerInteractEvent.RightClickBlock event) {
        ItemStack item = event.getItemStack();
        if (!item.func_190926_b() && event.getEntityPlayer().field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && OverworldItemHandler.isFireToolBlocked(item)) {
            event.setUseItem(Event.Result.DENY);
            event.setCanceled(true);
            if (event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("chat.flintandsteel", new Object[]{new TextComponentTranslation(item.func_77977_a() + ".name", new Object[0])}), true);
            }
        }
    }

    @SubscribeEvent
    public static void onBonemeal(BonemealEvent event) {
        ItemStack stack;
        if (event.getEntityPlayer().field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && !(stack = event.getEntityPlayer().func_184586_b(event.getHand())).func_190926_b() && OverworldItemHandler.isFertilizerBlocked(stack)) {
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
            if (event.getWorld().field_72995_K) {
                event.getEntityPlayer().func_146105_b((ITextComponent)new TextComponentTranslation("chat.fertilizer", new Object[]{new TextComponentTranslation(stack.func_77977_a() + ".name", new Object[0])}), true);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent
    public static void onArmSwingSpeed(ArmSwingSpeedEvent event) {
        ItemStack tool;
        if (event.getEntityLiving().field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && !(tool = event.getEntityLiving().func_184614_ca()).func_190926_b() && OverworldItemHandler.isToolWeakened(tool)) {
            event.setSpeed(event.getSpeed() * 0.3f);
        }
    }

    @SubscribeEvent
    public static void onBreakSpeed(PlayerEvent.BreakSpeed event) {
        ItemStack tool;
        if (event.getEntityPlayer().field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId && !(tool = event.getEntityPlayer().func_184614_ca()).func_190926_b() && OverworldItemHandler.isToolWeakened(tool)) {
            event.setNewSpeed(event.getNewSpeed() * 0.3f);
        }
    }

    @SubscribeEvent
    public static void onEntitySpawn(EntityJoinWorldEvent event) {
        if (event.getEntity() instanceof EntityPlayer && !((EntityPlayer)event.getEntity()).field_71075_bZ.field_75098_d) {
            OverworldItemHandler.updatePlayerInventory((EntityPlayer)event.getEntity());
        }
    }

    @SubscribeEvent
    public static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (!event.player.field_70170_p.field_72995_K && event.player.field_70173_aa % 5 == 0 && !event.player.field_71075_bZ.field_75098_d) {
            OverworldItemHandler.updatePlayerInventory(event.player);
        }
    }

    private static void updatePlayerInventory(EntityPlayer player) {
        int invCount = player.field_71071_by.func_70302_i_();
        if (player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
            for (int i = 0; i < invCount; ++i) {
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (OverworldItemHandler.isRotting(stack)) {
                    ItemStack rottenFoodStack = new ItemStack((Item)ItemRegistry.ROTTEN_FOOD, stack.func_190916_E());
                    stack.func_190920_e(1);
                    ItemRegistry.ROTTEN_FOOD.setOriginalStack(rottenFoodStack, stack);
                    player.field_71071_by.func_70299_a(i, rottenFoodStack);
                    continue;
                }
                if (!OverworldItemHandler.isTainting(stack)) continue;
                ItemStack taintedPotionStack = new ItemStack((Item)ItemRegistry.TAINTED_POTION, stack.func_190916_E());
                stack.func_190920_e(1);
                ItemRegistry.TAINTED_POTION.setOriginalStack(taintedPotionStack, stack);
                player.field_71071_by.func_70299_a(i, taintedPotionStack);
            }
        } else {
            for (int i = 0; i < invCount; ++i) {
                ItemStack originalStack;
                ItemStack stack = player.field_71071_by.func_70301_a(i);
                if (stack.func_190926_b()) continue;
                if (BetweenlandsConfig.GENERAL.reverseRottenFood && stack.func_77973_b() == ItemRegistry.ROTTEN_FOOD) {
                    originalStack = ItemRegistry.ROTTEN_FOOD.getOriginalStack(stack);
                    if (!originalStack.func_190926_b()) {
                        originalStack.func_190920_e(stack.func_190916_E());
                        player.field_71071_by.func_70299_a(i, originalStack);
                        continue;
                    }
                    player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
                    continue;
                }
                if (stack.func_77973_b() != ItemRegistry.TAINTED_POTION) continue;
                originalStack = ItemRegistry.TAINTED_POTION.getOriginalStack(stack);
                if (!originalStack.func_190926_b()) {
                    originalStack.func_190920_e(stack.func_190916_E());
                    player.field_71071_by.func_70299_a(i, originalStack);
                    continue;
                }
                player.field_71071_by.func_70299_a(i, ItemStack.field_190927_a);
            }
        }
    }

    @SubscribeEvent
    public static void onItemPickup(EntityItemPickupEvent event) {
        ItemStack stack;
        EntityPlayer player = event.getEntityPlayer();
        if (!(player == null || player.field_70170_p.field_72995_K || player.field_71075_bZ.field_75098_d || (stack = event.getItem().func_92059_d()).func_190926_b())) {
            if (player.field_71093_bK == BetweenlandsConfig.WORLD_AND_DIMENSION.dimensionId) {
                if (OverworldItemHandler.isRotting(stack)) {
                    ItemStack rottenFoodStack = new ItemStack((Item)ItemRegistry.ROTTEN_FOOD, stack.func_190916_E());
                    ItemRegistry.ROTTEN_FOOD.setOriginalStack(rottenFoodStack, stack);
                    event.getItem().func_92058_a(rottenFoodStack);
                } else if (OverworldItemHandler.isTainting(stack)) {
                    ItemStack taintedPotionStack = new ItemStack((Item)ItemRegistry.TAINTED_POTION, stack.func_190916_E());
                    ItemRegistry.TAINTED_POTION.setOriginalStack(taintedPotionStack, stack);
                    event.getItem().func_92058_a(taintedPotionStack);
                }
            } else if (BetweenlandsConfig.GENERAL.reverseRottenFood && stack.func_77973_b() == ItemRegistry.ROTTEN_FOOD) {
                ItemStack originalStack = ItemRegistry.ROTTEN_FOOD.getOriginalStack(stack);
                if (!originalStack.func_190926_b()) {
                    event.getItem().func_92058_a(originalStack);
                } else {
                    event.getItem().func_70106_y();
                    event.setCanceled(true);
                }
            } else if (stack.func_77973_b() == ItemRegistry.TAINTED_POTION) {
                ItemStack originalStack = ItemRegistry.TAINTED_POTION.getOriginalStack(stack);
                if (!originalStack.func_190926_b()) {
                    event.getItem().func_92058_a(originalStack);
                } else {
                    event.getItem().func_70106_y();
                    event.setCanceled(true);
                }
            }
        }
    }

    public static boolean isRotting(ItemStack stack) {
        if (!BetweenlandsConfig.GENERAL.useRottenFood || !GameruleRegistry.getGameRuleBooleanValue("blRottenFood")) {
            return false;
        }
        for (Predicate<ItemStack> whitelistPredicate : ROTTING_WHITELIST.values()) {
            if (!whitelistPredicate.test(stack)) continue;
            return false;
        }
        for (Predicate<ItemStack> blacklistPredicate : ROTTING_BLACKLIST.values()) {
            if (!blacklistPredicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTainting(ItemStack stack) {
        if (!BetweenlandsConfig.GENERAL.usePotionBlacklist || !GameruleRegistry.getGameRuleBooleanValue("blPotionBlacklist")) {
            return false;
        }
        for (Predicate<ItemStack> whitelistPredicate : TAINTING_WHITELIST.values()) {
            if (!whitelistPredicate.test(stack)) continue;
            return false;
        }
        for (Predicate<ItemStack> blacklistPredicate : TAINTING_BLACKLIST.values()) {
            if (!blacklistPredicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFireToolBlocked(ItemStack stack) {
        if (!BetweenlandsConfig.GENERAL.useFireToolBlacklist || !GameruleRegistry.getGameRuleBooleanValue("blFireToolBlacklist")) {
            return false;
        }
        for (Predicate<ItemStack> whitelistPredicate : FIRE_TOOL_WHITELIST.values()) {
            if (!whitelistPredicate.test(stack)) continue;
            return false;
        }
        for (Predicate<ItemStack> blacklistPredicate : FIRE_TOOL_BLACKLIST.values()) {
            if (!blacklistPredicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isFertilizerBlocked(ItemStack stack) {
        if (!BetweenlandsConfig.GENERAL.useFertilizerBlacklist || !GameruleRegistry.getGameRuleBooleanValue("blFertilizerBlacklist")) {
            return false;
        }
        for (Predicate<ItemStack> whitelistPredicate : FERTILIZER_WHITELIST.values()) {
            if (!whitelistPredicate.test(stack)) continue;
            return false;
        }
        for (Predicate<ItemStack> blacklistPredicate : FERTILIZER_BLACKLIST.values()) {
            if (!blacklistPredicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isToolWeakened(ItemStack stack) {
        if (!BetweenlandsConfig.GENERAL.useToolWeakness || !GameruleRegistry.getGameRuleBooleanValue("blToolWeakness")) {
            return false;
        }
        for (Predicate<ItemStack> whitelistPredicate : TOOL_WHITELIST.values()) {
            if (!whitelistPredicate.test(stack)) continue;
            return false;
        }
        for (Predicate<ItemStack> blacklistPredicate : TOOL_BLACKLIST.values()) {
            if (!blacklistPredicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    public static boolean isTorchTurningDamp(ItemStack stack) {
        if (!BetweenlandsConfig.GENERAL.useTorchBlacklist || !GameruleRegistry.getGameRuleBooleanValue("blTorchBlacklist")) {
            return false;
        }
        for (Predicate<ItemStack> whitelistPredicate : TORCH_WHITELIST.values()) {
            if (!whitelistPredicate.test(stack)) continue;
            return false;
        }
        for (Predicate<ItemStack> blacklistPredicate : TORCH_BLACKLIST.values()) {
            if (!blacklistPredicate.test(stack)) continue;
            return true;
        }
        return false;
    }

    static {
        ROTTING_WHITELIST.put(new ResourceLocation("thebetweenlands", "config_whitelist"), stack -> BetweenlandsConfig.GENERAL.rottenFoodWhitelist.isListed((ItemStack)stack));
        ROTTING_BLACKLIST.put(new ResourceLocation("thebetweenlands", "config_blacklist"), stack -> BetweenlandsConfig.GENERAL.rottenFoodBlacklist.isListed((ItemStack)stack));
        ROTTING_BLACKLIST.put(new ResourceLocation("thebetweenlands", "default_blacklist"), stack -> {
            if (stack.func_77973_b() == Items.field_151105_aU || Block.func_149634_a((Item)stack.func_77973_b()) == Blocks.field_150414_aQ) {
                return true;
            }
            return stack.func_77973_b() instanceof ItemFood && stack.func_77973_b() != Items.field_151078_bh && !ItemRegistry.ITEMS.contains(stack.func_77973_b());
        });
        TAINTING_WHITELIST.put(new ResourceLocation("thebetweenlands", "config_whitelist"), stack -> BetweenlandsConfig.GENERAL.taintingWhitelist.isListed((ItemStack)stack));
        TAINTING_BLACKLIST.put(new ResourceLocation("thebetweenlands", "config_blacklist"), stack -> BetweenlandsConfig.GENERAL.taintingBlacklist.isListed((ItemStack)stack));
        TAINTING_BLACKLIST.put(new ResourceLocation("thebetweenlands", "default_blacklist"), stack -> stack.func_77973_b() instanceof ItemPotion);
        FIRE_TOOL_WHITELIST.put(new ResourceLocation("thebetweenlands", "config_whitelist"), stack -> BetweenlandsConfig.GENERAL.fireToolWhitelist.isListed((ItemStack)stack));
        FIRE_TOOL_BLACKLIST.put(new ResourceLocation("thebetweenlands", "config_blacklist"), stack -> BetweenlandsConfig.GENERAL.fireToolBlacklist.isListed((ItemStack)stack));
        FIRE_TOOL_BLACKLIST.put(new ResourceLocation("thebetweenlands", "default_blacklist"), stack -> stack.func_77973_b() instanceof ItemFlintAndSteel);
        FERTILIZER_WHITELIST.put(new ResourceLocation("thebetweenlands", "config_whitelist"), stack -> BetweenlandsConfig.GENERAL.fertilizerWhitelist.isListed((ItemStack)stack));
        FERTILIZER_BLACKLIST.put(new ResourceLocation("thebetweenlands", "config_blacklist"), stack -> BetweenlandsConfig.GENERAL.fertilizerBlacklist.isListed((ItemStack)stack));
        FERTILIZER_BLACKLIST.put(new ResourceLocation("thebetweenlands", "default_blacklist"), stack -> stack.func_77973_b() == Items.field_151100_aR);
        TOOL_WHITELIST.put(new ResourceLocation("thebetweenlands", "config_whitelist"), stack -> BetweenlandsConfig.GENERAL.toolWeaknessWhitelist.isListed((ItemStack)stack));
        TOOL_BLACKLIST.put(new ResourceLocation("thebetweenlands", "config_blacklist"), stack -> BetweenlandsConfig.GENERAL.toolWeaknessBlacklist.isListed((ItemStack)stack));
        TOOL_BLACKLIST.put(new ResourceLocation("thebetweenlands", "default_blacklist"), stack -> (stack.func_77973_b() instanceof ItemTool || stack.func_77973_b() instanceof ItemSword || stack.func_77973_b() instanceof ItemBow) && !(stack.func_77973_b() instanceof ItemBLSword) && !(stack.func_77973_b() instanceof ItemBLAxe) && !(stack.func_77973_b() instanceof ItemBLPickaxe) && !(stack.func_77973_b() instanceof ItemBLShovel) && !(stack.func_77973_b() instanceof ItemBLBow) && !ItemRegistry.ITEMS.contains(stack.func_77973_b()));
        TORCH_WHITELIST.put(new ResourceLocation("thebetweenlands", "config_whitelist"), stack -> BetweenlandsConfig.GENERAL.torchWhitelist.isListed((ItemStack)stack));
        TORCH_BLACKLIST.put(new ResourceLocation("thebetweenlands", "config_blacklist"), stack -> BetweenlandsConfig.GENERAL.torchBlacklist.isListed((ItemStack)stack));
        TORCH_BLACKLIST.put(new ResourceLocation("thebetweenlands", "default_blacklist"), stack -> {
            Block block = Block.func_149634_a((Item)stack.func_77973_b());
            return block instanceof BlockTorch && !BlockRegistry.BLOCKS.contains(block);
        });
        ITorchPlaceHandler vanillaTorchPlaceHandler = new ITorchPlaceHandler(){

            @Override
            public ResourceLocation getID() {
                return new ResourceLocation("thebetweenlands", "vanilla_torch");
            }

            @Override
            public boolean isTorchItem(ItemStack stack) {
                return OverworldItemHandler.isTorchTurningDamp(stack);
            }

            @Override
            public void onTorchBlockPlaced(World world, BlockPos pos, IBlockState state, ItemStack stack, EntityPlayer player) {
                EnumFacing facing = null;
                try {
                    facing = (EnumFacing)state.func_177229_b((IProperty)BlockTorch.field_176596_a);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (facing == null) {
                    ArrayList dirs = new ArrayList();
                    Collections.addAll(dirs, EnumFacing.field_82609_l);
                    Collections.shuffle(dirs, world.field_73012_v);
                    for (EnumFacing dir : dirs) {
                        if (dir == EnumFacing.DOWN) continue;
                        IBlockState offsetState = world.func_180495_p(pos.func_177972_a(dir.func_176734_d()));
                        if ((dir != EnumFacing.UP || !offsetState.func_177230_c().canPlaceTorchOnTop(offsetState, (IBlockAccess)world, pos.func_177972_a(dir.func_176734_d()))) && !world.isSideSolid(pos.func_177972_a(dir.func_176734_d()), dir)) continue;
                        facing = dir;
                        break;
                    }
                }
                if (facing != null) {
                    IBlockState dampTorch = BlockRegistry.DAMP_TORCH.func_176223_P().func_177226_a((IProperty)BlockDampTorch.field_176596_a, (Comparable)facing);
                    world.func_175656_a(pos, dampTorch);
                } else {
                    world.func_175698_g(pos);
                    world.func_72838_d((Entity)new EntityItem(world, (double)pos.func_177958_n() + 0.5, (double)pos.func_177956_o() + 0.5, (double)pos.func_177952_p() + 0.5, new ItemStack(BlockRegistry.DAMP_TORCH)));
                }
                world.func_184148_a(null, (double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), SoundEvents.field_187646_bt, SoundCategory.BLOCKS, 0.2f, 1.0f);
                if (player instanceof EntityPlayerMP) {
                    AdvancementCriterionRegistry.DAMP_TORCH_PLACED.trigger((EntityPlayerMP)player);
                }
            }
        };
        TORCH_PLACE_HANDLERS.put(vanillaTorchPlaceHandler.getID(), vanillaTorchPlaceHandler);
    }

    public static interface ITorchPlaceHandler {
        public ResourceLocation getID();

        public boolean isTorchItem(ItemStack var1);

        default public boolean onTorchItemPlaced(World world, BlockPos pos, ItemStack stack, EntityPlayer player) {
            return false;
        }

        default public void onTorchBlockPlaced(World world, BlockPos pos, IBlockState state, ItemStack stack, EntityPlayer player) {
        }
    }
}

