/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagLong;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.SpikeRenderer;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.render.particle.entity.ParticleRootSpike;
import thebetweenlands.common.registries.SoundRegistry;

public class EntitySpikeWave
extends Entity
implements IEntityAdditionalSpawnData {
    protected List<BlockPos> positions = new ArrayList<BlockPos>();
    private AxisAlignedBB blockEnclosingBounds;
    private AxisAlignedBB renderingBounds;
    public BlockPos origin;
    public int delay;
    @Nullable
    @SideOnly(value=Side.CLIENT)
    public Map<BlockPos, List<SpikeRenderer>> modelParts;
    protected float attackDamage = 10.0f;

    public EntitySpikeWave(World world) {
        super(world);
        this.func_70105_a(1.0f, 1.0f);
        this.field_70145_X = true;
    }

    public void setAttackDamage(float damage) {
        this.attackDamage = damage;
    }

    public void addPosition(BlockPos pos) {
        if (this.origin == null) {
            this.origin = pos;
            this.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o(), (double)pos.func_177952_p() + 0.5);
            this.field_70142_S = this.field_70169_q = this.field_70165_t;
            this.field_70137_T = this.field_70167_r = this.field_70163_u;
            this.field_70136_U = this.field_70166_s = this.field_70161_v;
        }
        this.positions.add(pos);
        AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72321_a(0.0, 1.0, 0.0);
        this.blockEnclosingBounds = this.blockEnclosingBounds == null ? aabb : this.blockEnclosingBounds.func_111270_a(aabb);
        this.renderingBounds = this.blockEnclosingBounds.func_72317_d(this.field_70165_t - ((double)this.origin.func_177958_n() + 0.5), this.field_70163_u - (double)this.origin.func_177956_o(), this.field_70161_v - ((double)this.origin.func_177952_p() + 0.5));
    }

    @SideOnly(value=Side.CLIENT)
    public void initRootModels() {
        if (this.modelParts == null) {
            this.modelParts = new HashMap<BlockPos, List<SpikeRenderer>>();
            for (BlockPos pos : this.positions) {
                int models = 1 + this.field_70146_Z.nextInt(2);
                ArrayList<SpikeRenderer> renderers = new ArrayList<SpikeRenderer>();
                for (int i = 0; i < models; ++i) {
                    Vec3d offset = new Vec3d((double)pos.func_177958_n() + this.field_70146_Z.nextDouble() * 0.6 - 0.3 - this.field_70165_t, (double)pos.func_177956_o() + 0.25 - this.field_70163_u, (double)pos.func_177952_p() + this.field_70146_Z.nextDouble() * 0.6 - 0.3 - this.field_70161_v);
                    float scale = 0.4f + this.field_70146_Z.nextFloat() * 0.2f;
                    SpikeRenderer renderer = new SpikeRenderer(2, scale * 0.5f, scale, 1.0f, this.field_70146_Z.nextLong(), offset.field_72450_a, offset.field_72448_b, offset.field_72449_c).build(DefaultVertexFormats.field_181703_c, Minecraft.func_71410_x().func_147117_R().func_110572_b(ParticleRootSpike.SPRITE.toString()));
                    renderers.add(renderer);
                }
                this.modelParts.put(pos, renderers);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_70070_b() {
        BlockPos.MutableBlockPos pos = new BlockPos.MutableBlockPos(MathHelper.func_76128_c((double)this.field_70165_t), 0, MathHelper.func_76128_c((double)this.field_70161_v));
        if (this.field_70170_p.func_175667_e((BlockPos)pos)) {
            pos.func_185336_p(MathHelper.func_76128_c((double)(this.field_70163_u + (double)this.func_70047_e())) + 1);
            return this.field_70170_p.func_175626_b((BlockPos)pos, 0);
        }
        return 0;
    }

    public void func_70071_h_() {
        this.field_70170_p.field_72984_F.func_76320_a("entityBaseTick");
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70159_w = 0.0;
        this.field_70179_y = 0.0;
        this.field_70142_S = this.field_70165_t;
        this.field_70137_T = this.field_70163_u;
        this.field_70136_U = this.field_70161_v;
        if (this.field_70173_aa >= this.delay) {
            if (this.field_70170_p.field_72995_K && this.field_70173_aa == this.delay) {
                this.spawnEmergeParticles();
                this.field_70170_p.func_184134_a(this.field_70165_t, this.field_70163_u, this.field_70161_v, (SoundEvent)SoundRegistry.SPIRIT_TREE_SPIKES, SoundCategory.HOSTILE, 0.7f, 0.9f + this.field_70146_Z.nextFloat() * 0.2f, false);
            }
            if (this.field_70173_aa == this.delay && this.field_70181_x <= 0.0) {
                this.field_70181_x += 0.25;
            } else {
                this.field_70181_x -= 0.05;
                if (!this.field_70170_p.field_72995_K && (this.field_70163_u <= (double)this.origin.func_177956_o() || this.field_70122_E)) {
                    this.func_70106_y();
                }
            }
        } else {
            this.field_70181_x = 0.0;
        }
        if (this.field_70163_u < -64.0) {
            this.func_70106_y();
        }
        if (this.field_70163_u + this.field_70181_x <= (double)this.origin.func_177956_o()) {
            this.field_70181_x = 0.0;
            this.func_70012_b(this.field_70165_t, this.origin.func_177956_o(), this.field_70161_v, 0.0f, 0.0f);
        } else {
            this.func_70091_d(MoverType.SELF, 0.0, this.field_70181_x, 0.0);
        }
        if (this.field_70181_x > 0.1 && !this.field_70170_p.field_72995_K) {
            EntityDamageSource damageSource = new EntityDamageSource("bl.spikewave", (Entity)this);
            for (BlockPos pos : this.positions) {
                AxisAlignedBB aabb = new AxisAlignedBB(pos).func_72317_d(this.field_70165_t - ((double)this.origin.func_177958_n() + 0.5), this.field_70163_u - (double)this.origin.func_177956_o(), this.field_70161_v - ((double)this.origin.func_177952_p() + 0.5)).func_186664_h(0.1).func_72317_d(0.0, 0.2, 0.0);
                List entities = this.field_70170_p.func_72872_a(EntityLivingBase.class, aabb);
                for (EntityLivingBase entity : entities) {
                    if (!(entity instanceof EntityLivingBase)) continue;
                    entity.func_70097_a((DamageSource)damageSource, this.attackDamage);
                }
            }
        }
        this.renderingBounds = this.blockEnclosingBounds.func_72317_d(this.field_70165_t - ((double)this.origin.func_177958_n() + 0.5), this.field_70163_u - (double)this.origin.func_177956_o(), this.field_70161_v - ((double)this.origin.func_177952_p() + 0.5));
        this.field_70148_d = false;
        this.field_70170_p.field_72984_F.func_76319_b();
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnEmergeParticles() {
        if (!this.positions.isEmpty()) {
            int particles = 8 + this.field_70146_Z.nextInt(8);
            for (int i = 0; i < particles; ++i) {
                BlockPos pos = this.positions.get(this.field_70146_Z.nextInt(this.positions.size()));
                double x = (double)pos.func_177958_n() + this.field_70146_Z.nextDouble();
                double y = pos.func_177956_o() + 1;
                double z = (double)pos.func_177952_p() + this.field_70146_Z.nextDouble();
                double mx = (this.field_70146_Z.nextDouble() - 0.5) * (double)0.8f;
                double my = 0.1 + this.field_70146_Z.nextDouble() * (double)0.4f;
                double mz = (this.field_70146_Z.nextDouble() - 0.5) * (double)0.8f;
                ParticleRootSpike particle = (ParticleRootSpike)BLParticles.ROOT_SPIKE.spawn(this.field_70170_p, x, y, z, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion(mx, my, mz));
                particle.setUseSound(this.field_70146_Z.nextInt(40) == 0);
            }
            for (BlockPos pos : this.positions) {
                IBlockState state = this.field_70170_p.func_180495_p(pos);
                if (state.func_177230_c().isAir(state, (IBlockAccess)this.field_70170_p, pos)) continue;
                int dustParticles = 1 + this.field_70146_Z.nextInt(3);
                for (int i = 0; i < dustParticles; ++i) {
                    double x = (double)pos.func_177958_n() + this.field_70146_Z.nextDouble();
                    double y = pos.func_177956_o() + 1;
                    double z = (double)pos.func_177952_p() + this.field_70146_Z.nextDouble();
                    double mx = (this.field_70146_Z.nextDouble() - 0.5) * (double)0.3f;
                    double my = 0.1 + this.field_70146_Z.nextDouble() * (double)0.2f;
                    double mz = (this.field_70146_Z.nextDouble() - 0.5) * (double)0.3f;
                    this.field_70170_p.func_175688_a(EnumParticleTypes.BLOCK_DUST, x, y, z, mx, my, mz, new int[]{Block.func_176210_f((IBlockState)state)});
                }
            }
        }
    }

    public boolean func_70072_I() {
        return false;
    }

    protected boolean func_70041_e_() {
        return false;
    }

    public boolean func_70104_M() {
        return false;
    }

    public void writeSpawnData(ByteBuf data) {
        data.writeLong(this.origin.func_177986_g());
        data.writeInt(this.positions.size());
        for (BlockPos pos : this.positions) {
            data.writeLong(pos.func_177986_g());
        }
        data.writeInt(this.delay);
    }

    public void readSpawnData(ByteBuf data) {
        this.origin = BlockPos.func_177969_a((long)data.readLong());
        this.blockEnclosingBounds = null;
        this.positions.clear();
        int size = data.readInt();
        for (int i = 0; i < size; ++i) {
            this.addPosition(BlockPos.func_177969_a((long)data.readLong()));
        }
        this.delay = data.readInt();
    }

    public AxisAlignedBB func_184177_bl() {
        return this.renderingBounds;
    }

    protected void func_70037_a(NBTTagCompound nbt) {
        this.delay = nbt.func_74762_e("delay");
        this.origin = BlockPos.func_177969_a((long)nbt.func_74763_f("origin"));
        this.positions.clear();
        NBTTagList blocks = nbt.func_150295_c("positions", 4);
        for (int i = 0; i < blocks.func_74745_c(); ++i) {
            this.addPosition(BlockPos.func_177969_a((long)((NBTTagLong)blocks.func_179238_g(i)).func_150291_c()));
        }
        if (this.positions.isEmpty()) {
            this.addPosition(this.origin);
        }
        this.attackDamage = nbt.func_74760_g("attackDamage");
    }

    protected void func_70014_b(NBTTagCompound nbt) {
        nbt.func_74768_a("delay", this.delay);
        nbt.func_74772_a("origin", this.origin.func_177986_g());
        NBTTagList blocks = new NBTTagList();
        for (BlockPos pos : this.positions) {
            blocks.func_74742_a((NBTBase)new NBTTagLong(pos.func_177986_g()));
        }
        nbt.func_74782_a("positions", (NBTBase)blocks);
        nbt.func_74776_a("attackDamage", this.attackDamage);
    }

    protected void func_70088_a() {
    }
}

