/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.block.SoundType;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.common.block.BasicBlock;
import thebetweenlands.common.block.ITintedBlock;
import thebetweenlands.common.registries.LootTableRegistry;
import thebetweenlands.common.tile.TileEntityLootInventory;
import thebetweenlands.common.tile.TileEntityPresent;

public class BlockPresent
extends BasicBlock
implements ITileEntityProvider,
ITintedBlock {
    public static final PropertyEnum<EnumDyeColor> COLOR = PropertyEnum.func_177709_a((String)"color", EnumDyeColor.class);
    protected static final AxisAlignedBB AABB = new AxisAlignedBB(0.06, 0.0, 0.06, 0.94, 0.82, 0.94);

    public BlockPresent() {
        super(Material.field_151580_n);
        this.func_149711_c(0.8f);
        this.func_149672_a(SoundType.field_185854_g);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(COLOR, (Comparable)EnumDyeColor.RED));
        this.func_149675_a(true);
        this.func_149647_a(null);
    }

    @Nullable
    public static TileEntityPresent getTileEntity(IBlockAccess world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TileEntityPresent) {
            return (TileEntityPresent)tile;
        }
        return null;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return AABB;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public boolean isNormalCube(IBlockState state, IBlockAccess world, BlockPos pos) {
        return false;
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }

    public TileEntity func_149915_a(World worldIn, int meta) {
        return new TileEntityPresent();
    }

    public int func_149745_a(Random random) {
        return 0;
    }

    public void func_180633_a(World worldIn, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        if (!worldIn.field_72995_K) {
            state = state.func_177226_a(COLOR, (Comparable)EnumDyeColor.values()[worldIn.field_73012_v.nextInt(EnumDyeColor.values().length)]);
            worldIn.func_180501_a(pos, state, 3);
            TileEntityPresent tile = BlockPresent.getTileEntity((IBlockAccess)worldIn, pos);
            if (tile != null) {
                tile.setLootTable(LootTableRegistry.PRESENT, worldIn.field_73012_v.nextLong());
                tile.func_70296_d();
            }
        }
    }

    public void func_180657_a(World worldIn, EntityPlayer player, BlockPos pos, IBlockState state, @Nullable TileEntity te, @Nullable ItemStack stack) {
        super.func_180657_a(worldIn, player, pos, state, te, stack);
        IInventory tile = (IInventory)worldIn.func_175625_s(pos);
        if (tile != null) {
            ((TileEntityLootInventory)tile).fillInventoryWithLoot(player);
        }
    }

    public void func_180663_b(World worldIn, BlockPos pos, IBlockState state) {
        IInventory tile = (IInventory)worldIn.func_175625_s(pos);
        if (tile != null) {
            InventoryHelper.func_180175_a((World)worldIn, (BlockPos)pos, (IInventory)tile);
        }
        super.func_180663_b(worldIn, pos, state);
    }

    public MapColor func_180659_g(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return MapColor.func_193558_a((EnumDyeColor)((EnumDyeColor)state.func_177229_b(COLOR)));
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(COLOR, (Comparable)EnumDyeColor.func_176764_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumDyeColor)state.func_177229_b(COLOR)).func_176765_a();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{COLOR});
    }

    @Override
    public int getColorMultiplier(IBlockState state, IBlockAccess worldIn, BlockPos pos, int tintIndex) {
        if (tintIndex == 0) {
            return ((EnumDyeColor)state.func_177229_b(COLOR)).func_193350_e();
        }
        return 0xFFFFFF;
    }

    @SideOnly(value=Side.CLIENT)
    public BlockRenderLayer func_180664_k() {
        return BlockRenderLayer.CUTOUT;
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        if (rand.nextInt(20) == 0 && worldIn.func_184137_a((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), 32.0, false) == null) {
            worldIn.func_175698_g(pos);
        }
    }
}

