/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.common.block.container;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockContainer;
import net.minecraft.block.BlockHorizontal;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyDirection;
import net.minecraft.block.state.BlockFaceShape;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import thebetweenlands.client.render.particle.BLParticles;
import thebetweenlands.client.render.particle.ParticleFactory;
import thebetweenlands.client.tab.BLCreativeTabs;
import thebetweenlands.common.item.tools.ItemBucketInfusion;
import thebetweenlands.common.registries.ItemRegistry;
import thebetweenlands.common.tile.TileEntityAlembic;

public class BlockAlembic
extends BlockContainer {
    public static final PropertyDirection FACING = BlockHorizontal.field_185512_D;

    public BlockAlembic() {
        super(Material.field_151576_e);
        this.func_149711_c(2.0f);
        this.func_149752_b(5.0f);
        this.func_149647_a(BLCreativeTabs.BLOCKS);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.NORTH));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO());
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        world.func_180501_a(pos, state.func_177226_a((IProperty)FACING, (Comparable)placer.func_174811_aO()), 2);
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (!world.field_72995_K && world.func_175625_s(pos) instanceof TileEntityAlembic) {
            TileEntityAlembic tile = (TileEntityAlembic)world.func_175625_s(pos);
            if (player.func_70093_af()) {
                return false;
            }
            if (!player.func_184586_b(hand).func_190926_b()) {
                ItemStack heldStack = player.func_184586_b(hand);
                if (heldStack.func_77973_b() == ItemRegistry.BL_BUCKET_INFUSION) {
                    if (!tile.isFull()) {
                        tile.addInfusion(heldStack);
                        if (!player.field_71075_bZ.field_75098_d) {
                            player.func_184611_a(hand, ItemBucketInfusion.getEmptyBucket(heldStack));
                        }
                    }
                } else if (heldStack.func_77973_b() == ItemRegistry.DENTROTHYST_VIAL && (heldStack.func_77952_i() == 0 || heldStack.func_77952_i() == 2) && tile.hasFinished()) {
                    ItemStack result = tile.getElixir(heldStack.func_77952_i() == 0 ? 0 : 1);
                    EntityItem itemEntity = player.func_71019_a(result, false);
                    if (itemEntity != null) {
                        itemEntity.func_174867_a(0);
                    }
                    if (!player.field_71075_bZ.field_75098_d) {
                        heldStack.func_190918_g(1);
                    }
                }
            }
        }
        return true;
    }

    public void func_180655_c(IBlockState stateIn, World world, BlockPos pos, Random rand) {
        TileEntityAlembic alembic;
        if (world.func_175625_s(pos) instanceof TileEntityAlembic && (alembic = (TileEntityAlembic)world.func_175625_s(pos)).isRunning()) {
            float xx = (float)pos.func_177958_n() + 0.5f;
            float yy = (float)pos.func_177956_o() + 0.25f + rand.nextFloat() * 0.5f;
            float zz = (float)pos.func_177952_p() + 0.5f;
            float fixedOffset = 0.25f;
            float randomOffset = rand.nextFloat() * 0.6f - 0.3f;
            BLParticles.STEAM_PURIFIER.spawn(world, xx - fixedOffset, (double)yy + 0.25, zz + randomOffset);
            BLParticles.STEAM_PURIFIER.spawn(world, xx + fixedOffset, (double)yy + 0.25, zz + randomOffset);
            BLParticles.STEAM_PURIFIER.spawn(world, xx + randomOffset, (double)yy + 0.25, zz - fixedOffset);
            BLParticles.STEAM_PURIFIER.spawn(world, xx + randomOffset, (double)yy + 0.25, zz + fixedOffset);
            EnumFacing facing = (EnumFacing)stateIn.func_177228_b().get((Object)FACING);
            switch (facing) {
                case NORTH: {
                    BLParticles.FLAME.spawn(world, (float)pos.func_177958_n() + 0.65f + (rand.nextFloat() - 0.5f) * 0.1f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.6f + (rand.nextFloat() - 0.5f) * 0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.01f, 0.01f, 0.0));
                    break;
                }
                case SOUTH: {
                    BLParticles.FLAME.spawn(world, (float)pos.func_177958_n() + 0.375f + (rand.nextFloat() - 0.5f) * 0.1f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.375f + (rand.nextFloat() - 0.5f) * 0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.01f, 0.01f, 0.0));
                    break;
                }
                case EAST: {
                    BLParticles.FLAME.spawn(world, (float)pos.func_177958_n() + 0.375f + (rand.nextFloat() - 0.5f) * 0.1f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.6f + (rand.nextFloat() - 0.5f) * 0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.01f, 0.01f, 0.0));
                    break;
                }
                case WEST: {
                    BLParticles.FLAME.spawn(world, (float)pos.func_177958_n() + 0.6f + (rand.nextFloat() - 0.5f) * 0.1f, pos.func_177956_o(), (float)pos.func_177952_p() + 0.375f + (rand.nextFloat() - 0.5f) * 0.1f, (ParticleFactory.ParticleArgs<?>)ParticleFactory.ParticleArgs.get().withMotion((rand.nextFloat() - 0.5f) * 0.01f, 0.01f, 0.0));
                }
            }
        }
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.MODEL;
    }

    public boolean func_149662_c(IBlockState state) {
        return false;
    }

    public TileEntity func_149915_a(World world, int meta) {
        return new TileEntityAlembic();
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{FACING});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)FACING, (Comparable)EnumFacing.func_176731_b((int)meta));
    }

    public int func_176201_c(IBlockState state) {
        return ((EnumFacing)state.func_177229_b((IProperty)FACING)).func_176745_a();
    }

    public BlockFaceShape func_193383_a(IBlockAccess worldIn, IBlockState state, BlockPos pos, EnumFacing face) {
        return BlockFaceShape.UNDEFINED;
    }
}

