/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.RenderItem;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.item.ItemSkull;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import thebetweenlands.client.render.model.tile.ModelItemShelf;
import thebetweenlands.common.block.container.BlockItemShelf;
import thebetweenlands.common.tile.TileEntityItemShelf;
import thebetweenlands.util.StatePropertyHelper;

public class RenderItemShelf
extends TileEntitySpecialRenderer<TileEntityItemShelf> {
    public static final ModelItemShelf MODEL = new ModelItemShelf();
    public static final ResourceLocation TEXTURE = new ResourceLocation("thebetweenlands:textures/tiles/item_shelf.png");
    protected final RenderItem renderItem = Minecraft.func_71410_x().func_175599_af();

    public void render(TileEntityItemShelf te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        double unitPixel = 0.0625;
        double offSetX = 0.0;
        double offSetZ = 0.0;
        double offSetXX = 0.0;
        double offSetZZ = 0.0;
        float rotation = 0.0f;
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_147499_a(TEXTURE);
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179091_B();
        EnumFacing facing = EnumFacing.NORTH;
        boolean isItem = true;
        if (te != null && te.func_145830_o()) {
            isItem = false;
            facing = StatePropertyHelper.getStatePropertySafely(te, BlockItemShelf.class, BlockItemShelf.FACING, EnumFacing.NORTH);
        }
        switch (facing) {
            default: {
                GlStateManager.func_179114_b((float)0.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                rotation = 0.0f;
                offSetX = unitPixel * 3.75;
                offSetZ = unitPixel * 3.75;
                offSetXX = unitPixel * 12.0;
                offSetZZ = unitPixel * 3.75;
                break;
            }
            case SOUTH: {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                rotation = 180.0f;
                offSetX = unitPixel * 12.0;
                offSetZ = unitPixel * 12.0;
                offSetXX = unitPixel * 3.75;
                offSetZZ = unitPixel * 12.0;
                break;
            }
            case EAST: {
                GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                rotation = -90.0f;
                offSetX = unitPixel * 12.0;
                offSetZ = unitPixel * 3.75;
                offSetXX = unitPixel * 12.0;
                offSetZZ = unitPixel * 12.0;
                break;
            }
            case WEST: {
                GlStateManager.func_179114_b((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                rotation = 90.0f;
                offSetX = unitPixel * 3.75;
                offSetZ = unitPixel * 12.0;
                offSetXX = unitPixel * 3.75;
                offSetZZ = unitPixel * 3.75;
            }
        }
        if (isItem) {
            GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.25);
        }
        MODEL.render();
        GlStateManager.func_179121_F();
        GlStateManager.func_179101_C();
        if (te != null) {
            this.renderItemInSlot(te, 0, x + offSetX, y + unitPixel * 11.0, z + offSetZ, rotation);
            this.renderItemInSlot(te, 1, x + offSetXX, y + unitPixel * 11.0, z + offSetZZ, rotation);
            this.renderItemInSlot(te, 2, x + offSetX, y + unitPixel * 3.0, z + offSetZ, rotation);
            this.renderItemInSlot(te, 3, x + offSetXX, y + unitPixel * 3.0, z + offSetZZ, rotation);
        }
    }

    protected void renderItemInSlot(TileEntityItemShelf te, int slot, double x, double y, double z, float rotation) {
        ItemStack stack = te.func_70301_a(slot);
        if (!stack.func_190926_b()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179123_a();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179137_b((double)x, (double)y, (double)z);
            GlStateManager.func_179114_b((float)rotation, (float)0.0f, (float)1.0f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.4f, (float)0.4f, (float)0.4f);
            RenderHelper.func_74519_b();
            if (!this.renderItem.func_175050_a(stack) || stack.func_77973_b() instanceof ItemSkull) {
                GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
            }
            this.renderItem.func_181564_a(stack, ItemCameraTransforms.TransformType.FIXED);
            RenderHelper.func_74518_a();
            GlStateManager.func_179099_b();
            GlStateManager.func_179121_F();
        }
    }
}

