/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.tile;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import thebetweenlands.client.render.model.tile.ModelAlembic;
import thebetweenlands.common.block.container.BlockAspectVial;
import thebetweenlands.common.block.terrain.BlockDentrothyst;
import thebetweenlands.common.tile.TileEntityAspectVial;
import thebetweenlands.util.ColorUtils;
import thebetweenlands.util.LightingUtil;
import thebetweenlands.util.StatePropertyHelper;

@SideOnly(value=Side.CLIENT)
public class RenderAspectVial
extends TileEntitySpecialRenderer<TileEntityAspectVial> {
    private static final ModelAlembic MODEL = new ModelAlembic();
    public static final ResourceLocation TEXTURE1 = new ResourceLocation("thebetweenlands:textures/tiles/vial_block_green.png");
    public static final ResourceLocation TEXTURE2 = new ResourceLocation("thebetweenlands:textures/tiles/vial_block_orange.png");

    public void render(TileEntityAspectVial te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        BlockDentrothyst.EnumDentrothyst type = StatePropertyHelper.getStatePropertySafely(te, BlockAspectVial.class, BlockAspectVial.TYPE, BlockDentrothyst.EnumDentrothyst.GREEN);
        switch (type) {
            default: {
                this.func_147499_a(TEXTURE1);
                break;
            }
            case ORANGE: {
                this.func_147499_a(TEXTURE2);
            }
        }
        float randX = 0.0f;
        float randZ = 0.0f;
        if (StatePropertyHelper.getStatePropertySafely(te, BlockAspectVial.class, BlockAspectVial.RANDOM_POSITION, true).booleanValue()) {
            long posRand = (long)(te.func_174877_v().func_177956_o() * 224856) ^ (long)(te.func_174877_v().func_177958_n() * 3129871) ^ (long)te.func_174877_v().func_177952_p() * 116129781L;
            posRand = posRand * posRand * 42317861L + posRand * 11L;
            randX = ((float)(posRand >> 16 & 0xFL) / 15.0f - 0.5f) * 0.45f;
            randZ = ((float)(posRand >> 24 & 0xFL) / 15.0f - 0.5f) * 0.45f;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179109_b((float)((float)x + 0.5f), (float)((float)y + 1.5f), (float)((float)z + 0.5f));
        GlStateManager.func_179152_a((float)1.0f, (float)-1.0f, (float)-1.0f);
        GlStateManager.func_179109_b((float)(-0.3f + randX), (float)-0.001f, (float)(0.25f + randZ));
        GlStateManager.func_179132_a((boolean)false);
        RenderAspectVial.MODEL.davids_jar.func_78785_a(0.0625f);
        GlStateManager.func_179132_a((boolean)true);
        if (te.getAspect() != null) {
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            GlStateManager.func_179090_x();
            float[] aspectRGBA = ColorUtils.getRGBA(te.getAspect().type.getColor());
            GlStateManager.func_179131_c((float)aspectRGBA[0], (float)aspectRGBA[1], (float)aspectRGBA[2], (float)0.98f);
            float filled = (float)te.getAspect().amount / 5000.0f;
            if (filled != 0.0f) {
                LightingUtil.INSTANCE.setLighting(255);
                GlStateManager.func_179108_z();
                GlStateManager.func_179094_E();
                GlStateManager.func_179109_b((float)0.0f, (float)(-1.46875f * filled + 1.46875f), (float)0.0f);
                GlStateManager.func_179152_a((float)1.0f, (float)filled, (float)1.0f);
                RenderAspectVial.MODEL.jar_liquid.func_78785_a(0.0625f);
                GlStateManager.func_179121_F();
                GlStateManager.func_179133_A();
                LightingUtil.INSTANCE.revert();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        }
        GlStateManager.func_179135_a((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        RenderAspectVial.MODEL.davids_jar.func_78785_a(0.0625f);
        GlStateManager.func_179135_a((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.FRONT);
        RenderAspectVial.MODEL.davids_jar.func_78785_a(0.0625f);
        GlStateManager.func_187407_a((GlStateManager.CullFace)GlStateManager.CullFace.BACK);
        GlStateManager.func_179121_F();
    }
}

