/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.client.render.model.loader.extension;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import thebetweenlands.client.render.model.loader.extension.LoaderExtension;

public class ModelProcessorLoaderExtension
extends LoaderExtension {
    @Override
    public String getName() {
        return "process_model";
    }

    @Override
    public IModel loadModel(IModel original, ResourceLocation location, String arg) {
        ImmutableMap<String, String> dataMap;
        IModel processedModel = original;
        JsonParser parser = new JsonParser();
        String metadata = this.readMetadata(arg);
        JsonObject json = JsonUtils.func_151210_l((JsonElement)parser.parse(metadata), (String)(location.toString() + " model metadata"));
        if (json.has("custom")) {
            if (original == null) {
                this.throwLoaderException("Specified model " + location + " does not support custom data");
            }
            dataMap = ModelProcessorLoaderExtension.parseJsonElementList(JsonUtils.func_151210_l((JsonElement)json.get("custom"), (String)"custom"));
            processedModel = processedModel.process(dataMap);
        }
        if (json.has("smooth_lighting")) {
            if (original == null) {
                this.throwLoaderException("Specified model " + location + " does not support smooth lighting");
            }
            processedModel = processedModel.smoothLighting(JsonUtils.func_151216_b((JsonElement)json.get("smooth_lighting"), (String)"smooth_lighting"));
        }
        if (json.has("gui3d")) {
            if (original == null) {
                this.throwLoaderException("Specified model " + location + " does not support gui3d");
            }
            processedModel = processedModel.gui3d(JsonUtils.func_151216_b((JsonElement)json.get("gui3d"), (String)"gui3d"));
        }
        if (json.has("uvlock")) {
            if (original == null) {
                this.throwLoaderException("Specified model " + location + " does not support uvlock");
            }
            processedModel = processedModel.uvlock(JsonUtils.func_151216_b((JsonElement)json.get("uvlock"), (String)"uvlock"));
        }
        if (json.has("textures")) {
            if (original == null) {
                this.throwLoaderException("Specified model " + location + " does not support retexturing");
            }
            dataMap = ModelProcessorLoaderExtension.parseJsonElementList(JsonUtils.func_151210_l((JsonElement)json.get("textures"), (String)"textures"));
            processedModel = processedModel.retexture(dataMap);
        }
        return processedModel;
    }
}

