/*
 * Decompiled with CFR 0.152.
 */
package thebetweenlands.api.misc;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import thebetweenlands.api.event.UpdateFogEvent;
import thebetweenlands.api.misc.Fog;
import thebetweenlands.common.world.biome.BiomeBetweenlands;

public class FogState {
    private Fog targetFog;
    private Fog prevTickFog;
    private Fog currentTickFog;

    public void setTargetFog(@Nullable Fog fog) {
        this.targetFog = fog;
    }

    @Nonnull
    public Fog getTargetFog() {
        return this.targetFog;
    }

    public void setFog(@Nonnull Fog fog) {
        this.prevTickFog = this.currentTickFog = fog;
    }

    @Nonnull
    public Fog getFog(float partialTicks) {
        if (this.prevTickFog == null || this.currentTickFog == null) {
            return new Fog(Fog.FogType.LINEAR, 1.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
        }
        if (partialTicks == 0.0f) {
            return this.prevTickFog;
        }
        if (partialTicks == 1.0f) {
            return this.currentTickFog;
        }
        Fog.FogType type = this.currentTickFog.getFogType();
        float density = this.prevTickFog.getDensity() + (this.currentTickFog.getDensity() - this.prevTickFog.getDensity()) * partialTicks;
        float colorIncrement = this.prevTickFog.getColorIncrement() + (this.currentTickFog.getColorIncrement() - this.prevTickFog.getColorIncrement()) * partialTicks;
        float distanceIncrement = this.prevTickFog.getDistanceIncrementMultiplier() + (this.currentTickFog.getDistanceIncrementMultiplier() - this.prevTickFog.getDistanceIncrementMultiplier()) * partialTicks;
        float densityIncrement = this.prevTickFog.getDensityIncrement() + (this.currentTickFog.getDensityIncrement() - this.prevTickFog.getDensityIncrement()) * partialTicks;
        float red = this.prevTickFog.getRed() + (this.currentTickFog.getRed() - this.prevTickFog.getRed()) * partialTicks;
        float green = this.prevTickFog.getGreen() + (this.currentTickFog.getGreen() - this.prevTickFog.getGreen()) * partialTicks;
        float blue = this.prevTickFog.getBlue() + (this.currentTickFog.getBlue() - this.prevTickFog.getBlue()) * partialTicks;
        float colorMultiplier = this.prevTickFog.getColorMultiplier() + (this.currentTickFog.getColorMultiplier() - this.prevTickFog.getColorMultiplier()) * partialTicks;
        float start = this.prevTickFog.getStart() + (this.currentTickFog.getStart() - this.prevTickFog.getStart()) * partialTicks;
        float end = this.prevTickFog.getEnd() + (this.currentTickFog.getEnd() - this.prevTickFog.getEnd()) * partialTicks;
        return new Fog(type, density, red, green, blue, colorMultiplier, start, end, colorIncrement, distanceIncrement, densityIncrement);
    }

    @Nonnull
    public Fog getFog() {
        return this.getFog(1.0f);
    }

    public Fog getBiomeFog(World world, Vec3d position, float farPlaneDistance, int mode) {
        Fog.MutableFog defaultBiomeFog = new Fog.MutableFog().setType(Fog.FogType.LINEAR).setDensity(0.0f).setColorIncrement(0.001f).setDistanceIncrementMultiplier(1.0f).setRed(0.5f).setGreen(0.5f).setBlue(0.5f).setStart(farPlaneDistance).setEnd(farPlaneDistance).setColorMultiplier(1.0f);
        Biome biome = world.func_180494_b(new BlockPos(position));
        if (biome instanceof BiomeBetweenlands) {
            BiomeBetweenlands biomeBl = (BiomeBetweenlands)biome;
            int[] fogColor = biomeBl.getFogRGB();
            defaultBiomeFog.setRed((float)fogColor[0] / 255.0f).setGreen((float)fogColor[1] / 255.0f).setBlue((float)fogColor[2] / 255.0f);
            defaultBiomeFog.setStart(biomeBl.getFogStart(farPlaneDistance, mode)).setEnd(biomeBl.getFogEnd(farPlaneDistance, mode));
        }
        return defaultBiomeFog.toImmutable();
    }

    public float getFixedFogStart(float start) {
        return Math.min(144.0f, start);
    }

    public float getFixedFogEnd(float end) {
        return Math.min(192.0f, end);
    }

    public float getLowDistanceFogReduction(float end) {
        return end > 128.0f ? 0.0f : 1.0f - end / 128.0f;
    }

    public Fog getAmbientFog(Fog biomeFog, World world, Vec3d position) {
        Fog.MutableFog defaultAmbientFog = new Fog.MutableFog(biomeFog);
        float lowViewDistanceFogReduction = this.getLowDistanceFogReduction(defaultAmbientFog.getEnd());
        float fixedFogStart = this.getFixedFogStart(defaultAmbientFog.getStart());
        float fixedFogEnd = this.getFixedFogEnd(defaultAmbientFog.getEnd());
        if (position.field_72448_b < 110.0) {
            float targettedMultiplier;
            float fogColorMultiplier = (float)(110.0 - position.field_72448_b) / 110.0f;
            fogColorMultiplier = 1.0f - fogColorMultiplier;
            fogColorMultiplier = (float)((double)fogColorMultiplier * Math.pow(fogColorMultiplier, 8.5));
            fogColorMultiplier = fogColorMultiplier * 0.95f + 0.05f;
            if (position.field_72448_b <= 45.0 && fogColorMultiplier < (targettedMultiplier = 0.3f)) {
                fogColorMultiplier = (float)((double)fogColorMultiplier + Math.pow((double)((targettedMultiplier - fogColorMultiplier) / 45.0f) * (45.0 - position.field_72448_b), 0.85f));
            }
            fogColorMultiplier = MathHelper.func_76131_a((float)fogColorMultiplier, (float)0.1f, (float)1.0f);
            fogColorMultiplier = Math.min(fogColorMultiplier, 1.0f);
            fogColorMultiplier += (1.0f - fogColorMultiplier) * (float)Math.pow(lowViewDistanceFogReduction, 2.25);
            defaultAmbientFog.setStart(fixedFogStart * fogColorMultiplier);
            defaultAmbientFog.setEnd(fixedFogEnd * fogColorMultiplier);
            defaultAmbientFog.setColorMultiplier(fogColorMultiplier);
            defaultAmbientFog.setDistanceIncrementMultiplier(2.0f);
        }
        return defaultAmbientFog.toImmutable();
    }

    public Fog getAmbientFog(World world, Vec3d position, float farPlaneDistance, int mode) {
        return this.getAmbientFog(this.getBiomeFog(world, position, farPlaneDistance, mode), world, position);
    }

    public void update(World world, Vec3d position, float farPlaneDistance, int mode) {
        float targetFogDensity;
        Fog defaultBiomeFog = this.getBiomeFog(world, position, farPlaneDistance, mode);
        Fog defaultAmbientFog = this.getAmbientFog(defaultBiomeFog, world, position);
        MinecraftForge.EVENT_BUS.post((Event)new UpdateFogEvent(this, defaultBiomeFog, defaultAmbientFog, position, world, farPlaneDistance));
        if (this.currentTickFog == null) {
            this.currentTickFog = defaultAmbientFog;
        }
        this.prevTickFog = this.currentTickFog;
        Fog target = this.targetFog;
        if (target == null) {
            target = defaultAmbientFog;
        }
        float[] fogPositions = new float[]{this.currentTickFog.getStart(), target.getStart(), this.currentTickFog.getEnd(), target.getEnd()};
        for (int i = 0; i < 2; ++i) {
            float fogPosition = fogPositions[i * 2];
            float fogTargetPosition = fogPositions[i * 2 + 1];
            float fogPositionDiff = Math.abs(fogPosition - fogTargetPosition);
            float fogPositionIncr = fogPositionDiff / farPlaneDistance / 2.0f * target.getDistanceIncrementMultiplier();
            if (fogPosition > fogTargetPosition) {
                if (fogPosition - fogTargetPosition > fogPositionIncr) {
                    int n = i * 2;
                    fogPositions[n] = fogPositions[n] - fogPositionIncr;
                    continue;
                }
                fogPositions[i * 2] = fogTargetPosition;
                continue;
            }
            if (!(fogPosition < fogTargetPosition)) continue;
            if (fogTargetPosition - fogPosition > fogPositionIncr) {
                int n = i * 2;
                fogPositions[n] = fogPositions[n] + fogPositionIncr;
                continue;
            }
            fogPositions[i * 2] = fogTargetPosition;
        }
        float[] currentFogColor = new float[]{this.currentTickFog.getRed(), this.currentTickFog.getGreen(), this.currentTickFog.getBlue()};
        float[] targetFogColor = new float[]{target.getRed() * target.getColorMultiplier(), target.getGreen() * target.getColorMultiplier(), target.getBlue() * target.getColorMultiplier()};
        for (int a = 0; a < 3; ++a) {
            if (currentFogColor[a] == targetFogColor[a]) continue;
            if (currentFogColor[a] < targetFogColor[a]) {
                int n = a;
                currentFogColor[n] = currentFogColor[n] + target.getColorIncrement();
                if (!(currentFogColor[a] > targetFogColor[a])) continue;
                currentFogColor[a] = targetFogColor[a];
                continue;
            }
            if (!(currentFogColor[a] > targetFogColor[a])) continue;
            int n = a;
            currentFogColor[n] = currentFogColor[n] - target.getColorIncrement();
            if (!(currentFogColor[a] < targetFogColor[a])) continue;
            currentFogColor[a] = targetFogColor[a];
        }
        float currentFogDensity = this.currentTickFog.getDensity();
        if (currentFogDensity != (targetFogDensity = target.getDensity())) {
            if (currentFogDensity < targetFogDensity) {
                if ((currentFogDensity += target.getDensityIncrement()) > targetFogDensity) {
                    currentFogDensity = targetFogDensity;
                }
            } else if (currentFogDensity > targetFogDensity && (currentFogDensity -= target.getDensityIncrement()) < targetFogDensity) {
                currentFogDensity = targetFogDensity;
            }
        }
        this.currentTickFog = new Fog(target.getFogType(), currentFogDensity, currentFogColor[0], currentFogColor[1], currentFogColor[2], 1.0f, fogPositions[0], fogPositions[2], target.getColorIncrement(), target.getDistanceIncrementMultiplier(), target.getDensityIncrement());
    }
}

