/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lostsouls.data;

import java.util.Random;
import mcjty.lostcities.varia.ChunkCoord;
import net.minecraft.nbt.NBTTagCompound;

public class LostChunkData {
    private boolean haunted;
    private int totalMobs;
    private int numberKilled = 0;
    private int enteredCount = 0;

    public LostChunkData(ChunkCoord cc) {
    }

    public void initialize(ChunkCoord cc, float hauntedChance, int minMobs, int maxMobs) {
        Random random = new Random((long)cc.getDimension() * 899812591L + (long)cc.getChunkX() * 916023653L + (long)cc.getChunkZ() * 797003437L);
        random.nextFloat();
        random.nextFloat();
        this.haunted = random.nextFloat() < hauntedChance;
        this.totalMobs = random.nextInt(maxMobs - minMobs + 1) + minMobs;
    }

    public boolean isHaunted() {
        return this.haunted;
    }

    public int getTotalMobs() {
        return this.totalMobs;
    }

    public int getNumberKilled() {
        return this.numberKilled;
    }

    public void setNumberKilled(int numberKilled) {
        this.numberKilled = numberKilled;
    }

    public int getEnteredCount() {
        return this.enteredCount;
    }

    public void newKill() {
        ++this.numberKilled;
    }

    public void enterBuilding() {
        ++this.enteredCount;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.haunted = nbt.func_74767_n("haunted");
        this.totalMobs = nbt.func_74762_e("max");
        this.numberKilled = nbt.func_74762_e("killed");
        this.enteredCount = nbt.func_74762_e("enteredCount");
    }

    public void writeToNBT(NBTTagCompound compound) {
        compound.func_74757_a("haunted", this.haunted);
        compound.func_74768_a("max", this.totalMobs);
        compound.func_74768_a("killed", this.numberKilled);
        compound.func_74768_a("enteredCount", this.enteredCount);
    }
}

