/*
 * Decompiled with CFR 0.152.
 */
package net.bdew.lib.recipes;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import net.bdew.lib.BdLib$;
import net.bdew.lib.Misc$;
import net.bdew.lib.recipes.RecipeLoader;
import net.bdew.lib.recipes.RecipesHelper$;
import net.minecraftforge.fml.common.FMLCommonHandler;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Serializable;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.math.Ordering;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

public final class RecipesHelper$ {
    public static final RecipesHelper$ MODULE$;

    static {
        new RecipesHelper$();
    }

    public void loadConfigs(String modName, String listResource, File configDir, String resBaseName, RecipeLoader loader) {
        BdLib$.MODULE$.logInfo("Loading internal config files for mod %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modName}));
        List internals = (List)Misc$.MODULE$.withAutoClose(new BufferedReader(new InputStreamReader(this.getClass().getResourceAsStream(listResource))), new Serializable(){

            public final List<String> apply(BufferedReader listReader) {
                return package$.MODULE$.Iterator().continually((Function0)new Serializable(this, listReader){
                    private final BufferedReader listReader$1;

                    public final String apply() {
                        return this.listReader$1.readLine();
                    }
                    {
                        this.listReader$1 = listReader$1;
                    }
                }).takeWhile((Function1)new Serializable(this){

                    public final boolean apply(String x$1) {
                        return x$1 != null;
                    }
                }).map((Function1)new Serializable(this){

                    public final String apply(String x$2) {
                        return x$2.trim();
                    }
                }).filterNot((Function1)new Serializable(this){

                    public final boolean apply(String x$3) {
                        return x$3.startsWith("#");
                    }
                }).filterNot((Function1)new Serializable(this){

                    public final boolean apply(String x$4) {
                        return x$4.isEmpty();
                    }
                }).toList();
            }
        });
        File overrideDir = new File(configDir, "overrides");
        Object object = overrideDir.exists() ? BoxedUnit.UNIT : BoxesRunTime.boxToBoolean((boolean)overrideDir.mkdir());
        internals.foreach((Function1)new Serializable(modName, resBaseName, loader, overrideDir){
            public final String modName$1;
            private final String resBaseName$1;
            public final RecipeLoader loader$1;
            private final File overrideDir$1;

            public final void apply(String fileName) {
                File overrideFile = new File(this.overrideDir$1, fileName);
                if (overrideFile.exists()) {
                    RecipesHelper$.MODULE$.tryLoadConfig(new FileReader(overrideFile), overrideFile.getCanonicalPath(), this.modName$1, this.loader$1);
                } else {
                    URL url = RecipesHelper$.MODULE$.getClass().getResource(new StringBuilder().append((Object)this.resBaseName$1).append((Object)fileName).toString());
                    Misc$.MODULE$.withAutoClose(url.openStream(), new Serializable(this, url){
                        private final /* synthetic */ anonfun.loadConfigs.1 $outer;
                        private final URL url$1;

                        public final void apply(InputStream stream) {
                            RecipesHelper$.MODULE$.tryLoadConfig(new InputStreamReader(stream), this.url$1.toString(), this.$outer.modName$1, this.$outer.loader$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                            this.url$1 = url$1;
                        }
                    });
                }
            }
            {
                this.modName$1 = modName$1;
                this.resBaseName$1 = resBaseName$1;
                this.loader$1 = loader$1;
                this.overrideDir$1 = overrideDir$1;
            }
        });
        BdLib$.MODULE$.logInfo("Loading user config files for mod %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modName}));
        Predef$.MODULE$.refArrayOps((Object[])Predef$.MODULE$.refArrayOps((Object[])configDir.list()).sorted((Ordering)Ordering.String$.MODULE$)).withFilter((Function1)new Serializable(){

            public final boolean apply(String fileName) {
                return fileName.endsWith(".cfg");
            }
        }).foreach((Function1)new Serializable(modName, configDir, loader){
            private final String modName$1;
            private final File configDir$1;
            private final RecipeLoader loader$1;

            public final void apply(String fileName) {
                File file = new File(this.configDir$1, fileName);
                if (file.canRead()) {
                    RecipesHelper$.MODULE$.tryLoadConfig(new FileReader(file), file.getCanonicalPath(), this.modName$1, this.loader$1);
                }
            }
            {
                this.modName$1 = modName$1;
                this.configDir$1 = configDir$1;
                this.loader$1 = loader$1;
            }
        });
        BdLib$.MODULE$.logInfo("Config loading for mod %s finished", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modName}));
    }

    public void tryLoadConfig(Reader reader, String path, String modName, RecipeLoader loader) {
        BdLib$.MODULE$.logInfo("Loading config: %s", (Seq<Object>)Predef$.MODULE$.genericWrapArray((Object)new Object[]{path}));
        try {
            try {
                loader.load(reader);
            }
            catch (Throwable throwable) {
                FMLCommonHandler.instance().raiseException(throwable, new StringOps(Predef$.MODULE$.augmentString("%s config loading failed in file %s: %s")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{modName, path, throwable.getMessage()})), true);
            }
        }
        finally {
            reader.close();
        }
    }

    private RecipesHelper$() {
        MODULE$ = this;
    }
}

