/*
 * Decompiled with CFR 0.152.
 */
package com.therandomlabs.randompatches.util;

import com.therandomlabs.randompatches.RandomPatches;
import com.therandomlabs.randompatches.config.RPConfig;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Util;
import org.apache.commons.io.IOUtils;
import org.lwjgl.opengl.Display;

public class WindowIconHandler {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setWindowIcon() {
        Util.EnumOS os = Util.func_110647_a();
        if (os != Util.EnumOS.OSX) {
            InputStream stream32;
            InputStream stream16;
            block8: {
                stream16 = null;
                stream32 = null;
                try {
                    if (RPConfig.Window.icon16.isEmpty()) {
                        Minecraft mc = Minecraft.func_71410_x();
                        stream16 = mc.field_110450_ap.func_152780_c(new ResourceLocation("icons/icon_16x16.png"));
                        stream32 = mc.field_110450_ap.func_152780_c(new ResourceLocation("icons/icon_32x32.png"));
                    } else {
                        stream16 = new FileInputStream(RPConfig.Window.icon16);
                        stream32 = new FileInputStream(RPConfig.Window.icon32);
                    }
                    if (stream16 == null || stream32 == null) break block8;
                    Display.setIcon((ByteBuffer[])new ByteBuffer[]{WindowIconHandler.readImageToBuffer(stream16, 16), WindowIconHandler.readImageToBuffer(stream32, 32)});
                }
                catch (IOException ex) {
                    block9: {
                        try {
                            if (!RandomPatches.IS_DEOBFUSCATED || !(ex instanceof FileNotFoundException) || !RPConfig.Window.DEFAULT_ICON.equals(RPConfig.Window.icon16) || !RPConfig.Window.DEFAULT_ICON.equals(RPConfig.Window.icon32)) break block9;
                        }
                        catch (Throwable throwable) {
                            IOUtils.closeQuietly(stream16);
                            IOUtils.closeQuietly(stream32);
                            throw throwable;
                        }
                        IOUtils.closeQuietly((InputStream)stream16);
                        IOUtils.closeQuietly((InputStream)stream32);
                        return;
                    }
                    RandomPatches.LOGGER.error("Failed to set icon", (Throwable)ex);
                    IOUtils.closeQuietly((InputStream)stream16);
                    IOUtils.closeQuietly((InputStream)stream32);
                }
            }
            IOUtils.closeQuietly((InputStream)stream16);
            IOUtils.closeQuietly((InputStream)stream32);
        }
    }

    private static ByteBuffer readImageToBuffer(InputStream stream, int dimensions) throws IOException {
        BufferedImage image = ImageIO.read(stream);
        if (image.getWidth() != dimensions || image.getHeight() != dimensions) {
            GraphicsEnvironment environment = GraphicsEnvironment.getLocalGraphicsEnvironment();
            GraphicsDevice device = environment.getDefaultScreenDevice();
            GraphicsConfiguration gc = device.getDefaultConfiguration();
            BufferedImage resized = gc.createCompatibleImage(dimensions, dimensions, image.getTransparency());
            Graphics2D graphics = resized.createGraphics();
            graphics.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BILINEAR);
            graphics.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
            graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics.drawImage(image, 0, 0, dimensions, dimensions, null);
            graphics.dispose();
            image = resized;
        }
        int[] aint = image.getRGB(0, 0, dimensions, dimensions, null, 0, dimensions);
        ByteBuffer buffer = ByteBuffer.allocate(aint.length * 4);
        for (int i : aint) {
            buffer.putInt(i << 8 | i >> 24 & 0xFF);
        }
        buffer.flip();
        return buffer;
    }
}

