/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.impl;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import stanhebben.zenscript.IZenCompileEnvironment;
import stanhebben.zenscript.IZenErrorLogger;
import stanhebben.zenscript.IZenLogger;
import stanhebben.zenscript.IZenRegistry;
import stanhebben.zenscript.TypeExpansion;
import stanhebben.zenscript.annotations.ZenExpansion;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.compiler.TypeRegistry;
import stanhebben.zenscript.impl.BracketHandler;
import stanhebben.zenscript.impl.GenericGlobalEnvironment;
import stanhebben.zenscript.impl.GenericLogger;
import stanhebben.zenscript.impl.IBracketHandler;
import stanhebben.zenscript.parser.Token;
import stanhebben.zenscript.symbols.IZenSymbol;
import stanhebben.zenscript.symbols.SymbolJavaStaticField;
import stanhebben.zenscript.symbols.SymbolJavaStaticMethod;
import stanhebben.zenscript.symbols.SymbolPackage;
import stanhebben.zenscript.symbols.SymbolType;
import stanhebben.zenscript.type.ZenTypeNative;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.type.natives.JavaMethod;
import stanhebben.zenscript.util.Pair;

public class GenericRegistry
implements IZenRegistry {
    private IZenCompileEnvironment compileEnvironment;
    private Map<String, IZenSymbol> globals = new HashMap<String, IZenSymbol>();
    private Set<Pair<Integer, IBracketHandler>> bracketHandlers = new TreeSet<Pair>(Comparator.comparingInt(Pair::getKey).thenComparing(o -> ((IBracketHandler)o.getValue()).getClass().getName()));
    private TypeRegistry types = new TypeRegistry();
    private SymbolPackage root = new SymbolPackage("<root>");
    private Map<String, TypeExpansion> expansions = new HashMap<String, TypeExpansion>();
    private IZenErrorLogger errorLogger;
    private IZenLogger logger = new GenericLogger();

    public GenericRegistry(IZenCompileEnvironment compileEnvironment, IZenErrorLogger errorLogger) {
        this.compileEnvironment = compileEnvironment;
        this.errorLogger = errorLogger;
        this.compileEnvironment.setRegistry(this);
    }

    @Override
    public void registerGlobal(String name, IZenSymbol symbol) {
        if (this.globals.containsKey(name)) {
            throw new IllegalArgumentException("symbol already exists: " + name);
        }
        this.globals.put(name, symbol);
    }

    @Override
    public void registerExpansion(Class<?> cls) {
        try {
            for (Annotation annotation : cls.getAnnotations()) {
                if (!(annotation instanceof ZenExpansion)) continue;
                ZenExpansion eAnnotation = (ZenExpansion)annotation;
                if (!this.expansions.containsKey(eAnnotation.value())) {
                    this.expansions.put(eAnnotation.value(), new TypeExpansion(eAnnotation.value()));
                }
                this.expansions.get(eAnnotation.value()).expand(cls, this.types);
            }
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public void registerBracketHandler(IBracketHandler handler) {
        int prio = 10;
        if (handler.getClass().getAnnotation(BracketHandler.class) != null) {
            prio = handler.getClass().getAnnotation(BracketHandler.class).priority();
        } else {
            this.getLogger().info(handler.getClass().getName() + " is missing a BracketHandler annotation, setting the priority to " + prio);
        }
        this.bracketHandlers.add(new Pair<Integer, IBracketHandler>(prio, handler));
    }

    @Override
    public void removeBracketHandler(IBracketHandler handler) {
        Pair<Integer, IBracketHandler> prioPair = null;
        for (Pair<Integer, IBracketHandler> pair : this.bracketHandlers) {
            if (!pair.getValue().equals(handler)) continue;
            prioPair = pair;
        }
        this.bracketHandlers.remove(prioPair);
    }

    @Override
    public void registerNativeClass(Class<?> cls) {
        try {
            ZenTypeNative type = new ZenTypeNative(cls);
            type.complete(this.types);
            this.root.put(type.getName(), new SymbolType(type), this.errorLogger);
        }
        catch (Throwable ex) {
            ex.printStackTrace();
        }
    }

    @Override
    public IZenSymbol getStaticFunction(Class cls, String name, Class ... arguments) {
        IJavaMethod method = JavaMethod.get(this.types, cls, name, arguments);
        return new SymbolJavaStaticMethod(method);
    }

    @Override
    public IZenSymbol getStaticField(Class cls, String name) {
        try {
            Field field = cls.getDeclaredField(name);
            return new SymbolJavaStaticField(cls, field, this.types);
        }
        catch (NoSuchFieldException | SecurityException ex) {
            this.getLogger().error("Unable to get static field: " + name + " from class " + cls.getName(), ex);
            return null;
        }
    }

    @Override
    public IZenSymbol resolveBracket(IEnvironmentGlobal environment, List<Token> tokens) {
        for (Pair<Integer, IBracketHandler> pair : this.bracketHandlers) {
            IZenSymbol symbol = pair.getValue().resolve(environment, tokens);
            if (symbol == null) continue;
            return symbol;
        }
        return null;
    }

    @Override
    public IEnvironmentGlobal makeGlobalEnvironment(Map<String, byte[]> classes) {
        return new GenericGlobalEnvironment(classes, this);
    }

    @Override
    public IZenCompileEnvironment getCompileEnvironment() {
        return this.compileEnvironment;
    }

    @Override
    public Map<String, IZenSymbol> getGlobals() {
        return this.globals;
    }

    @Override
    public Set<Pair<Integer, IBracketHandler>> getBracketHandlers() {
        return this.bracketHandlers;
    }

    @Override
    public TypeRegistry getTypes() {
        return this.types;
    }

    @Override
    public SymbolPackage getRoot() {
        return this.root;
    }

    @Override
    public Map<String, TypeExpansion> getExpansions() {
        return this.expansions;
    }

    @Override
    public void setCompileEnvironment(IZenCompileEnvironment compileEnvironment) {
        this.compileEnvironment = compileEnvironment;
    }

    @Override
    public void setGlobals(Map<String, IZenSymbol> globals) {
        this.globals = globals;
    }

    @Override
    public void setBracketHandlers(Set<Pair<Integer, IBracketHandler>> bracketHandlers) {
        this.bracketHandlers = bracketHandlers;
    }

    @Override
    public void setTypes(TypeRegistry types) {
        this.types = types;
    }

    @Override
    public void setRoot(SymbolPackage root) {
        this.root = root;
    }

    @Override
    public void setExpansions(Map<String, TypeExpansion> expansions) {
        this.expansions = expansions;
    }

    @Override
    public IZenErrorLogger getErrorLogger() {
        return this.errorLogger;
    }

    @Override
    public void setErrorLogger(IZenErrorLogger errorLogger) {
        this.errorLogger = errorLogger;
    }

    @Override
    public IZenLogger getLogger() {
        return this.logger;
    }

    @Override
    public void setLogger(IZenLogger logger) {
        this.logger = logger;
    }
}

