/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.wireless.handling;

import java.util.List;
import sonar.core.listener.ISonarListener;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.wireless.EnumWirelessConnectionType;
import sonar.logistics.api.core.tiles.wireless.emitters.IDataEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IDataReceiver;
import sonar.logistics.base.events.LogisticsEventHandler;
import sonar.logistics.base.events.NetworkChanges;
import sonar.logistics.base.events.types.NetworkEvent;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;
import sonar.logistics.core.tiles.wireless.handling.AbstractWirelessManager;

public class WirelessDataManager
extends AbstractWirelessManager<ILogisticsNetwork, IDataEmitter, IDataReceiver> {
    public static WirelessDataManager instance() {
        return PL2.proxy.wirelessDataManager;
    }

    @Override
    public EnumWirelessConnectionType type() {
        return EnumWirelessConnectionType.DATA;
    }

    public void connectNetworks(ILogisticsNetwork watcher, ILogisticsNetwork connected) {
        watcher.getListenerList().addListener((ISonarListener)connected, new int[]{0});
        connected.getListenerList().addListener((ISonarListener)watcher, new int[]{1});
        LogisticsEventHandler.instance().queueNetworkChange(watcher, NetworkChanges.LOCAL_CHANNELS, NetworkChanges.LOCAL_PROVIDERS);
        LogisticsEventHandler.instance().queueNetworkChange(connected, NetworkChanges.LOCAL_CHANNELS, NetworkChanges.LOCAL_PROVIDERS);
        LogisticsEventHandler.instance().UPDATING.scheduleEvent(new NetworkEvent.ConnectedNetwork(watcher, connected), 0);
    }

    public void disconnectNetworks(ILogisticsNetwork watcher, ILogisticsNetwork connected) {
        watcher.getListenerList().removeListener((ISonarListener)connected, true, new int[]{0});
        connected.getListenerList().removeListener((ISonarListener)watcher, true, new int[]{1});
        LogisticsEventHandler.instance().queueNetworkChange(watcher, NetworkChanges.LOCAL_CHANNELS, NetworkChanges.LOCAL_PROVIDERS);
        LogisticsEventHandler.instance().queueNetworkChange(connected, NetworkChanges.LOCAL_CHANNELS, NetworkChanges.LOCAL_PROVIDERS);
        LogisticsEventHandler.instance().UPDATING.scheduleEvent(new NetworkEvent.DisconnectedNetwork(watcher, connected), 1);
    }

    @Override
    public void onReceiverConnected(ILogisticsNetwork main, IDataReceiver receiver) {
        receiver.refreshConnectedNetworks();
        List<Integer> connected = receiver.getConnectedNetworks();
        connected.iterator().forEachRemaining(networkID -> {
            ILogisticsNetwork sub = LogisticsNetworkHandler.instance().getNetwork((int)networkID);
            if (sub.getNetworkID() != main.getNetworkID() && sub.isValid()) {
                this.connectNetworks(main, sub);
            }
        });
    }

    @Override
    public void onReceiverDisconnected(ILogisticsNetwork network, IDataReceiver receiver) {
        receiver.refreshConnectedNetworks();
        List<Integer> connected = receiver.getConnectedNetworks();
        connected.iterator().forEachRemaining(networkID -> {
            ILogisticsNetwork sub = LogisticsNetworkHandler.instance().getNetwork((int)networkID);
            if (sub.getNetworkID() != network.getNetworkID() && sub.isValid()) {
                this.disconnectNetworks(network, sub);
            }
        });
    }
}

