/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.readers.info.handling;

import java.util.List;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.PL2ASMLoader;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.lists.AbstractChangeableList;
import sonar.logistics.api.core.tiles.displays.info.lists.EnumListChange;
import sonar.logistics.api.core.tiles.displays.info.lists.IMonitoredValue;
import sonar.logistics.base.filters.INodeFilter;

public class InfoHelper {
    public static final String DELETE = "del";
    public static final String SAVED = "saved";
    public static final String REMOVED = "rem";
    public static final String SYNCED = "spe";

    public static boolean isMatchingInfo(IInfo info, IInfo info2) {
        return info.isMatchingType(info2) && info.isMatchingInfo(info2);
    }

    public static boolean isIdenticalInfo(IInfo info, IInfo info2) {
        return InfoHelper.isMatchingInfo(info, info2) && info.isIdenticalInfo(info2);
    }

    public static <T extends IInfo> NBTTagCompound writeMonitoredList(NBTTagCompound tag, AbstractChangeableList<T> stacks, NBTHelper.SyncType type) {
        if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) {
            List<IMonitoredValue<T>> values = stacks.getList();
            if (values == null || values.isEmpty()) {
                tag.func_74757_a(DELETE, true);
                return tag;
            }
            NBTTagList list = new NBTTagList();
            for (IMonitoredValue<T> value2 : values) {
                EnumListChange change = value2.getChange();
                if (!change.shouldUpdate()) continue;
                NBTTagCompound compound = new NBTTagCompound();
                IInfo info = (IInfo)value2.getSaveableInfo();
                list.func_74742_a((NBTBase)InfoHelper.writeInfoToNBT(compound, info, NBTHelper.SyncType.SAVE));
                if (!value2.shouldDelete(change)) continue;
                compound.func_74757_a(REMOVED, true);
            }
            if (list.func_74745_c() != 0) {
                tag.func_74782_a(SYNCED, (NBTBase)list);
            }
        } else if (type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) {
            NBTTagList list = new NBTTagList();
            List<IMonitoredValue<IMonitoredValue>> values = stacks.getList();
            values.forEach(value -> list.func_74742_a((NBTBase)InfoHelper.writeInfoToNBT(new NBTTagCompound(), (IInfo)value.getSaveableInfo(), NBTHelper.SyncType.SAVE)));
            tag.func_74782_a(SAVED, (NBTBase)list);
        }
        return tag;
    }

    public static <L extends AbstractChangeableList> L readMonitoredList(NBTTagCompound tag, L stacks, NBTHelper.SyncType type) {
        block8: {
            block7: {
                if (tag.func_74764_b(DELETE)) {
                    stacks.values.clear();
                    return stacks;
                }
                if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.SAVE})) break block7;
                if (!tag.func_74764_b(SAVED)) {
                    return stacks;
                }
                NBTTagList list = tag.func_150295_c(SAVED, 10);
                stacks.values.clear();
                for (int i = 0; i < list.func_74745_c(); ++i) {
                    stacks.add((IInfo)InfoHelper.readInfoFromNBT(list.func_150305_b(i)));
                }
                break block8;
            }
            if (!type.isType(new NBTHelper.SyncType[]{NBTHelper.SyncType.DEFAULT_SYNC})) break block8;
            if (!tag.func_74764_b(SYNCED)) {
                return stacks;
            }
            NBTTagList list = tag.func_150295_c(SYNCED, 10);
            for (int i = 0; i < list.func_74745_c(); ++i) {
                NBTTagCompound infoTag = list.func_150305_b(i);
                boolean removed = infoTag.func_74767_n(REMOVED);
                IInfo stack = InfoHelper.readInfoFromNBT(infoTag);
                IMonitoredValue<IInfo> value = stacks.find((IInfo)stack);
                if (value == null) {
                    if (removed) continue;
                    stacks.add((IInfo)stack);
                    continue;
                }
                if (removed) {
                    stacks.values.remove(value);
                    continue;
                }
                value.reset(stack);
            }
        }
        return stacks;
    }

    public static boolean hasInfoChanged(IInfo info, IInfo newInfo) {
        if (info == null && newInfo == null) {
            return false;
        }
        if (info == null && newInfo != null || newInfo == null) {
            return true;
        }
        return !info.isMatchingType(newInfo) || !info.isMatchingInfo(newInfo) || !info.isIdenticalInfo(newInfo);
    }

    public static int getName(String name) {
        return PL2ASMLoader.infoIds.get(name);
    }

    public static Class<? extends IInfo> getInfoType(int id) {
        return PL2ASMLoader.infoClasses.get(PL2ASMLoader.infoNames.get(id));
    }

    public static NBTTagCompound writeInfoToNBT(NBTTagCompound tag, IInfo info, NBTHelper.SyncType type) {
        tag.func_74768_a("iiD", PL2ASMLoader.infoIds.get(info.getID()).intValue());
        info.writeData(tag, type);
        return tag;
    }

    public static IInfo readInfoFromNBT(NBTTagCompound tag) {
        return InfoHelper.loadInfo(tag.func_74762_e("iiD"), tag);
    }

    public static IInfo loadInfo(int id, NBTTagCompound tag) {
        return (IInfo)NBTHelper.instanceNBTSyncable(InfoHelper.getInfoType(id), (NBTTagCompound)tag);
    }

    public static INodeFilter readFilterFromNBT(NBTTagCompound tag) {
        return (INodeFilter)NBTHelper.instanceNBTSyncable(PL2ASMLoader.filterClasses.get(tag.func_74779_i("id")), (NBTTagCompound)tag);
    }

    public static NBTTagCompound writeFilterToNBT(NBTTagCompound tag, INodeFilter filter, NBTHelper.SyncType type) {
        tag.func_74778_a("id", filter.getNodeID());
        filter.writeData(tag, type);
        return tag;
    }
}

