/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.nodes.transfer.handling;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.IItemHandler;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.connections.data.network.INetworkItemHandler;
import sonar.logistics.api.core.tiles.nodes.NodeTransferMode;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.utils.CacheType;

public class NetworkItemHandler
implements INetworkItemHandler {
    public ILogisticsNetwork network;
    public Map<NodeConnection, IItemHandler> handlers;
    public int slots = 0;

    public NetworkItemHandler(ILogisticsNetwork network) {
        this.network = network;
    }

    @Override
    public IItemHandler initiliseTransfer() {
        this.slots = 0;
        this.handlers = new HashMap<NodeConnection, IItemHandler>();
        List<NodeConnection> connections = this.network.getConnections(CacheType.ALL);
        for (NodeConnection connection : connections) {
            IItemHandler handler = connection.getItemHandler();
            if (handler == null) continue;
            this.slots += handler.getSlots();
            this.handlers.put(connection, handler);
        }
        return this;
    }

    public int getSlots() {
        return this.slots;
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        int current = 0;
        for (Map.Entry<NodeConnection, IItemHandler> entry : this.handlers.entrySet()) {
            int size = entry.getValue().getSlots();
            if (current + size > slot) {
                return entry.getValue().getStackInSlot(slot - current);
            }
            current += size;
        }
        return ItemStack.field_190927_a;
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        int current = 0;
        for (Map.Entry<NodeConnection, IItemHandler> entry : this.handlers.entrySet()) {
            int size = entry.getValue().getSlots();
            if (current + size > slot) {
                if (entry.getKey().canTransferItem(entry.getKey(), stack, NodeTransferMode.ADD)) {
                    return entry.getValue().insertItem(slot - current, stack, simulate);
                }
                return stack;
            }
            current += size;
        }
        return stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        int current = 0;
        for (Map.Entry<NodeConnection, IItemHandler> entry : this.handlers.entrySet()) {
            int size = entry.getValue().getSlots();
            if (current + size > slot) {
                if (entry.getKey().canTransferItem(entry.getKey(), entry.getValue().getStackInSlot(slot - current), NodeTransferMode.REMOVE)) {
                    return entry.getValue().extractItem(slot - current, amount, simulate);
                }
                return ItemStack.field_190927_a;
            }
            current += size;
        }
        return ItemStack.field_190927_a;
    }

    public int getSlotLimit(int slot) {
        int current = 0;
        for (Map.Entry<NodeConnection, IItemHandler> entry : this.handlers.entrySet()) {
            int size = entry.getValue().getSlots();
            if (current + size > slot) {
                return entry.getValue().getSlotLimit(slot - current);
            }
            current += size;
        }
        return 0;
    }
}

