/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.text;

import java.util.List;
import javax.annotation.Nullable;
import javax.xml.ws.Holder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Tuple;
import net.minecraft.world.World;
import sonar.core.client.gui.IGuiOrigin;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.core.tiles.displays.gsi.interaction.DisplayScreenClick;
import sonar.logistics.core.tiles.displays.gsi.interaction.actions.IDisplayAction;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.types.text.StyledTextElement;
import sonar.logistics.core.tiles.displays.info.types.text.gui.GuiEditWrappedStyledString;
import sonar.logistics.core.tiles.displays.info.types.text.utils.StyledStringRenderer;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="wrapped_text", modid="practicallogistics2")
public class StyledWrappedTextElement
extends StyledTextElement {
    public int pageCount = 0;
    public StyledStringRenderer.StyledStringRenderHandler handler = new StyledStringRenderer.StyledStringRenderHandler(this);
    public static final String REGISTRY_NAME = "wrapped_text";

    public StyledWrappedTextElement() {
    }

    public StyledWrappedTextElement(String string) {
        super(string);
    }

    public StyledWrappedTextElement(List<String> strings) {
        super(strings);
    }

    @Override
    public void render() {
        int totalPages;
        boolean needsPages;
        this.handler.wrapLines(this.getActualScaling()[0] * (this.textScale * 100.0), this.getActualScaling()[1] * (this.textScale * 100.0));
        boolean bl = needsPages = this.handler.linesPerPage < this.handler.lines.size();
        if (needsPages && this.handler.linesPerPage != 0) {
            this.handler.linesPerPage = (int)Math.floor((this.getActualScaling()[1] - this.getActualScaling()[1] / 8.0) * (this.textScale * 100.0) / this.handler.totalLineSize());
        }
        if (this.pageCount >= (totalPages = (int)Math.ceil((double)this.handler.lines.size() / (double)this.handler.linesPerPage))) {
            this.pageCount = totalPages - 1;
        }
        if (this.pageCount < 0) {
            this.pageCount = 0;
        }
        GlStateManager.func_179139_a((double)(this.textScale / 100.0), (double)(this.textScale / 100.0), (double)1.0);
        StyledStringRenderer.instance().renderWrappedText(this.handler, this.getActualScaling()[0] * (this.textScale * 100.0), (needsPages ? this.getActualScaling()[1] - this.getActualScaling()[1] / 8.0 : this.getActualScaling()[1]) * (this.textScale * 100.0), this.pageCount * this.handler.linesPerPage, this.pageCount * this.handler.linesPerPage + this.handler.linesPerPage);
        GlStateManager.func_179139_a((double)(1.0 / (this.textScale / 100.0)), (double)(1.0 / (this.textScale / 100.0)), (double)1.0);
        if (needsPages && this.handler.linesPerPage != 0) {
            DisplayElementHelper.renderPageButons(this.getActualScaling(), this.pageCount + 1, totalPages);
        }
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditWrappedStyledString(this, obj), (Object)origin);
    }

    @Override
    public int onGSIClicked(DisplayScreenClick click, EntityPlayer player, double subClickX, double subClickY) {
        boolean needsPages;
        IDisplayAction action;
        Tuple<StyledStringRenderer.SimpleIndex, Integer> string = this.getStringClicked(subClickX, subClickY);
        if (string != null && string.func_76341_a() != null && (action = this.getAction(((StyledStringRenderer.SimpleIndex)string.func_76341_a()).string.getStyle().action_id)) != null) {
            return action.doAction(click, player, subClickX, subClickY);
        }
        boolean bl = needsPages = this.handler.linesPerPage < this.handler.lines.size();
        if (needsPages) {
            int totalPages = (int)Math.ceil((double)this.handler.lines.size() / (double)this.handler.linesPerPage);
            this.pageCount = DisplayElementHelper.doPageClick(subClickX, subClickY, this.getActualScaling(), this.pageCount, totalPages);
        }
        return -1;
    }

    @Nullable
    public int[] getIndexClicked(double subClickX, double subClickY) {
        return this.getIndexClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    @Nullable
    private int[] getIndexClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        Tuple<List<StyledStringRenderer.SimpleIndex>, Integer> line = this.getLineClicked((Double)subClickX.value, (Double)subClickY.value);
        Tuple<StyledStringRenderer.SimpleIndex, Integer> string = this.getStringClicked((Double)subClickX.value, (Double)subClickY.value);
        if (string != null && StyledWrappedTextElement.isValidReturn((Integer)string.func_76340_b())) {
            double rough_click = (Double)subClickX.value;
            Tuple<Character, Integer> character = this.getCharClicked((Double)subClickX.value, (Double)subClickY.value);
            if (StyledWrappedTextElement.isValidReturn((Integer)character.func_76340_b())) {
                int i = 0;
                int index = 0;
                for (StyledStringRenderer.SimpleIndex s : (List)line.func_76341_a()) {
                    if (i == (Integer)string.func_76340_b()) break;
                    index += s.end - s.start;
                    ++i;
                }
                int charWidth = StyledStringRenderer.instance().getCharRenderWidthFromStyledString(((StyledStringRenderer.SimpleIndex)string.func_76341_a()).string, ((Character)character.func_76341_a()).charValue());
                int total = 0;
                for (StyledStringRenderer.SimpleIndex s : (List)line.func_76341_a()) {
                    total += s.end - s.start;
                }
                return new int[]{Math.min(index + (Integer)character.func_76340_b(), total), (Integer)line.func_76340_b()};
            }
        }
        return null;
    }

    public Tuple<List<StyledStringRenderer.SimpleIndex>, Integer> getLineClicked(double subClickX, double subClickY) {
        return this.getLineClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    private Tuple<List<StyledStringRenderer.SimpleIndex>, Integer> getLineClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        double y = 0.0;
        int i = 0;
        double scale = this.textScale / 100.0;
        double max_width = this.getMaxScaling()[0];
        for (List<StyledStringRenderer.SimpleIndex> list : this.handler.lines.values()) {
            double height = (double)StyledStringRenderer.instance().field_78288_b * scale;
            if (y <= (Double)subClickY.value && y + height >= (Double)subClickY.value) {
                subClickY.value = y;
                double element = (double)StyledStringRenderer.instance().field_78288_b * scale;
                return new Tuple(list, (Object)i);
            }
            y += height + (double)this.spacing * scale;
            ++i;
        }
        return new Tuple(null, (Object)-1);
    }

    public Tuple<StyledStringRenderer.SimpleIndex, Integer> getStringClicked(double subClickX, double subClickY) {
        return this.getStringClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    private Tuple<StyledStringRenderer.SimpleIndex, Integer> getStringClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        Tuple<List<StyledStringRenderer.SimpleIndex>, Integer> line = this.getLineClicked(subClickX, subClickY);
        if (StyledWrappedTextElement.isValidReturn((Integer)line.func_76340_b())) {
            return this.getStringClicked(line, subClickX, subClickY);
        }
        return new Tuple(null, line.func_76340_b());
    }

    private Tuple<StyledStringRenderer.SimpleIndex, Integer> getStringClicked(Tuple<List<StyledStringRenderer.SimpleIndex>, Integer> line, Holder<Double> subClickX, Holder<Double> subClickY) {
        double x = 0.0;
        int i = 0;
        double scale = this.textScale / 100.0;
        for (StyledStringRenderer.SimpleIndex index : (List)line.func_76341_a()) {
            int stringWidth = StyledStringRenderer.instance().getRenderStringWidthWithStyledString(index.string, index.string.getUnformattedString().substring(index.start, index.end));
            double width = (double)stringWidth * scale;
            if (x <= (Double)subClickX.value && x + width >= (Double)subClickX.value) {
                Holder<Double> holder = subClickX;
                holder.value = (Double)holder.value - x;
                return new Tuple((Object)index, (Object)i);
            }
            if (i == 0 && (Double)subClickX.value < x) {
                return new Tuple(null, (Object)-3);
            }
            x += width;
            ++i;
        }
        return new Tuple(null, (Object)-2);
    }

    public Tuple<Character, Integer> getCharClicked(double subClickX, double subClickY) {
        return this.getCharClicked((Holder<Double>)new Holder((Object)subClickX), (Holder<Double>)new Holder((Object)subClickY));
    }

    private Tuple<Character, Integer> getCharClicked(Holder<Double> subClickX, Holder<Double> subClickY) {
        Tuple<StyledStringRenderer.SimpleIndex, Integer> line = this.getStringClicked(subClickX, subClickY);
        if (StyledWrappedTextElement.isValidReturn((Integer)line.func_76340_b())) {
            String unformatted = ((StyledStringRenderer.SimpleIndex)line.func_76341_a()).string.getUnformattedString().substring(((StyledStringRenderer.SimpleIndex)line.func_76341_a()).start, ((StyledStringRenderer.SimpleIndex)line.func_76341_a()).end);
            int length = unformatted.length();
            double x = 0.0;
            double scale = this.textScale / 100.0;
            for (int i = 0; i < length; ++i) {
                char charString = unformatted.charAt(i);
                int charStringWidth = StyledStringRenderer.instance().getCharWidthFromStyledString(((StyledStringRenderer.SimpleIndex)line.func_76341_a()).string, charString);
                double width = (double)charStringWidth * scale;
                if (x <= (Double)subClickX.value && x + width >= (Double)subClickX.value) {
                    subClickX.value = x;
                    return new Tuple((Object)Character.valueOf(unformatted.charAt(i)), (Object)i);
                }
                if (i == 0 && (Double)subClickX.value < x) {
                    return new Tuple(null, (Object)-2);
                }
                x += width;
            }
        }
        return new Tuple(null, (Object)-1);
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }
}

