/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.progress;

import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import sonar.core.client.gui.IGuiOrigin;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.api.asm.ASMDisplayElement;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.gui.PL2Colours;
import sonar.logistics.core.tiles.displays.info.elements.AbstractInfoElement;
import sonar.logistics.core.tiles.displays.info.elements.DisplayElementHelper;
import sonar.logistics.core.tiles.displays.info.elements.base.ElementFillType;
import sonar.logistics.core.tiles.displays.info.types.progress.GuiEditProgressBar;
import sonar.logistics.core.tiles.displays.info.types.progress.InfoProgressBar;
import sonar.logistics.core.tiles.displays.tiles.TileAbstractDisplay;

@ASMDisplayElement(id="p_bar", modid="practicallogistics2")
public class ElementProgressBar
extends AbstractInfoElement<InfoProgressBar> {
    public int colour = -11141291;
    public ProgressBarDirection direction = ProgressBarDirection.RIGHT;
    public ProgressBarType barType = ProgressBarType.FILL;
    public double border_thickness = 0.0;
    public int border_colour = PL2Colours.white_text.getRGB();
    public int background_colour = 0;
    public static final String REGISTRY_NAME = "p_bar";

    public ElementProgressBar() {
    }

    public ElementProgressBar(InfoUUID uuid) {
        super(uuid);
    }

    @Override
    public void render(InfoProgressBar info) {
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.002);
        double num1 = info.compare == 1 ? info.secondNum : info.firstNum;
        double num2 = info.compare == 1 ? info.firstNum : info.secondNum;
        double bar_start_width = 0.0;
        double bar_start_height = 0.0;
        double bar_end_width = this.getActualScaling()[0];
        double bar_end_height = this.getActualScaling()[1];
        double actual_border_thickness = Math.min(Math.min(bar_end_width / 4.0 - 0.00625, bar_end_height / 4.0 - 0.00625), this.border_thickness);
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)0.002);
        if (actual_border_thickness != 0.0) {
            DisplayElementHelper.drawRect(0.0, 0.0, this.getActualScaling()[0], actual_border_thickness, this.border_colour);
            DisplayElementHelper.drawRect(0.0, this.getActualScaling()[1] - actual_border_thickness, this.getActualScaling()[0], this.getActualScaling()[1], this.border_colour);
            DisplayElementHelper.drawRect(0.0, 0.0, actual_border_thickness, this.getActualScaling()[1], this.border_colour);
            DisplayElementHelper.drawRect(this.getActualScaling()[0], 0.0, this.getActualScaling()[0] - actual_border_thickness, this.getActualScaling()[1], this.border_colour);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.001);
        if (this.background_colour != 0) {
            DisplayElementHelper.drawRect(bar_start_width + actual_border_thickness, bar_start_height + actual_border_thickness, bar_end_width - actual_border_thickness, bar_end_height - actual_border_thickness, this.background_colour);
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.001);
        double actual_width = (bar_end_width -= actual_border_thickness * 2.0) - (bar_start_width += actual_border_thickness * 2.0);
        double actual_height = (bar_end_height -= actual_border_thickness * 2.0) - (bar_start_height += actual_border_thickness * 2.0);
        block0 : switch (this.barType) {
            case FILL: {
                switch (this.direction) {
                    case LEFT: {
                        double barWidth = num1 * actual_width / num2;
                        DisplayElementHelper.drawRect(bar_end_width - barWidth, bar_start_height, bar_end_width, bar_end_height, this.colour);
                        break block0;
                    }
                    case RIGHT: {
                        double barWidth = num1 * actual_width / num2;
                        DisplayElementHelper.drawRect(bar_start_width, bar_start_height, bar_start_width + barWidth, bar_end_height, this.colour);
                        break block0;
                    }
                    case UP: {
                        double barHeight = num1 * actual_height / num2;
                        DisplayElementHelper.drawRect(bar_start_width, bar_end_height - barHeight, bar_end_width, bar_end_height, this.colour);
                        break block0;
                    }
                    case DOWN: {
                        double barHeight = num1 * actual_height / num2;
                        DisplayElementHelper.drawRect(bar_start_width, bar_start_height, bar_end_width, bar_start_height + barHeight, this.colour);
                        break block0;
                    }
                }
                break;
            }
            case BARS: {
                int count = (int)(num1 * 20.0 / num2);
                double w = actual_width / 40.0;
                double h = actual_height / 40.0;
                switch (this.direction) {
                    case LEFT: {
                        for (int i = 0; i <= count; ++i) {
                            DisplayElementHelper.drawRect(bar_end_width - (w + (w * (double)(i * 2) - w / 2.0)), bar_start_height, bar_end_width - (w + (w * (double)(i * 2) - w / 2.0) + w), bar_end_height, this.colour);
                        }
                        break block0;
                    }
                    case RIGHT: {
                        for (int i = 0; i <= count; ++i) {
                            DisplayElementHelper.drawRect(bar_start_width + (w + (w * (double)(i * 2) - w / 2.0)), bar_start_height, bar_start_width + (w + (w * (double)(i * 2) - w / 2.0) + w), bar_end_height, this.colour);
                        }
                        break block0;
                    }
                    case UP: {
                        for (int i = 0; i <= count; ++i) {
                            DisplayElementHelper.drawRect(bar_start_width, bar_end_height - (h + (h * (double)(i * 2) - h / 2.0)), bar_end_width, bar_end_height - (h + (h * (double)(i * 2) - h / 2.0) + h), this.colour);
                        }
                        break block0;
                    }
                    case DOWN: {
                        for (int i = 0; i <= count; ++i) {
                            DisplayElementHelper.drawRect(bar_start_width, bar_start_height + h + (h * (double)(i * 2) - h / 2.0), bar_end_width, bar_start_height + h + (h * (double)(i * 2) - h / 2.0) + h, this.colour);
                        }
                        break block0;
                    }
                }
                break;
            }
            case SCROLLER: {
                double w = actual_width / 20.0;
                double h = actual_height / 20.0;
                double wPos = num1 * (actual_width - w) / num2;
                double hPos = num1 * (actual_height - h) / num2;
                switch (this.direction) {
                    case LEFT: {
                        DisplayElementHelper.drawRect(bar_end_width - wPos, bar_start_height, bar_end_width - wPos - w, bar_end_height, this.colour);
                        break block0;
                    }
                    case RIGHT: {
                        DisplayElementHelper.drawRect(bar_start_width + wPos, bar_start_height, bar_start_width + wPos + w, bar_end_height, this.colour);
                        break block0;
                    }
                    case UP: {
                        DisplayElementHelper.drawRect(bar_start_width, bar_end_height - hPos, bar_end_width, bar_end_height - hPos - h, this.colour);
                        break block0;
                    }
                    case DOWN: {
                        DisplayElementHelper.drawRect(bar_start_width, bar_start_height + hPos, bar_end_width, bar_start_height + hPos + h, this.colour);
                        break block0;
                    }
                }
                break;
            }
        }
        GlStateManager.func_179137_b((double)0.0, (double)0.0, (double)-0.002);
    }

    @Override
    public Object getClientEditGui(TileAbstractDisplay obj, Object origin, World world, EntityPlayer player) {
        return IGuiOrigin.withOrigin((IGuiOrigin)new GuiEditProgressBar(this, obj), (Object)origin);
    }

    @Override
    public boolean isType(IInfo info) {
        return info instanceof InfoProgressBar;
    }

    @Override
    public ElementFillType getFillType() {
        return ElementFillType.FILL_CONTAINER;
    }

    @Override
    public String getRepresentiveString() {
        return "Progress Bar";
    }

    @Override
    public void readData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.readData(nbt, type);
        this.colour = nbt.func_74762_e("c");
        this.direction = ProgressBarDirection.values()[nbt.func_74771_c("dir")];
        this.barType = ProgressBarType.values()[nbt.func_74771_c("barType")];
        this.border_thickness = nbt.func_74769_h("b_thickness");
        this.border_colour = nbt.func_74762_e("b_colour");
        this.background_colour = nbt.func_74762_e("bgd_colour");
    }

    @Override
    public NBTTagCompound writeData(NBTTagCompound nbt, NBTHelper.SyncType type) {
        super.writeData(nbt, type);
        nbt.func_74768_a("c", this.colour);
        nbt.func_74774_a("dir", (byte)this.direction.ordinal());
        nbt.func_74774_a("barType", (byte)this.barType.ordinal());
        nbt.func_74780_a("b_thickness", this.border_thickness);
        nbt.func_74768_a("b_colour", this.border_colour);
        nbt.func_74768_a("bgd_colour", this.background_colour);
        return nbt;
    }

    @Override
    public String getRegisteredName() {
        return REGISTRY_NAME;
    }

    public static enum ProgressBarDirection {
        RIGHT,
        LEFT,
        UP,
        DOWN;

    }

    public static enum ProgressBarType {
        FILL,
        BARS,
        SCROLLER;

    }
}

