/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.info.types.channels;

import java.util.List;
import java.util.UUID;
import net.minecraft.entity.Entity;
import sonar.core.network.sync.IDirtyPart;
import sonar.core.network.sync.SyncTagType;
import sonar.core.network.sync.SyncUUID;
import sonar.logistics.api.asm.ASMInfo;
import sonar.logistics.api.core.tiles.displays.info.IComparableInfo;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.INameableInfo;
import sonar.logistics.api.core.tiles.displays.info.comparators.ComparableObject;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.core.tiles.displays.info.types.BaseInfo;

@ASMInfo(id="entity", modid="practicallogistics2")
public class MonitoredEntity
extends BaseInfo<MonitoredEntity>
implements INameableInfo<MonitoredEntity>,
IComparableInfo<MonitoredEntity> {
    public static final String id = "entity";
    private SyncUUID uuid = new SyncUUID(1);
    private SyncTagType.STRING unlocalizedName = new SyncTagType.STRING(2);
    private SyncTagType.INT dimension = new SyncTagType.INT(3);

    public MonitoredEntity() {
        this.syncList.addParts(new IDirtyPart[]{this.uuid, this.unlocalizedName, this.dimension});
    }

    public MonitoredEntity(UUID id, String name, int dim) {
        this.syncList.addParts(new IDirtyPart[]{this.uuid, this.unlocalizedName, this.dimension});
        this.uuid.setObject(id);
        this.unlocalizedName.setObject((Object)name);
        this.dimension.setObject((Object)dim);
    }

    public MonitoredEntity(EntityConnection connection) {
        this.syncList.addParts(new IDirtyPart[]{this.uuid, this.unlocalizedName, this.dimension});
        this.uuid.setObject(connection.uuid);
        this.unlocalizedName.setObject((Object)connection.name);
        this.dimension.setObject((Object)connection.dim);
    }

    public MonitoredEntity(Entity entity) {
        this.syncList.addParts(new IDirtyPart[]{this.uuid, this.unlocalizedName, this.dimension});
        this.uuid.setObject(entity.getPersistentID());
        this.unlocalizedName.setObject((Object)entity.func_70005_c_());
        this.dimension.setObject((Object)entity.field_71093_bK);
    }

    @Override
    public boolean isIdenticalInfo(MonitoredEntity info) {
        return true;
    }

    @Override
    public boolean isMatchingInfo(MonitoredEntity info) {
        return info.uuid.getUUID().equals(this.uuid.getUUID());
    }

    @Override
    public boolean isMatchingType(IInfo info) {
        return info instanceof MonitoredEntity;
    }

    @Override
    public String getClientIdentifier() {
        return (String)this.unlocalizedName.getObject();
    }

    @Override
    public String getClientObject() {
        return "D: " + this.dimension.getObject();
    }

    @Override
    public String getClientType() {
        return id;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof MonitoredEntity) {
            MonitoredEntity monitoredCoords = (MonitoredEntity)obj;
            return this.isMatchingInfo(monitoredCoords);
        }
        return false;
    }

    @Override
    public boolean isValid() {
        return this.uuid.getUUID() != null;
    }

    @Override
    public String getID() {
        return id;
    }

    @Override
    public MonitoredEntity copy() {
        return new MonitoredEntity(this.uuid.getUUID(), (String)this.unlocalizedName.getObject(), (Integer)this.dimension.getObject());
    }

    public UUID getUUID() {
        return this.uuid.getUUID();
    }

    @Override
    public List<ComparableObject> getComparableObjects(List<ComparableObject> objects) {
        objects.add(new ComparableObject(this, "uuid", this.uuid.getUUID()));
        objects.add(new ComparableObject(this, "dimension", this.dimension.getObject()));
        objects.add(new ComparableObject(this, "name", this.unlocalizedName.getObject()));
        return objects;
    }
}

