/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.modes;

import java.util.List;
import sonar.core.helpers.FontHelper;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.packets.GSIElementPacketHelper;

public enum GSIElementSelection {
    DELETE,
    RESIZE,
    EDIT;


    public boolean shouldCollect() {
        return this == DELETE;
    }

    public int getTypeColour() {
        switch (this) {
            case DELETE: {
                return FontHelper.getIntFromColor((int)100, (int)50, (int)50);
            }
            case EDIT: {
                return FontHelper.getIntFromColor((int)50, (int)100, (int)50);
            }
            case RESIZE: {
                return FontHelper.getIntFromColor((int)50, (int)50, (int)100);
            }
        }
        return -1;
    }

    public void finishSelection(DisplayGSI gsi, List<Integer> containers) {
        switch (this) {
            case DELETE: {
                GSIElementPacketHelper.sendGSIPacket(GSIElementPacketHelper.createDeleteContainersPacket(containers), -1, gsi);
                break;
            }
            case EDIT: {
                break;
            }
            case RESIZE: {
                gsi.grid_mode.startResizeSelectionMode(containers.get(0));
                break;
            }
        }
    }
}

