/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.displays.gsi.interaction;

import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.Vec3d;
import sonar.core.api.utils.BlockInteractionType;
import sonar.core.helpers.NBTHelper;
import sonar.logistics.core.tiles.displays.gsi.DisplayGSI;
import sonar.logistics.core.tiles.displays.gsi.storage.DisplayElementContainer;
import sonar.logistics.core.tiles.displays.info.elements.base.IDisplayElement;
import sonar.logistics.core.tiles.displays.tiles.DisplayVectorHelper;

public class DisplayScreenClick {
    public DisplayGSI gsi;
    public BlockInteractionType type;
    public double clickX;
    public double clickY;
    public Vec3d intersect;
    public int identity;
    public boolean doubleClick = false;
    public boolean fakeGuiClick = false;
    public IDisplayElement clickedElement = null;
    public double subClickX = 0.0;
    public double subClickY = 0.0;
    public DisplayElementContainer clickedContainer = null;

    public DisplayScreenClick setClickPosition(double[] clickPosition) {
        this.clickX = clickPosition[0];
        this.clickY = clickPosition[1];
        return this;
    }

    public static NBTTagCompound writeClick(DisplayScreenClick click, NBTTagCompound tag) {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74768_a("identity", click.identity);
        nbt.func_74768_a("type", click.type.ordinal());
        nbt.func_74780_a("clickX", click.clickX);
        nbt.func_74780_a("clickY", click.clickY);
        DisplayVectorHelper.writeVec3d(click.intersect, "intersect", tag, NBTHelper.SyncType.SAVE);
        nbt.func_74757_a("doubleClick", click.doubleClick);
        tag.func_74782_a("displayclick", (NBTBase)nbt);
        return tag;
    }

    public static DisplayScreenClick readClick(NBTTagCompound tag) {
        DisplayScreenClick click = new DisplayScreenClick();
        NBTTagCompound nbt = tag.func_74775_l("displayclick");
        click.identity = nbt.func_74762_e("identity");
        click.type = BlockInteractionType.values()[nbt.func_74762_e("type")];
        click.clickX = nbt.func_74769_h("clickX");
        click.clickY = nbt.func_74769_h("clickY");
        click.intersect = DisplayVectorHelper.readVec3d("intersect", tag, NBTHelper.SyncType.SAVE);
        click.doubleClick = nbt.func_74767_n("doubleClick");
        return click;
    }
}

