/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.core.tiles.connections.data.network;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import sonar.core.helpers.ListHelper;
import sonar.core.helpers.NBTHelper;
import sonar.core.listener.ISonarListenable;
import sonar.core.listener.ISonarListener;
import sonar.core.listener.ListenableList;
import sonar.logistics.PL2;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.connections.data.network.INetworkItemHandler;
import sonar.logistics.api.core.tiles.nodes.IEntityNode;
import sonar.logistics.api.core.tiles.nodes.INode;
import sonar.logistics.api.core.tiles.readers.IInfoProvider;
import sonar.logistics.api.core.tiles.readers.IListReader;
import sonar.logistics.api.core.tiles.readers.channels.INetworkChannels;
import sonar.logistics.api.core.tiles.wireless.emitters.IDataEmitter;
import sonar.logistics.api.core.tiles.wireless.receivers.IDataReceiver;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.channels.PacketChannels;
import sonar.logistics.base.filters.ITransferFilteredTile;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.base.utils.CacheType;
import sonar.logistics.base.utils.LogisticsHelper;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.connections.data.network.NetworkHelper;
import sonar.logistics.core.tiles.displays.DisplayInfoReferenceHandler;
import sonar.logistics.core.tiles.displays.info.InfoPacketHelper;
import sonar.logistics.core.tiles.displays.info.types.channels.MonitoredBlockCoords;
import sonar.logistics.core.tiles.displays.info.types.general.InfoChangeableList;
import sonar.logistics.core.tiles.nodes.transfer.handling.NetworkItemHandler;
import sonar.logistics.core.tiles.readers.info.handling.InfoHelper;

public class LogisticsNetwork
implements ILogisticsNetwork {
    public static final ArrayList<Class> CACHE_TYPES = Lists.newArrayList((Object[])new Class[]{IDataReceiver.class, IDataEmitter.class, IListReader.class, INetworkTile.class, INode.class, IEntityNode.class, ITransferFilteredTile.class});
    public final ListenableList<ILogisticsNetwork> subNetworks = new ListenableList((ISonarListenable)this, 2);
    public final Map<Class, INetworkChannels> handlers = new LinkedHashMap<Class, INetworkChannels>();
    public List<IInfoProvider> localProviders = new ArrayList<IInfoProvider>();
    public List<IInfoProvider> globalProviders = new ArrayList<IInfoProvider>();
    private Map<CacheHandler, List> caches = LogisticsHelper.getCachesMap();
    private List<NodeConnection> localChannels = new ArrayList<NodeConnection>();
    private List<NodeConnection> globalChannels = new ArrayList<NodeConnection>();
    private List<NodeConnection> allChannels = new ArrayList<NodeConnection>();
    private long tickStart = 0L;
    private long updateTick = 0L;
    public int networkID;
    public boolean isValid = true;
    public INetworkItemHandler networkItemHandler;

    public LogisticsNetwork(int networkID) {
        this.networkID = networkID;
    }

    @Override
    public void onNetworkCreated() {
        this.networkItemHandler = new NetworkItemHandler(this);
    }

    @Override
    public void onNetworkTick() {
        this.tickStart = System.nanoTime();
        this.updateNetworkHandlers();
        this.updateTick = System.nanoTime() - this.tickStart;
    }

    @Override
    public void onNetworkRemoved() {
        this.isValid = false;
        List watching = this.subNetworks.getListeners(new int[]{1});
        List connected = this.subNetworks.getListeners(new int[]{0});
        watching.forEach(network -> network.getListenerList().removeListener((ISonarListener)this, true, new int[]{0}));
        connected.forEach(network -> network.getListenerList().removeListener((ISonarListener)this, true, new int[]{1}));
        this.subNetworks.invalidateList();
        this.handlers.values().forEach(INetworkChannels::onDeleted);
        this.caches.clear();
        this.handlers.clear();
    }

    @Override
    public InfoChangeableList<MonitoredBlockCoords> createConnectionsList(CacheType cacheType) {
        InfoChangeableList<MonitoredBlockCoords> list = new InfoChangeableList<MonitoredBlockCoords>();
        this.getConnections(cacheType).forEach(CHANNEL -> list.add(CHANNEL.getChannel()));
        return list;
    }

    @Override
    public <T extends INetworkTile> List<T> getCachedTiles(CacheHandler<T> handler, CacheType cacheType) {
        ArrayList tiles;
        ArrayList arrayList = tiles = cacheType.isLocal() ? Lists.newArrayList((Iterable)this.caches.getOrDefault(handler, new ArrayList())) : new ArrayList();
        if (cacheType.isGlobal()) {
            List<ILogisticsNetwork> connected = NetworkHelper.getAllNetworks(this, 0);
            connected.forEach(network -> ListHelper.addWithCheck((Collection)tiles, network.getCachedTiles(handler, CacheType.LOCAL)));
        }
        return tiles;
    }

    @Override
    public boolean validateTile(INetworkTile listener) {
        if (!listener.isValid()) {
            this.removeConnection(listener);
            return false;
        }
        return true;
    }

    @Override
    public void addConnection(INetworkTile tile) {
        CacheHandler.getValidCaches(tile).forEach(cache -> ListHelper.addWithCheck((Collection)this.caches.get(cache), (Object)tile));
    }

    @Override
    public void removeConnection(INetworkTile tile) {
        CacheHandler.getValidCaches(tile).forEach(cache -> this.caches.get(cache).remove(tile));
    }

    @Override
    public void addLocalInfoProvider(IInfoProvider monitor) {
        if (ListHelper.addWithCheck(this.localProviders, (Object)monitor)) {
            DisplayInfoReferenceHandler.queueUpdate(monitor, DisplayInfoReferenceHandler.UpdateCause.NETWORK_CHANGE);
        }
    }

    @Override
    public void removeLocalInfoProvider(IInfoProvider monitor) {
        if (this.localProviders.remove(monitor)) {
            DisplayInfoReferenceHandler.queueUpdate(monitor, DisplayInfoReferenceHandler.UpdateCause.NETWORK_CHANGE);
        }
    }

    @Override
    public void sendConnectionsPacket(EntityPlayer player) {
        InfoChangeableList<MonitoredBlockCoords> coords = this.createConnectionsList(CacheType.ALL);
        NBTTagCompound channelTag = InfoHelper.writeMonitoredList(new NBTTagCompound(), coords, NBTHelper.SyncType.DEFAULT_SYNC);
        if (channelTag.func_82582_d()) {
            return;
        }
        PL2.network.sendTo((IMessage)new PacketChannels(this.getNetworkID(), channelTag), (EntityPlayerMP)player);
    }

    @Override
    public List<NodeConnection> getConnections(CacheType cacheType) {
        switch (cacheType) {
            case GLOBAL: {
                return this.globalChannels;
            }
            case LOCAL: {
                return this.localChannels;
            }
        }
        return this.allChannels;
    }

    public void createLocalChannels() {
        ArrayList<NodeConnection> channels = new ArrayList<NodeConnection>();
        LogisticsHelper.sortNodeConnections(channels, this.getCachedTiles(CacheHandler.NODES, CacheType.LOCAL));
        this.localChannels = Lists.newArrayList(channels);
    }

    public void createGlobalChannels() {
        ArrayList<NodeConnection> channels = new ArrayList<NodeConnection>();
        LogisticsHelper.sortNodeConnections(channels, this.getCachedTiles(CacheHandler.NODES, CacheType.GLOBAL));
        this.globalChannels = Lists.newArrayList(channels);
        ArrayList<NodeConnection> all = new ArrayList<NodeConnection>();
        ListHelper.addWithCheck(all, this.globalChannels);
        ListHelper.addWithCheck(all, this.localChannels);
        NodeConnection.sortConnections(all);
        this.allChannels = all;
        this.updateHandlerChannels();
    }

    public void createGlobalProviders() {
        this.globalProviders = Lists.newArrayList(this.localProviders);
        NetworkHelper.getAllNetworks(this, 0).forEach(network -> ListHelper.addWithCheck(this.globalProviders, network.getLocalInfoProviders()));
    }

    public void updateNetworkHandlers() {
        this.handlers.values().forEach(INetworkChannels::updateChannel);
        this.localProviders.forEach(InfoPacketHelper::sendNormalProviderInfo);
    }

    public void updateHandlerChannels() {
        this.handlers.forEach((H, C) -> C.onChannelsChanged());
    }

    @Override
    public <T extends INetworkChannels> T getNetworkChannels(Class<T> channelClass) {
        return (T)this.handlers.get(channelClass);
    }

    @Override
    public <T extends INetworkChannels> T getOrCreateNetworkChannels(Class<T> channelClass) {
        return (T)this.handlers.computeIfAbsent(channelClass, c -> (INetworkChannels)LogisticsHelper.getChannelInstance(channelClass, this));
    }

    @Override
    public List<IInfoProvider> getLocalInfoProviders() {
        return this.localProviders;
    }

    @Override
    public List<IInfoProvider> getGlobalInfoProviders() {
        return this.globalProviders;
    }

    @Override
    public INetworkItemHandler getNetworkItemHandler() {
        return this.networkItemHandler;
    }

    @Override
    public int getNetworkID() {
        return this.networkID;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public ListenableList<ILogisticsNetwork> getListenerList() {
        return this.subNetworks;
    }

    @Override
    public long getNetworkTickTime() {
        return this.updateTick;
    }
}

