/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import sonar.core.api.utils.BlockCoords;
import sonar.core.utils.IValidate;
import sonar.logistics.api.core.items.operator.IOperatorTool;
import sonar.logistics.api.core.tiles.connections.data.network.ILogisticsNetwork;
import sonar.logistics.api.core.tiles.nodes.INode;
import sonar.logistics.api.core.tiles.wireless.transceivers.IEntityTransceiver;
import sonar.logistics.api.core.tiles.wireless.transceivers.ITileTransceiver;
import sonar.logistics.base.channels.BlockConnection;
import sonar.logistics.base.channels.EntityConnection;
import sonar.logistics.base.channels.NodeConnection;
import sonar.logistics.base.tiles.INetworkTile;
import sonar.logistics.core.tiles.connections.data.network.CacheHandler;
import sonar.logistics.core.tiles.connections.data.network.LogisticsNetworkHandler;

public class LogisticsHelper {
    public static boolean isPlayerUsingOperator(EntityPlayer player) {
        return player.func_184614_ca().func_77973_b() instanceof IOperatorTool;
    }

    public static List<ILogisticsNetwork> getNetworks(List<Integer> ids) {
        ArrayList<ILogisticsNetwork> networks = new ArrayList<ILogisticsNetwork>();
        ids.forEach(id -> {
            ILogisticsNetwork network = LogisticsNetworkHandler.instance().getNetwork((int)id);
            if (network.isValid()) {
                networks.add(network);
            }
        });
        return networks;
    }

    public static Map<CacheHandler, List> getCachesMap() {
        HashMap<CacheHandler, List> connections = new HashMap<CacheHandler, List>();
        CacheHandler.handlers.forEach(classType -> {
            List cfr_ignored_0 = connections.put((CacheHandler)classType, new ArrayList());
        });
        return connections;
    }

    public static <T> T getChannelInstance(Class<T> channelType, ILogisticsNetwork network) {
        try {
            return channelType.getConstructor(ILogisticsNetwork.class).newInstance(network);
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static NodeConnection getTransceiverNode(INetworkTile source, World world, ItemStack stack) {
        IEntityTransceiver trans;
        UUID uuid;
        if (stack.func_77973_b() instanceof ITileTransceiver) {
            ITileTransceiver trans2 = (ITileTransceiver)stack.func_77973_b();
            return new BlockConnection(source, trans2.getCoords(stack), trans2.getDirection(stack));
        }
        if (stack.func_77973_b() instanceof IEntityTransceiver && (uuid = (trans = (IEntityTransceiver)stack.func_77973_b()).getEntityUUID(stack)) != null) {
            for (Entity entity : world.func_72910_y()) {
                if (!entity.getPersistentID().equals(uuid)) continue;
                return new EntityConnection(source, entity);
            }
        }
        return null;
    }

    public static List<NodeConnection> sortNodeConnections(List<NodeConnection> channels, List<INode> nodes) {
        nodes.stream().filter(IValidate::isValid).forEach(n -> n.addConnections(channels));
        return NodeConnection.sortConnections(channels);
    }

    public static ItemStack getCoordItem(BlockCoords coords, World world) {
        TileEntity tile = coords.getTileEntity(world);
        IBlockState state = coords.getBlockState(world);
        ItemStack stack = coords.getBlock(world).func_185473_a(world, coords.getBlockPos(), state);
        if (stack.func_190926_b()) {
            stack = new ItemStack(Item.func_150898_a((Block)state.func_177230_c()));
        }
        return stack;
    }
}

