/*
 * Decompiled with CFR 0.152.
 */
package sonar.logistics.base.guidance.errors;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.minecraft.util.text.TextFormatting;
import sonar.core.helpers.ListHelper;
import sonar.logistics.api.asm.ASMInfoError;
import sonar.logistics.api.core.tiles.displays.info.IInfo;
import sonar.logistics.api.core.tiles.displays.info.InfoUUID;
import sonar.logistics.base.guidance.errors.ErrorTileUUID;
import sonar.logistics.base.guidance.errors.IInfoError;
import sonar.logistics.base.tiles.INetworkTile;

@ASMInfoError(id="destroy", modid="practicallogistics2")
public class ErrorDestroyed
extends ErrorTileUUID {
    public ErrorDestroyed() {
    }

    public ErrorDestroyed(InfoUUID uuid, INetworkTile tile) {
        super(uuid, tile);
    }

    public ErrorDestroyed(List<InfoUUID> uuids, INetworkTile tile) {
        super(uuids, tile);
    }

    @Override
    public List<String> getDisplayMessage() {
        ArrayList message = Lists.newArrayList();
        message.add(TextFormatting.BOLD + "Connection Destroyed");
        if (!this.displayStack.func_190926_b()) {
            message.add("NAME: " + this.displayStack.func_82833_r());
        }
        if (this.coords != null) {
            message.add("POS: " + this.coords.toString());
        }
        message.add("ID: " + this.identity);
        return message;
    }

    @Override
    public boolean canDisplayInfo(IInfo info) {
        return false;
    }

    @Override
    public boolean canCombine(IInfoError error) {
        return error instanceof ErrorDestroyed && ((ErrorDestroyed)error).identity == this.identity;
    }

    @Override
    public void addError(IInfoError error) {
        ErrorDestroyed dError = (ErrorDestroyed)error;
        ListHelper.addWithCheck((Collection)this.uuids, (Collection)dError.uuids);
    }

    @Override
    public void removeError(IInfoError error) {
        ErrorDestroyed dError = (ErrorDestroyed)error;
        dError.uuids.forEach(uuid -> this.uuids.remove(uuid));
    }
}

