/*
 * Decompiled with CFR 0.152.
 */
package xreliquary.crafting.factories;

import com.google.gson.JsonObject;
import java.util.List;
import javax.annotation.Nonnull;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.inventory.InventoryCrafting;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.PotionEffect;
import net.minecraft.util.JsonUtils;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.crafting.CraftingHelper;
import net.minecraftforge.common.crafting.IRecipeFactory;
import net.minecraftforge.common.crafting.JsonContext;
import net.minecraftforge.oredict.ShapedOreRecipe;
import net.minecraftforge.registries.IForgeRegistryEntry;
import org.apache.commons.lang3.tuple.MutablePair;
import xreliquary.crafting.factories.UseMetaEffectsIngredientFactory;
import xreliquary.util.potions.XRPotionHelper;

@MethodsReturnNonnullByDefault
public class UseMetaEffectsRecipeFactory
implements IRecipeFactory {
    public IRecipe parse(JsonContext context, JsonObject json) {
        ShapedOreRecipe recipe = ShapedOreRecipe.factory((JsonContext)context, (JsonObject)json);
        CraftingHelper.ShapedPrimer primer = new CraftingHelper.ShapedPrimer();
        primer.height = recipe.getHeight();
        primer.width = recipe.getWidth();
        primer.input = recipe.func_192400_c();
        primer.mirrored = JsonUtils.func_151209_a((JsonObject)json, (String)"mirrored", (boolean)true);
        return new UseMetaEffectsRecipe(new ResourceLocation("xreliquary", "use_meta_effects"), recipe.func_77571_b(), primer);
    }

    public static class UseMetaEffectsRecipe
    extends IForgeRegistryEntry.Impl<IRecipe>
    implements IRecipe {
        private final ResourceLocation group;
        private final ItemStack output;
        private final int width;
        private final int height;
        private final NonNullList<Ingredient> input;
        private final boolean mirrored;

        public UseMetaEffectsRecipe(ResourceLocation group, @Nonnull ItemStack result, CraftingHelper.ShapedPrimer primer) {
            this.group = group;
            this.output = result.func_77946_l();
            this.width = primer.width;
            this.height = primer.height;
            this.input = primer.input;
            this.mirrored = primer.mirrored;
        }

        @Nonnull
        public ItemStack func_77572_b(@Nonnull InventoryCrafting inv) {
            ItemStack newOutput = this.output.func_77946_l();
            MutablePair<Integer, List<PotionEffect>> targetMetaEffects = this.findMatchAndUpdateMetaEffects(inv);
            if ((Integer)targetMetaEffects.getLeft() != -1) {
                newOutput.func_77964_b(((Integer)targetMetaEffects.getLeft()).intValue());
            }
            if (targetMetaEffects.getRight() != null) {
                XRPotionHelper.addPotionEffectsToStack(newOutput, (List)targetMetaEffects.getRight());
            }
            return newOutput;
        }

        public boolean func_194133_a(int width, int height) {
            return width >= this.width && height >= this.height;
        }

        private MutablePair<Integer, List<PotionEffect>> findMatchAndUpdateMetaEffects(@Nonnull InventoryCrafting inv) {
            MutablePair targetMetaEffects = new MutablePair((Object)-1, null);
            for (int startX = 0; startX <= 3 - this.width; ++startX) {
                for (int startY = 0; startY <= 3 - this.height; ++startY) {
                    this.reset((MutablePair<Integer, List<PotionEffect>>)targetMetaEffects);
                    if (this.checkMatchAndUpdateMetaEffects(inv, (MutablePair<Integer, List<PotionEffect>>)targetMetaEffects, startX, startY, false)) {
                        return targetMetaEffects;
                    }
                    targetMetaEffects = new MutablePair((Object)-1, null);
                    if (!this.checkMatchAndUpdateMetaEffects(inv, (MutablePair<Integer, List<PotionEffect>>)targetMetaEffects, startX, startY, true)) continue;
                    return targetMetaEffects;
                }
            }
            return new MutablePair((Object)-1, null);
        }

        private void reset(MutablePair<Integer, List<PotionEffect>> targetMetaEffects) {
            targetMetaEffects.setLeft((Object)-1);
            targetMetaEffects.setRight(null);
        }

        private boolean checkMatchAndUpdateMetaEffects(@Nonnull InventoryCrafting inv, MutablePair<Integer, List<PotionEffect>> targetMetaEffects, int startX, int startY, boolean mirror) {
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int subX = x - startX;
                    int subY = y - startY;
                    Ingredient target = this.getTarget(subX, subY, mirror);
                    if (!target.apply(inv.func_70463_b(x, y))) {
                        return false;
                    }
                    this.updateTargetMetaEffects(inv, targetMetaEffects, x, y, target);
                }
            }
            return true;
        }

        public boolean func_77569_a(@Nonnull InventoryCrafting inv, @Nonnull World world) {
            for (int x = 0; x <= 3 - this.width; ++x) {
                for (int y = 0; y <= 3 - this.height; ++y) {
                    if (this.checkMatch(inv, x, y, false)) {
                        return true;
                    }
                    if (!this.mirrored || !this.checkMatch(inv, x, y, true)) continue;
                    return true;
                }
            }
            return false;
        }

        private boolean checkMatch(InventoryCrafting inv, int startX, int startY, boolean mirror) {
            MutablePair targetMetaEffects = new MutablePair((Object)-1, null);
            for (int x = 0; x < 3; ++x) {
                for (int y = 0; y < 3; ++y) {
                    int subX = x - startX;
                    int subY = y - startY;
                    Ingredient target = this.getTarget(subX, subY, mirror);
                    if (!target.apply(inv.func_70463_b(x, y))) {
                        return false;
                    }
                    if (this.updateTargetMetaEffects(inv, (MutablePair<Integer, List<PotionEffect>>)targetMetaEffects, x, y, target)) continue;
                    return false;
                }
            }
            return true;
        }

        public ItemStack func_77571_b() {
            return this.output;
        }

        public NonNullList<Ingredient> func_192400_c() {
            return this.input;
        }

        public String func_193358_e() {
            return this.group.toString();
        }

        private Ingredient getTarget(int subX, int subY, boolean mirror) {
            if (subX >= 0 && subY >= 0 && subX < this.width && subY < this.height) {
                if (mirror) {
                    return (Ingredient)this.input.get(this.width - subX - 1 + subY * this.width);
                }
                return (Ingredient)this.input.get(subX + subY * this.width);
            }
            return Ingredient.field_193370_a;
        }

        private boolean updateTargetMetaEffects(InventoryCrafting inv, MutablePair<Integer, List<PotionEffect>> targetMetaEffects, int x, int y, Ingredient target) {
            if (target instanceof UseMetaEffectsIngredientFactory.UseMetaEffectsIngredient) {
                UseMetaEffectsIngredientFactory.UseMetaEffectsIngredient useMetaEffectsTarget = (UseMetaEffectsIngredientFactory.UseMetaEffectsIngredient)target;
                ItemStack invStack = inv.func_70463_b(x, y);
                if (useMetaEffectsTarget.isUseMeta()) {
                    if ((Integer)targetMetaEffects.getLeft() == -1) {
                        targetMetaEffects.setLeft((Object)invStack.func_77960_j());
                    } else if (((Integer)targetMetaEffects.getLeft()).intValue() != invStack.func_77960_j()) {
                        return false;
                    }
                }
                if (useMetaEffectsTarget.isUseEffects()) {
                    if (targetMetaEffects.getRight() == null) {
                        targetMetaEffects.setRight(XRPotionHelper.changePotionEffectsDuration(XRPotionHelper.getPotionEffectsFromCompoundTag(invStack.func_77978_p()), useMetaEffectsTarget.getFactor()));
                    } else if (!XRPotionHelper.changePotionEffectsDuration(XRPotionHelper.getPotionEffectsFromCompoundTag(invStack.func_77978_p()), useMetaEffectsTarget.getFactor()).equals(targetMetaEffects.getRight())) {
                        return false;
                    }
                }
            }
            return true;
        }

        public boolean func_192399_d() {
            return true;
        }
    }
}

