/*
 * Decompiled with CFR 0.152.
 */
package org.softc.armoryexpansion.integration.plugins.tinkers_construct;

import java.util.Map;
import net.minecraftforge.common.config.Property;
import org.softc.armoryexpansion.integration.plugins.tinkers_construct.TiCMaterial;
import slimeknights.tconstruct.library.TinkerRegistry;
import slimeknights.tconstruct.library.materials.ArrowShaftMaterialStats;
import slimeknights.tconstruct.library.materials.BowMaterialStats;
import slimeknights.tconstruct.library.materials.ExtraMaterialStats;
import slimeknights.tconstruct.library.materials.FletchingMaterialStats;
import slimeknights.tconstruct.library.materials.HandleMaterialStats;
import slimeknights.tconstruct.library.materials.HeadMaterialStats;
import slimeknights.tconstruct.library.materials.IMaterialStats;
import slimeknights.tconstruct.library.materials.Material;
import slimeknights.tconstruct.library.materials.ProjectileMaterialStats;

public class TiCStats {
    private static HeadMaterialStats getHeadMaterialStats(int durability, float hardness, float damage, int harvestLevel) {
        return new HeadMaterialStats(durability * 8, hardness * 0.65f, damage, harvestLevel);
    }

    private static HandleMaterialStats getHandledMaterialStats(int durability, float magicaffinity) {
        return new HandleMaterialStats(magicaffinity / 6.0f + 0.1f, durability * 10 / 7);
    }

    private static ExtraMaterialStats getExtraMaterialStats(int durability) {
        return new ExtraMaterialStats(durability * 5);
    }

    private static void registerMaterialToolStats(Material material, int durability, float hardness, float damage, float magicaffinity, int harvestLevel, Map<String, Property> properties) {
        if (!material.hasStats("head") && properties.get("head").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getHeadMaterialStats(durability, hardness, damage, harvestLevel));
        }
        if (!material.hasStats("handle") && properties.get("handle").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getHandledMaterialStats(durability, magicaffinity));
        }
        if (!material.hasStats("extra") && properties.get("extra").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getExtraMaterialStats(durability));
        }
    }

    private static void registerMaterialToolStats(String identifier, int durability, float hardness, float damage, float magicaffinity, int harvestLevel, Map<String, Property> properties) {
        Material material = TinkerRegistry.getMaterial((String)identifier);
        if (material.identifier.equals("unknown")) {
            return;
        }
        TiCStats.registerMaterialToolStats(material, durability, hardness, damage, magicaffinity, harvestLevel, properties);
    }

    static void registerMaterialToolStats(TiCMaterial material, Map<String, Property> properties) {
        TiCStats.registerMaterialToolStats(material.getIdentifier(), material.getDurability(), material.getHardness(), material.getDamage(), material.getMagicaffinity(), material.getHarvestLevel(), properties);
    }

    private static Float calcDrawSpeed(int durability) {
        float val;
        if (durability < 25) {
            val = 1.0f;
        } else {
            val = (float)(durability - 20 + 1) / 10.0f;
            val = (float)((double)val - Math.floor(val));
        }
        return Float.valueOf(val);
    }

    private static BowMaterialStats getBowMaterialStats(int durability, float range, float damage) {
        return new BowMaterialStats(TiCStats.calcDrawSpeed(durability).floatValue(), range, damage + 3.0f);
    }

    private static ArrowShaftMaterialStats getArrowShaftMaterialStats(float magicaffinity) {
        return new ArrowShaftMaterialStats(magicaffinity * 2.0f / 9.0f + 0.1f, (int)magicaffinity / 5);
    }

    private static void registerMaterialBowStats(Material material, int durability, float range, float damage, float magicaffinity, Map<String, Property> properties) {
        if (!material.hasStats("bow") && properties.get("bow").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getBowMaterialStats(durability, range, damage));
        }
        if (!material.hasStats("shaft") && properties.get("shaft").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getArrowShaftMaterialStats(magicaffinity));
        }
    }

    private static void registerMaterialBowStats(String identifier, int durability, float range, float damage, float magicaffinity, Map<String, Property> properties) {
        Material material = TinkerRegistry.getMaterial((String)identifier);
        if (material.identifier.equals("unknown")) {
            return;
        }
        TiCStats.registerMaterialBowStats(material, durability, range, damage, magicaffinity, properties);
    }

    static void registerMaterialBowStats(TiCMaterial material, Map<String, Property> properties) {
        TiCStats.registerMaterialBowStats(material.getIdentifier(), material.getDurability(), material.getRange(), material.getDamage(), material.getMagicaffinity(), properties);
    }

    private static FletchingMaterialStats getFletchlingMaterialStats(float accuracy, float magicaffinity) {
        return new FletchingMaterialStats(accuracy, magicaffinity);
    }

    private static void registerMaterialFletchingStats(Material material, float accuracy, float magicaffinity, Map<String, Property> properties) {
        if (!material.hasStats("fletching") && properties.get("fletching").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getFletchlingMaterialStats(accuracy, magicaffinity));
        }
    }

    private static void registerMaterialFletchingStats(String identifier, float accuracy, float magicaffinity, Map<String, Property> properties) {
        Material material = TinkerRegistry.getMaterial((String)identifier);
        if (material.identifier.equals("unknown")) {
            return;
        }
        TiCStats.registerMaterialFletchingStats(material, accuracy, magicaffinity, properties);
    }

    static void registerMaterialFletchingStats(TiCMaterial material, Map<String, Property> properties) {
        TiCStats.registerMaterialFletchingStats(material.getIdentifier(), 0.0f, material.getMagicaffinity(), properties);
    }

    private static ProjectileMaterialStats getProjectileMaterialStats() {
        return new ProjectileMaterialStats();
    }

    private static void registerMaterialProjectileStats(Material material, Map<String, Property> properties) {
        if (!material.hasStats("projectile") && properties.get("projectile").getBoolean()) {
            TinkerRegistry.addMaterialStats((Material)material, (IMaterialStats)TiCStats.getProjectileMaterialStats());
        }
    }

    private static void registerMaterialProjectileStats(String identifier, Map<String, Property> properties) {
        Material material = TinkerRegistry.getMaterial((String)identifier);
        if (material.identifier.equals("unknown")) {
            return;
        }
        TiCStats.registerMaterialProjectileStats(material, properties);
    }

    static void registerMaterialProjectileStats(TiCMaterial material, Map<String, Property> properties) {
        TiCStats.registerMaterialProjectileStats(material.getIdentifier(), properties);
    }
}

