/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.network;

import io.netty.buffer.ByteBuf;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.inventory.ContainerLogistics;
import me.desht.pneumaticcraft.common.network.LocationIntPacket;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;

public class PacketSetLogisticsFilterStack
extends LocationIntPacket<PacketSetLogisticsFilterStack> {
    private ItemStack settingStack;
    private int settingIndex;

    public PacketSetLogisticsFilterStack() {
    }

    public PacketSetLogisticsFilterStack(SemiBlockLogistics logistics, @Nonnull ItemStack stack, int index) {
        super(logistics.getPos());
        this.settingStack = stack;
        this.settingIndex = index;
    }

    @Override
    public void toBytes(ByteBuf buf) {
        super.toBytes(buf);
        ByteBufUtils.writeItemStack((ByteBuf)buf, (ItemStack)this.settingStack);
        buf.writeInt(this.settingIndex);
    }

    @Override
    public void fromBytes(ByteBuf buf) {
        super.fromBytes(buf);
        this.settingStack = ByteBufUtils.readItemStack((ByteBuf)buf);
        this.settingIndex = buf.readInt();
    }

    @Override
    public void handleClientSide(PacketSetLogisticsFilterStack message, EntityPlayer player) {
    }

    @Override
    public void handleServerSide(PacketSetLogisticsFilterStack message, EntityPlayer player) {
        if (message.pos.equals((Object)new BlockPos(0, 0, 0))) {
            if (player.field_71070_bA instanceof ContainerLogistics) {
                ((ContainerLogistics)player.field_71070_bA).logistics.getFilters().setStackInSlot(message.settingIndex, message.settingStack);
            }
        } else {
            SemiBlockLogistics semiBlock = SemiBlockManager.getInstance(player.field_70170_p).getSemiBlock(SemiBlockLogistics.class, player.field_70170_p, message.pos);
            if (semiBlock != null) {
                semiBlock.getFilters().setStackInSlot(message.settingIndex, message.settingStack);
            }
        }
    }
}

