/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block.tubes;

import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import me.desht.pneumaticcraft.api.tileentity.IAirHandler;
import me.desht.pneumaticcraft.client.model.module.ModelLogistics;
import me.desht.pneumaticcraft.client.model.module.ModelModuleBase;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.ai.LogisticsManager;
import me.desht.pneumaticcraft.common.block.tubes.ModuleNetworkManager;
import me.desht.pneumaticcraft.common.block.tubes.TubeModule;
import me.desht.pneumaticcraft.common.network.NetworkHandler;
import me.desht.pneumaticcraft.common.network.PacketUpdateLogisticModule;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockLogistics;
import me.desht.pneumaticcraft.common.semiblock.SemiBlockManager;
import me.desht.pneumaticcraft.common.tileentity.TileEntityPlasticMixer;
import me.desht.pneumaticcraft.common.util.IOHelper;
import me.desht.pneumaticcraft.common.util.PneumaticCraftUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.Vec3i;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.CapabilityFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.items.IItemHandler;

public class ModuleLogistics
extends TubeModule {
    private SemiBlockLogistics cachedFrame;
    private int colorChannel;
    private int ticksSinceAction = -1;
    private int ticksSinceNotEnoughAir = -1;
    private int ticksUntilNextCycle;
    private boolean powered;
    private static final double MIN_PRESSURE = 3.0;
    private static final double ITEM_TRANSPORT_COST = 2.5;
    private static final double FLUID_TRANSPORT_COST = 0.05;

    @SideOnly(value=Side.CLIENT)
    public int getTicksSinceAction() {
        return this.ticksSinceAction;
    }

    @SideOnly(value=Side.CLIENT)
    public int getTicksSinceNotEnoughAir() {
        return this.ticksSinceNotEnoughAir;
    }

    @Override
    public double getWidth() {
        return 0.8125;
    }

    @Override
    protected double getHeight() {
        return 0.28125;
    }

    @Override
    public String getType() {
        return "logistics_module";
    }

    @Override
    protected GuiHandler.EnumGuiId getGuiId() {
        return null;
    }

    @Override
    public Class<? extends ModelModuleBase> getModelClass() {
        return ModelLogistics.class;
    }

    public int getColorChannel() {
        return this.colorChannel;
    }

    public void setColorChannel(int colorChannel) {
        this.colorChannel = colorChannel;
    }

    public boolean hasPower() {
        return this.powered;
    }

    public void onUpdatePacket(int status, int colorChannel) {
        boolean bl = this.powered = status > 0;
        if (status == 2) {
            this.ticksSinceAction = 0;
        }
        if (status == 3) {
            this.ticksSinceNotEnoughAir = 0;
        }
        this.colorChannel = colorChannel;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbt) {
        super.writeToNBT(nbt);
        nbt.func_74757_a("powered", this.powered);
        nbt.func_74774_a("colorChannel", (byte)this.colorChannel);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbt) {
        super.readFromNBT(nbt);
        this.powered = nbt.func_74767_n("powered");
        this.colorChannel = nbt.func_74771_c("colorChannel");
    }

    public SemiBlockLogistics getFrame() {
        if (this.cachedFrame == null) {
            this.cachedFrame = SemiBlockManager.getInstance(this.getTube().world()).getSemiBlock(SemiBlockLogistics.class, this.getTube().world(), this.getTube().pos().func_177972_a(this.dir));
        }
        return this.cachedFrame;
    }

    @Override
    public boolean onActivated(EntityPlayer player) {
        int colorIndex;
        if (!player.func_184614_ca().func_190926_b() && (colorIndex = TileEntityPlasticMixer.getDyeIndex(player.func_184614_ca())) >= 0) {
            if (!player.field_70170_p.field_72995_K) {
                this.colorChannel = colorIndex;
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(this, 0), this.getTube().world());
            }
            return true;
        }
        return super.onActivated(player);
    }

    @Override
    public void update() {
        super.update();
        if (this.cachedFrame != null && this.cachedFrame.isInvalid()) {
            this.cachedFrame = null;
        }
        if (!this.getTube().world().field_72995_K) {
            if (this.powered != (double)this.getTube().getAirHandler(null).getPressure() >= 3.0) {
                this.powered = !this.powered;
                NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(this, 0), this.getTube().world());
            }
            if (--this.ticksUntilNextCycle <= 0) {
                LogisticsManager manager = new LogisticsManager();
                HashMap<SemiBlockLogistics, ModuleLogistics> frameToModuleMap = new HashMap<SemiBlockLogistics, ModuleLogistics>();
                for (TubeModule module : ModuleNetworkManager.getInstance().getConnectedModules(this)) {
                    ModuleLogistics logistics;
                    if (!(module instanceof ModuleLogistics) || (logistics = (ModuleLogistics)module).getColorChannel() != this.getColorChannel()) continue;
                    logistics.ticksUntilNextCycle = 100;
                    if (!logistics.hasPower() || logistics.getFrame() == null) continue;
                    frameToModuleMap.put(logistics.getFrame(), logistics);
                    manager.addLogisticFrame(logistics.getFrame());
                }
                PriorityQueue<LogisticsManager.LogisticsTask> tasks = manager.getTasks(null);
                block1: for (LogisticsManager.LogisticsTask task : tasks) {
                    if (!task.isStillValid(task.transportingItem.func_190926_b() ? task.transportingFluid.stack : task.transportingItem)) continue;
                    if (!task.transportingItem.func_190926_b()) {
                        IAirHandler receiverAirHandler;
                        ItemStack remainder = IOHelper.insert(task.requester.getTileEntity(), task.transportingItem.func_77946_l(), true);
                        if (remainder.func_190916_E() == task.transportingItem.func_190916_E()) continue;
                        ItemStack toBeExtracted = task.transportingItem.func_77946_l();
                        toBeExtracted.func_190918_g(remainder.func_190916_E());
                        IItemHandler handler = IOHelper.getInventoryForTE(task.provider.getTileEntity(), this.dir);
                        ItemStack extractedStack = IOHelper.extract(handler, toBeExtracted, IOHelper.ExtractCount.UP_TO, true, false);
                        if (extractedStack.func_190926_b()) continue;
                        ModuleLogistics provider = (ModuleLogistics)frameToModuleMap.get(task.provider);
                        ModuleLogistics requester = (ModuleLogistics)frameToModuleMap.get(task.requester);
                        int airUsed = (int)(2.5 * (double)extractedStack.func_190916_E() * PneumaticCraftUtils.distBetween((Vec3i)provider.getTube().pos(), (Vec3i)requester.getTube().pos()));
                        if (airUsed > (receiverAirHandler = requester.getTube().getAirHandler(null)).getAir()) {
                            double scale = (double)receiverAirHandler.getAir() / (double)airUsed;
                            extractedStack.func_190920_e((int)((double)extractedStack.func_190916_E() * scale));
                            airUsed = (int)((double)airUsed * scale);
                        }
                        if (extractedStack.func_190926_b()) {
                            this.sendModuleUpdate(provider, false);
                            this.sendModuleUpdate(requester, false);
                            continue;
                        }
                        this.sendModuleUpdate(provider, true);
                        this.sendModuleUpdate(requester, true);
                        receiverAirHandler.addAir(-airUsed);
                        IOHelper.extract(handler, extractedStack, IOHelper.ExtractCount.EXACT, false, false);
                        IOHelper.insert(task.requester.getTileEntity(), extractedStack, false);
                        this.ticksUntilNextCycle = 20;
                        continue;
                    }
                    Object providingTE = task.provider.getTileEntity();
                    Object requestingTE = task.requester.getTileEntity();
                    for (EnumFacing requesterFace : EnumFacing.field_82609_l) {
                        IFluidHandler requester;
                        int amountFilled;
                        if (!requestingTE.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requesterFace) || (amountFilled = (requester = (IFluidHandler)requestingTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, requesterFace)).fill(task.transportingFluid.stack, false)) <= 0) continue;
                        FluidStack drainingFluid = task.transportingFluid.stack.copy();
                        drainingFluid.amount = amountFilled;
                        FluidStack extractedFluid = null;
                        ModuleLogistics p = (ModuleLogistics)frameToModuleMap.get(task.provider);
                        ModuleLogistics r = (ModuleLogistics)frameToModuleMap.get(task.requester);
                        double airUsed = 0.0;
                        for (EnumFacing providerFace : EnumFacing.field_82609_l) {
                            IFluidHandler provider;
                            if (!providingTE.hasCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, providerFace) || (extractedFluid = (provider = (IFluidHandler)providingTE.getCapability(CapabilityFluidHandler.FLUID_HANDLER_CAPABILITY, providerFace)).drain(drainingFluid, false)) == null) continue;
                            IAirHandler receiverAirHandler = r.getTube().getAirHandler(null);
                            airUsed = 0.05 * (double)extractedFluid.amount * PneumaticCraftUtils.distBetween((Vec3i)p.getTube().pos(), (Vec3i)r.getTube().pos());
                            if (airUsed > (double)receiverAirHandler.getAir()) {
                                double scale = (double)receiverAirHandler.getAir() / airUsed;
                                drainingFluid.amount = (int)((double)extractedFluid.amount * scale);
                                airUsed *= scale;
                            }
                            if (drainingFluid.amount == 0) {
                                this.sendModuleUpdate(p, false);
                                this.sendModuleUpdate(r, false);
                                extractedFluid = null;
                                break;
                            }
                            extractedFluid = provider.drain(drainingFluid, true);
                            break;
                        }
                        if (extractedFluid == null) continue block1;
                        this.sendModuleUpdate(p, true);
                        this.sendModuleUpdate(r, true);
                        r.getTube().getAirHandler(null).addAir(-((int)airUsed));
                        requester.fill(extractedFluid, true);
                        this.ticksUntilNextCycle = 20;
                        continue block1;
                    }
                }
            }
        } else {
            if (this.ticksSinceAction >= 0) {
                ++this.ticksSinceAction;
                if (this.ticksSinceAction > 3) {
                    this.ticksSinceAction = -1;
                }
            }
            if (this.ticksSinceNotEnoughAir >= 0) {
                ++this.ticksSinceNotEnoughAir;
                if (this.ticksSinceNotEnoughAir > 20) {
                    this.ticksSinceNotEnoughAir = -1;
                }
            }
        }
    }

    private void sendModuleUpdate(ModuleLogistics module, boolean enoughAir) {
        NetworkHandler.sendToAllAround(new PacketUpdateLogisticModule(module, enoughAir ? 1 : 2), module.getTube().world());
    }

    @Override
    public void addInfo(List<String> curInfo) {
        super.addInfo(curInfo);
        String status = this.ticksSinceAction >= 0 ? "waila.logisticsModule.transporting" : (this.ticksSinceNotEnoughAir >= 0 ? "waila.logisticsModule.notEnoughAir" : (this.hasPower() ? "waila.logisticsModule.powered" : "waila.logisticsModule.noPower"));
        curInfo.add(PneumaticCraftUtils.xlate("hud.msg.state") + ": " + PneumaticCraftUtils.xlate(status));
        curInfo.add(PneumaticCraftUtils.xlate("waila.logisticsModule.channel") + " " + TextFormatting.YELLOW + PneumaticCraftUtils.xlate("item.fireworksCharge." + EnumDyeColor.func_176766_a((int)this.colorChannel).func_176762_d()));
    }
}

