/*
 * Decompiled with CFR 0.152.
 */
package me.desht.pneumaticcraft.common.block;

import javax.annotation.Nullable;
import me.desht.pneumaticcraft.PneumaticCraftRepressurized;
import me.desht.pneumaticcraft.api.item.IItemRegistry;
import me.desht.pneumaticcraft.common.GuiHandler;
import me.desht.pneumaticcraft.common.block.BlockPneumaticCraftModeled;
import me.desht.pneumaticcraft.common.item.Itemss;
import me.desht.pneumaticcraft.common.tileentity.TileEntitySecurityStation;
import me.desht.pneumaticcraft.common.util.UpgradableItemUtils;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockSecurityStation
extends BlockPneumaticCraftModeled {
    private static final AxisAlignedBB BLOCK_BOUNDS = new AxisAlignedBB(0.0625, 0.0, 0.0625, 0.9375, 0.6875, 0.9375);
    private static final AxisAlignedBB COLLISION_BOUNDS = new AxisAlignedBB(0.0625, 0.0625, 0.0625, 0.9375, 0.6875, 0.9375);

    BlockSecurityStation() {
        super(Material.field_151573_f, "security_station");
        this.setBlockBounds(BLOCK_BOUNDS);
    }

    @Nullable
    public AxisAlignedBB func_180646_a(IBlockState blockState, IBlockAccess worldIn, BlockPos pos) {
        return COLLISION_BOUNDS;
    }

    @Override
    protected Class<? extends TileEntity> getTileEntityClass() {
        return TileEntitySecurityStation.class;
    }

    @Override
    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase entityLiving, ItemStack iStack) {
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TileEntitySecurityStation && entityLiving != null) {
            ((TileEntitySecurityStation)te).sharedUsers.add(((EntityPlayer)entityLiving).func_146103_bH());
        }
        super.func_180633_a(world, pos, state, entityLiving, iStack);
    }

    @Override
    public boolean isRotatable() {
        return true;
    }

    @Override
    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float par7, float par8, float par9) {
        TileEntitySecurityStation te;
        if (player.func_70093_af()) {
            return false;
        }
        if (!world.field_72995_K && (te = (TileEntitySecurityStation)world.func_175625_s(pos)) != null) {
            if (te.isPlayerOnWhiteList(player)) {
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.SECURITY_STATION_INVENTORY.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            } else if (!te.hasValidNetwork()) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "This Security Station is out of order: Its network hasn't been properly configured."), false);
            } else if (te.hasPlayerHacked(player)) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.GREEN + "You've already hacked this Security Station!"), false);
            } else if (this.getPlayerHackLevel(player) < te.getSecurityLevel()) {
                player.func_146105_b((ITextComponent)new TextComponentString(TextFormatting.RED + "You can't access or hack this Security Station. To hack it you need at least a Pneumatic Helmet upgraded with " + te.getSecurityLevel() + " Security upgrade(s)."), false);
            } else {
                player.openGui((Object)PneumaticCraftRepressurized.instance, GuiHandler.EnumGuiId.HACKING.ordinal(), world, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p());
            }
        }
        return true;
    }

    private int getPlayerHackLevel(EntityPlayer player) {
        ItemStack armorStack = player.func_184582_a(EntityEquipmentSlot.HEAD);
        return armorStack.func_77973_b() == Itemss.PNEUMATIC_HELMET ? UpgradableItemUtils.getUpgrades(IItemRegistry.EnumUpgrade.SECURITY, armorStack) : 0;
    }

    public boolean func_149744_f(IBlockState state) {
        return true;
    }

    public int func_180656_a(IBlockState blockState, IBlockAccess blockAccess, BlockPos pos, EnumFacing side) {
        TileEntity te = blockAccess.func_175625_s(pos);
        if (te instanceof TileEntitySecurityStation) {
            return ((TileEntitySecurityStation)te).shouldEmitRedstone() ? 15 : 0;
        }
        return 0;
    }
}

